/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResource;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;

public class InfinispanResourceDescriptionResolver
extends StandardResourceDescriptionResolver {
    private Map<String, String> sharedAttributeResolver = new HashMap<String, String>();

    public InfinispanResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
        super(keyPrefix, bundleBaseName, bundleLoader, true, false);
        this.initMap();
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getBundleKey(attributeName));
        }
        return super.getResourceAttributeDescription(attributeName, locale, bundle2);
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
        if (this.sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getVariableBundleKey(attributeName, suffixes));
        }
        return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle2, suffixes);
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getBundleKey(paramName));
        }
        return super.getOperationParameterDescription(operationName, paramName, locale, bundle2);
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
        if (this.sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getVariableBundleKey(paramName, suffixes));
        }
        return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle2, suffixes);
    }

    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle2) {
        if (this.sharedAttributeResolver.containsKey(childType)) {
            return bundle2.getString(this.getBundleKey(childType));
        }
        return super.getChildTypeDescription(childType, locale, bundle2);
    }

    private String getBundleKey(String name) {
        return this.getVariableBundleKey(name, new String[0]);
    }

    private String getVariableBundleKey(String name, String ... variable) {
        String prefix = this.sharedAttributeResolver.get(name);
        StringBuilder sb = new StringBuilder("infinispan");
        sb = prefix == null ? sb.append('.').append(name) : sb.append('.').append(prefix).append('.').append(name);
        if (variable != null) {
            for (String arg : variable) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(arg);
            }
        }
        return sb.toString();
    }

    private void initMap() {
        this.sharedAttributeResolver.put(CacheResource.BATCHING.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResource.CACHE_MODULE.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResource.INDEXING.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResource.INDEXING_PROPERTIES.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResource.JNDI_NAME.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResource.NAME.getName(), "cache");
        this.sharedAttributeResolver.put(CacheResource.START.getName(), "cache");
        this.sharedAttributeResolver.put(ClusteredCacheResource.ASYNC_MARSHALLING.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResource.MODE.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResource.QUEUE_FLUSH_INTERVAL.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResource.QUEUE_SIZE.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(ClusteredCacheResource.REMOTE_TIMEOUT.getName(), "clustered-cache");
        this.sharedAttributeResolver.put(BaseStoreResource.PROPERTIES.getName(), "loader");
        this.sharedAttributeResolver.put(BaseStoreResource.FETCH_STATE.getName(), "store");
        this.sharedAttributeResolver.put(BaseStoreResource.PASSIVATION.getName(), "store");
        this.sharedAttributeResolver.put(BaseStoreResource.PRELOAD.getName(), "store");
        this.sharedAttributeResolver.put(BaseStoreResource.PURGE.getName(), "store");
        this.sharedAttributeResolver.put(BaseStoreResource.READ_ONLY.getName(), "store");
        this.sharedAttributeResolver.put(BaseStoreResource.SHARED.getName(), "store");
        this.sharedAttributeResolver.put(BaseStoreResource.SINGLETON.getName(), "store");
        this.sharedAttributeResolver.put(BaseStoreResource.PROPERTY.getName(), "store");
        this.sharedAttributeResolver.put(BaseStoreResource.PROPERTIES.getName(), "store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.DATA_SOURCE.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.BATCH_SIZE.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.FETCH_SIZE.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.PREFIX.getName(), "jdbc-store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.ID_COLUMN.getName() + ".column", "jdbc-store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.DATA_COLUMN.getName() + ".column", "jdbc-store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.TIMESTAMP_COLUMN.getName() + ".column", "jdbc-store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.ENTRY_TABLE.getName() + "table", "jdbc-store");
        this.sharedAttributeResolver.put(BaseJDBCStoreResource.BUCKET_TABLE.getName() + "table", "jdbc-store");
        this.sharedAttributeResolver.put("transport", null);
        this.sharedAttributeResolver.put("locking", null);
        this.sharedAttributeResolver.put("transaction", null);
        this.sharedAttributeResolver.put("eviction", null);
        this.sharedAttributeResolver.put("expiration", null);
        this.sharedAttributeResolver.put("state-transfer", null);
        this.sharedAttributeResolver.put("backup", null);
        this.sharedAttributeResolver.put("loader", null);
        this.sharedAttributeResolver.put("compatibility", null);
        this.sharedAttributeResolver.put("cluster-loader", null);
        this.sharedAttributeResolver.put("store", null);
        this.sharedAttributeResolver.put("file-store", null);
        this.sharedAttributeResolver.put("remote-store", null);
        this.sharedAttributeResolver.put("rest-store", null);
        this.sharedAttributeResolver.put("string-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("binary-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("mixed-keyed-jdbc-store", null);
        this.sharedAttributeResolver.put("write-behind", null);
        this.sharedAttributeResolver.put("property", null);
        this.sharedAttributeResolver.put("implementation", null);
        this.sharedAttributeResolver.put("compression", null);
        this.sharedAttributeResolver.put("expiration", null);
        this.sharedAttributeResolver.put("leveldb-store", null);
    }
}

