/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.net.URL;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class UploadProtoFileOperationHandler
implements OperationStepHandler {
    public static final UploadProtoFileOperationHandler INSTANCE = new UploadProtoFileOperationHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode newValue = operation.require(CacheContainerResource.PROTO_URL.getName());
        String urlString = newValue.asString();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(EmbeddedCacheManagerService.getServiceName(cacheContainerName));
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)controller.getValue();
        ProtobufMetadataManager protoManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (protoManager != null) {
            try {
                URL url = new URL(urlString);
                protoManager.registerProtofile(url.openStream());
            }
            catch (Exception e) {
                throw new OperationFailedException(new ModelNode().set(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage())));
            }
        }
        context.stepCompleted();
    }
}

