/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseLoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResource;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBCompressionResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBImplementationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderPropertyResource;
import org.jboss.as.clustering.infinispan.subsystem.LoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.RestStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResource;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResource;
import org.jboss.as.clustering.infinispan.subsystem.TransportResource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;

public class CacheConfigOperationHandlers {
    static final OperationStepHandler TRANSPORT_ADD = new CacheConfigAdd(TransportResource.TRANSPORT_ATTRIBUTES);
    static final OperationStepHandler CONTAINER_SECURITY_ADD = new CacheConfigAdd();
    static final OperationStepHandler LOCKING_ADD = new CacheConfigAdd(LockingResource.LOCKING_ATTRIBUTES);
    static final OperationStepHandler TRANSACTION_ADD = new CacheConfigAdd(TransactionResource.TRANSACTION_ATTRIBUTES);
    static final OperationStepHandler EVICTION_ADD = new CacheConfigAdd(EvictionResource.EVICTION_ATTRIBUTES);
    static final OperationStepHandler EXPIRATION_ADD = new CacheConfigAdd(ExpirationResource.EXPIRATION_ATTRIBUTES);
    static final OperationStepHandler STATE_TRANSFER_ADD = new CacheConfigAdd(StateTransferResource.STATE_TRANSFER_ATTRIBUTES);
    static final OperationStepHandler CACHE_SECURITY_ADD = new CacheConfigAdd();
    static final OperationStepHandler LOADER_ADD = new CacheLoaderAdd();
    static final OperationStepHandler LOADER_PROPERTY_ADD = new CacheConfigAdd(new AttributeDefinition[]{LoaderPropertyResource.VALUE});
    static final OperationStepHandler CLUSTER_LOADER_ADD = new ClusterCacheLoaderAdd();
    static final OperationStepHandler STORE_ADD = new CacheStoreAdd();
    static final OperationStepHandler STORE_WRITE_BEHIND_ADD = new CacheConfigAdd(StoreWriteBehindResource.WRITE_BEHIND_ATTRIBUTES);
    static final OperationStepHandler FILE_STORE_ADD = new FileCacheStoreAdd();
    static final OperationStepHandler STRING_KEYED_JDBC_STORE_ADD = new StringKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler BINARY_KEYED_JDBC_STORE_ADD = new BinaryKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler MIXED_KEYED_JDBC_STORE_ADD = new MixedKeyedJDBCCacheStoreAdd();
    static final OperationStepHandler REMOTE_STORE_ADD = new RemoteCacheStoreAdd();
    static final OperationStepHandler LEVELDB_STORE_ADD = new LevelDBCacheStoreAdd();
    static final OperationStepHandler LEVELDB_EXPIRATION_ADD = new CacheConfigAdd(LevelDBExpirationResource.LEVELDB_EXPIRATION_ATTRIBUTES);
    static final OperationStepHandler LEVELDB_COMPRESSION_ADD = new CacheConfigAdd(LevelDBCompressionResource.LEVELDB_COMPRESSION_ATTRIBUTES);
    static final OperationStepHandler LEVELDB_IMPLEMENTATION_ADD = new CacheConfigAdd(LevelDBImplementationResource.LEVELDB_IMPLEMENTATION_ATTRIBUTES);
    static final OperationStepHandler REST_STORE_ADD = new RestCacheStoreAdd();

    private static AttributeDefinition[] concat(AttributeDefinition[] A, AttributeDefinition[] B) {
        AttributeDefinition[] C;
        int aLen = A.length;
        int bLen = B.length;
        if (bLen > 0) {
            C = Arrays.copyOf(A, aLen + bLen);
            System.arraycopy(B, 0, C, aLen, bLen);
        } else {
            C = A;
        }
        return C;
    }

    private static class RestCacheStoreAdd
    extends AbstractCacheStoreAdd {
        RestCacheStoreAdd() {
            super(RestStoreResource.REST_STORE_ATTRIBUTES);
        }
    }

    private static class LevelDBCacheStoreAdd
    extends AbstractCacheStoreAdd {
        LevelDBCacheStoreAdd() {
            super(LevelDBStoreResource.LEVELDB_STORE_ATTRIBUTES);
        }
    }

    private static class RemoteCacheStoreAdd
    extends AbstractCacheStoreAdd {
        RemoteCacheStoreAdd() {
            super(RemoteStoreResource.REMOTE_STORE_ATTRIBUTES);
        }
    }

    private static class MixedKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] attributes = MixedKeyedJDBCStoreResource.MIXED_KEYED_JDBC_STORE_ATTRIBUTES;

        MixedKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class BinaryKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] additionalAttributes = BinaryKeyedJDBCStoreResource.BINARY_KEYED_JDBC_STORE_ATTRIBUTES;

        BinaryKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.additionalAttributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class StringKeyedJDBCCacheStoreAdd
    extends JDBCCacheStoreAdd {
        private final AttributeDefinition[] additionalAttributes = StringKeyedJDBCStoreResource.STRING_KEYED_JDBC_STORE_ATTRIBUTES;

        StringKeyedJDBCCacheStoreAdd() {
        }

        @Override
        protected void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            super.populateSubclassModel(context, operation, model);
            for (AttributeDefinition attribute : this.additionalAttributes) {
                attribute.validateAndSet(operation, model);
            }
        }
    }

    private static class JDBCCacheStoreAdd
    extends AbstractCacheStoreAdd {
        JDBCCacheStoreAdd() {
            super(BaseJDBCStoreResource.COMMON_JDBC_STORE_ATTRIBUTES);
        }
    }

    private static class FileCacheStoreAdd
    extends AbstractCacheStoreAdd {
        FileCacheStoreAdd() {
            super(FileStoreResource.FILE_STORE_ATTRIBUTES);
        }
    }

    private static class CacheStoreAdd
    extends AbstractCacheStoreAdd {
        CacheStoreAdd() {
            super(StoreResource.STORE_ATTRIBUTES);
        }
    }

    static abstract class AbstractCacheStoreAdd
    extends AbstractCacheLoaderAdd {
        AbstractCacheStoreAdd() {
            super(BaseStoreResource.COMMON_STORE_PARAMETERS);
        }

        AbstractCacheStoreAdd(AttributeDefinition[] attributes) {
            super(CacheConfigOperationHandlers.concat(BaseStoreResource.COMMON_STORE_PARAMETERS, attributes));
        }
    }

    private static class ClusterCacheLoaderAdd
    extends AbstractCacheLoaderAdd {
        ClusterCacheLoaderAdd() {
            super(ClusterLoaderResource.CLUSTER_LOADER_ATTRIBUTES, true);
        }
    }

    private static class CacheLoaderAdd
    extends AbstractCacheLoaderAdd {
        CacheLoaderAdd() {
            super(LoaderResource.LOADER_ATTRIBUTES, true);
        }
    }

    static abstract class AbstractCacheLoaderAdd
    extends AbstractAddStepHandler {
        protected final AttributeDefinition[] attributes;

        AbstractCacheLoaderAdd() {
            this(BaseLoaderResource.COMMON_LOADER_PARAMETERS);
        }

        AbstractCacheLoaderAdd(AttributeDefinition[] attributes) {
            this(attributes, false);
        }

        AbstractCacheLoaderAdd(AttributeDefinition[] attributes, boolean includeCommonLoaderAttributes) {
            this.attributes = includeCommonLoaderAttributes ? CacheConfigOperationHandlers.concat(BaseLoaderResource.COMMON_LOADER_PARAMETERS, attributes) : attributes;
        }

        protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            ModelNode model = resource.getModel();
            for (AttributeDefinition attribute : this.attributes) {
                if (attribute.getName().equals(BaseStoreResource.PROPERTIES.getName())) continue;
                attribute.validateAndSet(operation, model);
            }
            this.populateSubclassModel(context, operation, model);
            if (operation.hasDefined("properties")) {
                for (ModelNode node : operation.get("properties").asList()) {
                    for (Property property : node.asPropertyList()) {
                        Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                        ModelNode value = property.getValue();
                        if (!value.isDefined()) {
                            throw InfinispanMessages.MESSAGES.propertyValueNotDefined(property.getName());
                        }
                        ModelNode holder = new ModelNode();
                        holder.get(LoaderPropertyResource.VALUE.getName()).set(value);
                        LoaderPropertyResource.VALUE.validateAndSet(holder, param.getModel());
                    }
                }
            }
        }

        void populateSubclassModel(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attribute : this.attributes) {
                attribute.validateAndSet(operation, model);
            }
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        }
    }

    public static class CacheConfigAdd
    extends AbstractAddStepHandler {
        private final AttributeDefinition[] attributes;

        CacheConfigAdd() {
            this.attributes = new AttributeDefinition[0];
        }

        CacheConfigAdd(AttributeDefinition[] attributes) {
            this.attributes = attributes;
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (AttributeDefinition attr : this.attributes) {
                attr.validateAndSet(operation, model);
            }
        }

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
            super.performRuntime(context, operation, model, verificationHandler, newControllers);
            context.reloadRequired();
        }
    }
}

