/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResource;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;

public class InfinispanResourceDescriptionResolver
extends StandardResourceDescriptionResolver {
    private static final Map<String, String> sharedAttributeResolver = new HashMap<String, String>();

    public InfinispanResourceDescriptionResolver(String keyPrefix, String bundleBaseName, ClassLoader bundleLoader) {
        super(keyPrefix, bundleBaseName, bundleLoader, true, false);
    }

    public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle2) {
        if (sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getBundleKey(attributeName));
        }
        return super.getResourceAttributeDescription(attributeName, locale, bundle2);
    }

    public String getResourceAttributeValueTypeDescription(String attributeName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
        if (sharedAttributeResolver.containsKey(attributeName)) {
            return bundle2.getString(this.getVariableBundleKey(attributeName, suffixes));
        }
        return super.getResourceAttributeValueTypeDescription(attributeName, locale, bundle2, suffixes);
    }

    public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2) {
        if (sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getBundleKey(paramName));
        }
        return super.getOperationParameterDescription(operationName, paramName, locale, bundle2);
    }

    public String getOperationParameterValueTypeDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle2, String ... suffixes) {
        if (sharedAttributeResolver.containsKey(paramName)) {
            return bundle2.getString(this.getVariableBundleKey(paramName, suffixes));
        }
        return super.getOperationParameterValueTypeDescription(operationName, paramName, locale, bundle2, suffixes);
    }

    public String getChildTypeDescription(String childType, Locale locale, ResourceBundle bundle2) {
        if (sharedAttributeResolver.containsKey(childType)) {
            return bundle2.getString(this.getBundleKey(childType));
        }
        return super.getChildTypeDescription(childType, locale, bundle2);
    }

    private String getBundleKey(String name) {
        return this.getVariableBundleKey(name, new String[0]);
    }

    private String getVariableBundleKey(String name, String ... variable) {
        String prefix = sharedAttributeResolver.get(name);
        StringBuilder sb = new StringBuilder("infinispan");
        sb = prefix == null ? sb.append('.').append(name) : sb.append('.').append(prefix).append('.').append(name);
        if (variable != null) {
            for (String arg : variable) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(arg);
            }
        }
        return sb.toString();
    }

    static {
        sharedAttributeResolver.put(CacheResource.BATCHING.getName(), "cache");
        sharedAttributeResolver.put(CacheResource.CACHE_MODULE.getName(), "cache");
        sharedAttributeResolver.put(CacheResource.INDEXING.getName(), "cache");
        sharedAttributeResolver.put(CacheResource.INDEXING_AUTO_CONFIG.getName(), "cache");
        sharedAttributeResolver.put(CacheResource.INDEXING_PROPERTIES.getName(), "cache");
        sharedAttributeResolver.put(CacheResource.JNDI_NAME.getName(), "cache");
        sharedAttributeResolver.put(CacheResource.NAME.getName(), "cache");
        sharedAttributeResolver.put(CacheResource.START.getName(), "cache");
        sharedAttributeResolver.put(CacheResource.STATISTICS.getName(), "cache");
        sharedAttributeResolver.put(ClusteredCacheResource.ASYNC_MARSHALLING.getName(), "clustered-cache");
        sharedAttributeResolver.put(ClusteredCacheResource.MODE.getName(), "clustered-cache");
        sharedAttributeResolver.put(ClusteredCacheResource.QUEUE_FLUSH_INTERVAL.getName(), "clustered-cache");
        sharedAttributeResolver.put(ClusteredCacheResource.QUEUE_SIZE.getName(), "clustered-cache");
        sharedAttributeResolver.put(ClusteredCacheResource.REMOTE_TIMEOUT.getName(), "clustered-cache");
        sharedAttributeResolver.put(BaseStoreResource.PROPERTIES.getName(), "loader");
        sharedAttributeResolver.put(BaseStoreResource.FETCH_STATE.getName(), "store");
        sharedAttributeResolver.put(BaseStoreResource.PASSIVATION.getName(), "store");
        sharedAttributeResolver.put(BaseStoreResource.PRELOAD.getName(), "store");
        sharedAttributeResolver.put(BaseStoreResource.PURGE.getName(), "store");
        sharedAttributeResolver.put(BaseStoreResource.READ_ONLY.getName(), "store");
        sharedAttributeResolver.put(BaseStoreResource.SHARED.getName(), "store");
        sharedAttributeResolver.put(BaseStoreResource.SINGLETON.getName(), "store");
        sharedAttributeResolver.put(BaseStoreResource.PROPERTY.getName(), "store");
        sharedAttributeResolver.put(BaseStoreResource.PROPERTIES.getName(), "store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.DATA_SOURCE.getName(), "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.DIALECT.getName(), "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.BATCH_SIZE.getName(), "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.FETCH_SIZE.getName(), "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.PREFIX.getName(), "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.ID_COLUMN.getName() + ".column", "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.DATA_COLUMN.getName() + ".column", "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.TIMESTAMP_COLUMN.getName() + ".column", "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.ENTRY_TABLE.getName() + "table", "jdbc-store");
        sharedAttributeResolver.put(BaseJDBCStoreResource.BUCKET_TABLE.getName() + "table", "jdbc-store");
        sharedAttributeResolver.put("average-read-time", "cache");
        sharedAttributeResolver.put("average-remove-time", "cache");
        sharedAttributeResolver.put("average-write-time", "cache");
        sharedAttributeResolver.put("cache-name", "cache");
        sharedAttributeResolver.put("cache-status", "cache");
        sharedAttributeResolver.put("commits", "cache");
        sharedAttributeResolver.put("concurrency-level", "cache");
        sharedAttributeResolver.put("evictions", "cache");
        sharedAttributeResolver.put("elapsed-time", "cache");
        sharedAttributeResolver.put("hit-ratio", "cache");
        sharedAttributeResolver.put("hits", "cache");
        sharedAttributeResolver.put("invalidations", "cache");
        sharedAttributeResolver.put("misses", "cache");
        sharedAttributeResolver.put("number-of-entries", "cache");
        sharedAttributeResolver.put("number-of-locks-available", "cache");
        sharedAttributeResolver.put("number-of-locks-held", "cache");
        sharedAttributeResolver.put("prepares", "cache");
        sharedAttributeResolver.put("read-write-ratio", "cache");
        sharedAttributeResolver.put("remove-hits", "cache");
        sharedAttributeResolver.put("remove-misses", "cache");
        sharedAttributeResolver.put("rollbacks", "cache");
        sharedAttributeResolver.put("stores", "cache");
        sharedAttributeResolver.put("time-since-reset", "cache");
        sharedAttributeResolver.put("version", "cache");
        sharedAttributeResolver.put("average-replication-time", "clustered-cache");
        sharedAttributeResolver.put("replication-count", "clustered-cache");
        sharedAttributeResolver.put("replication-failures", "clustered-cache");
        sharedAttributeResolver.put("success-ratio", "clustered-cache");
        sharedAttributeResolver.put("activations", "loader");
        sharedAttributeResolver.put("cache-loader-loads", "loader");
        sharedAttributeResolver.put("cache-loader-misses", "loader");
        sharedAttributeResolver.put("cache-loader-stores", "loader");
        sharedAttributeResolver.put("passivations", "loader");
        sharedAttributeResolver.put("transport", null);
        sharedAttributeResolver.put("security", "cache");
        sharedAttributeResolver.put("locking", null);
        sharedAttributeResolver.put("transaction", null);
        sharedAttributeResolver.put("eviction", null);
        sharedAttributeResolver.put("expiration", null);
        sharedAttributeResolver.put("state-transfer", null);
        sharedAttributeResolver.put("partition-handling", null);
        sharedAttributeResolver.put("backup", null);
        sharedAttributeResolver.put("loader", null);
        sharedAttributeResolver.put("compatibility", null);
        sharedAttributeResolver.put("cluster-loader", null);
        sharedAttributeResolver.put("store", null);
        sharedAttributeResolver.put("file-store", null);
        sharedAttributeResolver.put("remote-store", null);
        sharedAttributeResolver.put("rest-store", null);
        sharedAttributeResolver.put("string-keyed-jdbc-store", null);
        sharedAttributeResolver.put("binary-keyed-jdbc-store", null);
        sharedAttributeResolver.put("mixed-keyed-jdbc-store", null);
        sharedAttributeResolver.put("write-behind", null);
        sharedAttributeResolver.put("property", null);
        sharedAttributeResolver.put("implementation", null);
        sharedAttributeResolver.put("compression", null);
        sharedAttributeResolver.put("leveldb-store", null);
    }
}

