/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class RegisterProtoSchemasOperationHandler
implements OperationStepHandler {
    public static final RegisterProtoSchemasOperationHandler INSTANCE = new RegisterProtoSchemasOperationHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(EmbeddedCacheManagerService.getServiceName(cacheContainerName));
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)controller.getValue();
        ProtobufMetadataManager protoManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (protoManager != null) {
            try {
                String nameParameter = CacheContainerResource.PROTO_NAMES.getName();
                String contentParameter = CacheContainerResource.PROTO_CONTENTS.getName();
                ModelNode names = operation.require(nameParameter);
                ModelNode contents = operation.require(contentParameter);
                this.validateParameters(names, contents);
                List descriptorsNames = names.asList();
                List descriptorsContents = contents.asList();
                String[] nameArray = new String[descriptorsNames.size()];
                String[] contentArray = new String[descriptorsNames.size()];
                int i = 0;
                for (ModelNode modelNode : descriptorsNames) {
                    nameArray[i] = modelNode.asString();
                    contentArray[i] = ((ModelNode)descriptorsContents.get(i)).asString();
                    ++i;
                }
                protoManager.registerProtofiles(nameArray, contentArray);
            }
            catch (Exception e) {
                throw new OperationFailedException(new ModelNode().set(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage())));
            }
        }
        context.stepCompleted();
    }

    private void validateParameters(ModelNode name, ModelNode contents) {
        String requiredType = ModelType.LIST.toString();
        String nameParameter = CacheContainerResource.PROTO_NAMES.getName();
        String contentParameter = CacheContainerResource.PROTO_CONTENTS.getName();
        if (name.getType() != ModelType.LIST) {
            throw InfinispanMessages.MESSAGES.invalidParameterType(nameParameter, requiredType);
        }
        if (contents.getType() != ModelType.LIST) {
            throw InfinispanMessages.MESSAGES.invalidParameterType(contentParameter, requiredType);
        }
        if (name.asList().size() != contents.asList().size()) {
            throw InfinispanMessages.MESSAGES.invalidParameterSizes(nameParameter, contentParameter);
        }
    }
}

