/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.infinispan.Cache;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfiguredBy;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AuthorizationConfigurationBuilder;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ClusterLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.CustomStoreConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileStoreConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcMixedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;
import org.infinispan.persistence.leveldb.configuration.CompressionType;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfiguration;
import org.infinispan.persistence.leveldb.configuration.LevelDBStoreConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.persistence.rest.configuration.RestStoreConfigurationBuilder;
import org.infinispan.persistence.rest.metadata.MimeMetadataHelper;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.tm.BatchModeTransactionManager;
import org.infinispan.util.concurrent.IsolationLevel;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteStateTransferResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheAuthorizationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationService;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.infinispan.subsystem.CompatibilityResource;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResource;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.Indexing;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanJndiName;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBCompressionResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBImplementationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.StartMode;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResource;
import org.jboss.as.clustering.infinispan.subsystem.TransactionMode;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResource;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.naming.ManagedReferenceInjector;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.server.Services;
import org.jboss.as.txn.service.TxnServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jboss.tm.XAResourceRecoveryRegistry;

public abstract class CacheAdd
extends AbstractAddStepHandler {
    private static final Logger log = Logger.getLogger((String)CacheAdd.class.getPackage().getName());
    private static final String DEFAULTS = "infinispan-defaults.xml";
    private static volatile Map<CacheMode, Configuration> defaults = null;
    private static final String[] loaderKeys = new String[]{"loader", "cluster-loader"};
    private static final String[] storeKeys = new String[]{"store", "file-store", "string-keyed-jdbc-store", "binary-keyed-jdbc-store", "mixed-keyed-jdbc-store", "remote-store", "leveldb-store", "rest-store"};
    final CacheMode mode;

    public static synchronized Configuration getDefaultConfiguration(CacheMode cacheMode) {
        if (defaults == null) {
            ConfigurationBuilderHolder holder = CacheAdd.load(DEFAULTS);
            Configuration defaultConfig = holder.getDefaultConfigurationBuilder().build();
            EnumMap<CacheMode, Configuration> map = new EnumMap<CacheMode, Configuration>(CacheMode.class);
            map.put(defaultConfig.clustering().cacheMode(), defaultConfig);
            for (ConfigurationBuilder builder : holder.getNamedConfigurationBuilders().values()) {
                Configuration config = builder.build();
                map.put(config.clustering().cacheMode(), config);
            }
            for (CacheMode mode : CacheMode.values()) {
                if (map.containsKey(mode)) continue;
                map.put(mode, new ConfigurationBuilder().read(defaultConfig).clustering().cacheMode(mode).build());
            }
            defaults = map;
        }
        return defaults.get(cacheMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigurationBuilderHolder load(String resource) {
        ConfigurationBuilderHolder configurationBuilderHolder;
        URL url = CacheAdd.find(resource, CacheAdd.class.getClassLoader());
        log.debugf("Loading Infinispan defaults from %s", (Object)url.toString());
        InputStream input = url.openStream();
        ParserRegistry parser = new ParserRegistry(InfinispanExtension.class.getClassLoader());
        try {
            configurationBuilderHolder = parser.parse(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (IOException e) {
                    log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Failed to parse %s", url), e);
            }
        }
        try {
            input.close();
        }
        catch (IOException e) {
            log.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return configurationBuilderHolder;
    }

    private static URL find(String resource, ClassLoader ... loaders) {
        for (ClassLoader loader : loaders) {
            URL url;
            if (loader == null || (url = new FileLookup().lookupFileLocation(resource, loader)) == null) continue;
            return url;
        }
        throw new IllegalArgumentException(String.format("Failed to locate %s", resource));
    }

    CacheAdd(CacheMode mode) {
        this.mode = mode;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.populate(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ModelNode cacheModel = Resource.Tools.readModel((Resource)context.readResource(PathAddress.EMPTY_ADDRESS));
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        ModelNode containerModel = context.readResourceFromRoot(containerAddress).getModel();
        newControllers.addAll(this.installRuntimeServices(context, operation, containerModel, cacheModel, verificationHandler));
    }

    Collection<ServiceController<?>> installRuntimeServices(OperationContext context, ModelNode operation, ModelNode containerModel, ModelNode cacheModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CacheResource.JNDI_NAME.resolveModelAttribute(context, cacheModel);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ServiceController.Mode initialMode = StartMode.valueOf(CacheResource.START.resolveModelAttribute(context, cacheModel).asString()).getMode();
        resolvedValue = CacheResource.CACHE_MODULE.resolveModelAttribute(context, cacheModel);
        ModuleIdentifier moduleId = resolvedValue.isDefined() ? ModuleIdentifier.fromString((String)resolvedValue.asString()) : null;
        LinkedList dependencies = new LinkedList();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(CacheAdd.getDefaultConfiguration(this.mode));
        this.processModelNode(context, containerName, cacheModel, builder, dependencies);
        String defaultCache = CacheContainerResource.DEFAULT_CACHE.resolveModelAttribute(context, containerModel).asString();
        ServiceTarget target = context.getServiceTarget();
        Configuration config = builder.build();
        ArrayList controllers = new ArrayList(3);
        controllers.add(this.installCacheConfigurationService(target, containerName, cacheName, defaultCache, moduleId, builder, config, dependencies, verificationHandler));
        log.debugf("Cache configuration service for %s installed for container %s", (Object)cacheName, (Object)containerName);
        controllers.add(this.installCacheService(target, containerName, cacheName, defaultCache, initialMode, config, verificationHandler));
        controllers.add(this.installJndiService(target, containerName, cacheName, InfinispanJndiName.createCacheJndiName(jndiName, containerName, cacheName), verificationHandler));
        log.debugf("Cache service for cache %s installed for container %s", (Object)cacheName, (Object)containerName);
        return controllers;
    }

    void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = this.getCacheContainerAddressFromOperation(operation);
        String cacheName = cacheAddress.getLastElement().getValue();
        String containerName = containerAddress.getLastElement().getValue();
        ModelNode resolvedValue = null;
        resolvedValue = CacheResource.JNDI_NAME.resolveModelAttribute(context, model);
        String jndiName = resolvedValue.isDefined() ? resolvedValue.asString() : null;
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)InfinispanJndiName.createCacheJndiName(jndiName, containerName, cacheName));
        context.removeService(bindInfo.getBinderServiceName());
        context.removeService(CacheService.getServiceName(containerName, cacheName));
        context.removeService(CacheConfigurationService.getServiceName(containerName, cacheName));
        log.debugf("cache %s removed for container %s", (Object)cacheName, (Object)containerName);
    }

    protected PathAddress getCacheAddressFromOperation(ModelNode operation) {
        return PathAddress.pathAddress((ModelNode)operation.get("address"));
    }

    protected PathAddress getCacheContainerAddressFromOperation(ModelNode operation) {
        PathAddress cacheAddress = this.getCacheAddressFromOperation(operation);
        PathAddress containerAddress = cacheAddress.subAddress(0, cacheAddress.size() - 1);
        return containerAddress;
    }

    ServiceController<?> installCacheConfigurationService(ServiceTarget target, String containerName, String cacheName, String defaultCache, ModuleIdentifier moduleId, ConfigurationBuilder builder, Configuration config, List<Dependency<?>> dependencies, ServiceVerificationHandler verificationHandler) {
        InjectedValue container = new InjectedValue();
        CacheConfigurationDependencies cacheConfigurationDependencies = new CacheConfigurationDependencies((Value<EmbeddedCacheManager>)container);
        CacheConfigurationService service = new CacheConfigurationService(cacheName, builder, moduleId, cacheConfigurationDependencies);
        ServiceBuilder configBuilder = target.addService(CacheConfigurationService.getServiceName(containerName, cacheName), (Service)service).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), EmbeddedCacheManager.class, (Injector)container).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, cacheConfigurationDependencies.getModuleLoaderInjector()).setInitialMode(ServiceController.Mode.PASSIVE);
        if (config.invocationBatching().enabled()) {
            cacheConfigurationDependencies.getTransactionManagerInjector().inject((Object)BatchModeTransactionManager.getInstance());
        } else if (config.transaction().transactionMode() == org.infinispan.transaction.TransactionMode.TRANSACTIONAL) {
            configBuilder.addDependency(TxnServices.JBOSS_TXN_TRANSACTION_MANAGER, TransactionManager.class, cacheConfigurationDependencies.getTransactionManagerInjector());
            if (config.transaction().useSynchronization()) {
                configBuilder.addDependency(TxnServices.JBOSS_TXN_SYNCHRONIZATION_REGISTRY, TransactionSynchronizationRegistry.class, cacheConfigurationDependencies.getTransactionSynchronizationRegistryInjector());
            }
        }
        for (Dependency<?> dependency : dependencies) {
            this.addDependency(configBuilder, dependency);
        }
        if (cacheName.equals(defaultCache)) {
            configBuilder.addAliases(new ServiceName[]{CacheConfigurationService.getServiceName(containerName, null)});
        }
        return configBuilder.install();
    }

    ServiceController<?> installCacheService(ServiceTarget target, String containerName, String cacheName, String defaultCache, ServiceController.Mode initialMode, Configuration config, ServiceVerificationHandler verificationHandler) {
        InjectedValue container = new InjectedValue();
        CacheDependencies cacheDependencies = new CacheDependencies((Value<EmbeddedCacheManager>)container);
        CacheService service = new CacheService(cacheName, cacheDependencies);
        ServiceBuilder builder = target.addService(CacheService.getServiceName(containerName, cacheName), service).addDependency(CacheConfigurationService.getServiceName(containerName, cacheName)).addDependency(EmbeddedCacheManagerService.getServiceName(containerName), EmbeddedCacheManager.class, (Injector)container).setInitialMode(initialMode);
        if (config.transaction().recovery().enabled()) {
            builder.addDependency(TxnServices.JBOSS_TXN_ARJUNA_RECOVERY_MANAGER, XAResourceRecoveryRegistry.class, cacheDependencies.getRecoveryRegistryInjector());
        }
        if (cacheName.equals(defaultCache)) {
            builder.addAliases(new ServiceName[]{CacheService.getServiceName(containerName, null)});
        }
        if (initialMode == ServiceController.Mode.ACTIVE) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.install();
    }

    ServiceController<?> installJndiService(ServiceTarget target, String containerName, String cacheName, String jndiName, ServiceVerificationHandler verificationHandler) {
        ServiceName cacheServiceName = CacheService.getServiceName(containerName, cacheName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binder = new BinderService(bindInfo.getBindName());
        return target.addService(bindInfo.getBinderServiceName(), (Service)binder).addAliases(new ServiceName[]{ContextNames.JAVA_CONTEXT_SERVICE_NAME.append(new String[]{jndiName})}).addDependency(cacheServiceName, Cache.class, (Injector)new ManagedReferenceInjector((Injector)binder.getManagedObjectInjector())).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, (Injector)binder.getNamingStoreInjector()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    private <T> void addDependency(ServiceBuilder<?> builder, Dependency<T> dependency) {
        ServiceName name = dependency.getName();
        Injector<T> injector = dependency.getInjector();
        if (injector != null) {
            builder.addDependency(name, dependency.getType(), injector);
        } else {
            builder.addDependency(name);
        }
    }

    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        CacheResource.START.validateAndSet(fromModel, toModel);
        CacheResource.BATCHING.validateAndSet(fromModel, toModel);
        CacheResource.INDEXING.validateAndSet(fromModel, toModel);
        CacheResource.INDEXING_AUTO_CONFIG.validateAndSet(fromModel, toModel);
        CacheResource.JNDI_NAME.validateAndSet(fromModel, toModel);
        CacheResource.CACHE_MODULE.validateAndSet(fromModel, toModel);
        CacheResource.INDEXING_PROPERTIES.validateAndSet(fromModel, toModel);
        CacheResource.STATISTICS.validateAndSet(fromModel, toModel);
    }

    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, List<Dependency<?>> dependencies) throws OperationFailedException {
        ModelNode securityModel;
        builder.jmxStatistics().enabled(CacheResource.STATISTICS.resolveModelAttribute(context, cache).asBoolean());
        Indexing indexing = Indexing.valueOf(CacheResource.INDEXING.resolveModelAttribute(context, cache).asString());
        boolean autoConfig = CacheResource.INDEXING_AUTO_CONFIG.resolveModelAttribute(context, cache).asBoolean();
        boolean batching = CacheResource.BATCHING.resolveModelAttribute(context, cache).asBoolean();
        builder.clustering().cacheMode(this.mode);
        ModelNode indexingPropertiesModel = CacheResource.INDEXING_PROPERTIES.resolveModelAttribute(context, cache);
        Properties indexingProperties = new Properties();
        if (indexing.isEnabled() && indexingPropertiesModel.isDefined()) {
            for (Property p : indexingPropertiesModel.asPropertyList()) {
                String value = p.getValue().asString();
                indexingProperties.put(p.getName(), value);
            }
        }
        builder.indexing().index(indexing.isEnabled() ? (indexing.isLocalOnly() ? Index.LOCAL : Index.ALL) : Index.NONE).withProperties(indexingProperties).autoConfig(autoConfig);
        if (cache.hasDefined("locking") && cache.get(new String[]{"locking", "LOCKING"}).isDefined()) {
            ModelNode locking = cache.get(new String[]{"locking", "LOCKING"});
            IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
            if (LockingResource.ISOLATION.resolveModelAttribute(context, locking).isDefined()) {
                log.warn((Object)"Ignoring XML attribute isolation, please remove from configuration file");
            }
            boolean striping = LockingResource.STRIPING.resolveModelAttribute(context, locking).asBoolean();
            long acquireTimeout = LockingResource.ACQUIRE_TIMEOUT.resolveModelAttribute(context, locking).asLong();
            int concurrencyLevel = LockingResource.CONCURRENCY_LEVEL.resolveModelAttribute(context, locking).asInt();
            builder.locking().isolationLevel(isolationLevel).useLockStriping(striping).lockAcquisitionTimeout(acquireTimeout).concurrencyLevel(concurrencyLevel);
        }
        TransactionMode txMode = TransactionMode.NONE;
        LockingMode lockingMode = LockingMode.OPTIMISTIC;
        if (cache.hasDefined("transaction") && cache.get(new String[]{"transaction", "TRANSACTION"}).isDefined()) {
            ModelNode transaction = cache.get(new String[]{"transaction", "TRANSACTION"});
            long stopTimeout = TransactionResource.STOP_TIMEOUT.resolveModelAttribute(context, transaction).asLong();
            txMode = TransactionMode.valueOf(TransactionResource.MODE.resolveModelAttribute(context, transaction).asString());
            lockingMode = LockingMode.valueOf((String)TransactionResource.LOCKING.resolveModelAttribute(context, transaction).asString());
            builder.transaction().cacheStopTimeout(stopTimeout);
        }
        builder.transaction().transactionMode(txMode.getMode()).lockingMode(lockingMode).useSynchronization(!txMode.isXAEnabled()).recovery().enabled(txMode.isRecoveryEnabled());
        if (txMode.isRecoveryEnabled()) {
            builder.transaction().syncCommitPhase(true).syncRollbackPhase(true);
        }
        if (batching) {
            builder.transaction().transactionMode(org.infinispan.transaction.TransactionMode.TRANSACTIONAL).invocationBatching().enable();
        } else {
            builder.transaction().invocationBatching().disable();
        }
        if (cache.hasDefined("eviction") && cache.get(new String[]{"eviction", "EVICTION"}).isDefined()) {
            ModelNode eviction = cache.get(new String[]{"eviction", "EVICTION"});
            EvictionStrategy strategy = EvictionStrategy.valueOf((String)EvictionResource.EVICTION_STRATEGY.resolveModelAttribute(context, eviction).asString());
            builder.eviction().strategy(strategy);
            if (strategy.isEnabled()) {
                int maxEntries = EvictionResource.MAX_ENTRIES.resolveModelAttribute(context, eviction).asInt();
                builder.eviction().maxEntries(maxEntries);
            }
        }
        if (cache.hasDefined("expiration") && cache.get(new String[]{"expiration", "EXPIRATION"}).isDefined()) {
            ModelNode expiration = cache.get(new String[]{"expiration", "EXPIRATION"});
            long maxIdle = ExpirationResource.MAX_IDLE.resolveModelAttribute(context, expiration).asLong();
            long lifespan = ExpirationResource.LIFESPAN.resolveModelAttribute(context, expiration).asLong();
            long interval = ExpirationResource.INTERVAL.resolveModelAttribute(context, expiration).asLong();
            builder.expiration().maxIdle(maxIdle).lifespan(lifespan).wakeUpInterval(interval);
            if (interval > 0L) {
                builder.expiration().enableReaper();
            } else {
                builder.expiration().disableReaper();
            }
        }
        if (cache.hasDefined("compatibility") && cache.get(new String[]{"compatibility", "COMPATIBILITY"}).isDefined()) {
            ModelNode compatibility = cache.get(new String[]{"compatibility", "COMPATIBILITY"});
            boolean enabled = CompatibilityResource.ENABLED.resolveModelAttribute(context, compatibility).asBoolean();
            builder.compatibility().enabled(enabled);
            if (compatibility.hasDefined("marshaller")) {
                String marshaller = CompatibilityResource.MARSHALLER.resolveModelAttribute(context, compatibility).asString();
                try {
                    Class<Marshaller> marshallerClass = CacheLoader.class.getClassLoader().loadClass(marshaller).asSubclass(Marshaller.class);
                    builder.compatibility().marshaller(marshallerClass.newInstance());
                }
                catch (Exception e) {
                    throw InfinispanMessages.MESSAGES.invalidCompatibilityMarshaller(e, marshaller);
                }
            }
        }
        if (cache.hasDefined("security") && cache.get(new String[]{"security", "SECURITY"}).isDefined() && (securityModel = cache.get(new String[]{"security", "SECURITY"})).hasDefined("authorization") && securityModel.get("authorization").hasDefined("AUTHORIZATION")) {
            ModelNode authzModel = securityModel.get(new String[]{"authorization", "AUTHORIZATION"});
            AuthorizationConfigurationBuilder authzBuilder = builder.security().authorization();
            authzBuilder.enabled(CacheAuthorizationResource.ENABLED.resolveModelAttribute(context, authzModel).asBoolean());
            for (ModelNode role : CacheAuthorizationResource.ROLES.resolveModelAttribute(context, authzModel).asList()) {
                authzBuilder.role(role.asString());
            }
        }
        for (String loaderKey : loaderKeys) {
            this.handleLoaderProperties(context, cache, loaderKey, containerName, builder, dependencies);
        }
        for (String storeKey : storeKeys) {
            this.handleStoreProperties(context, cache, storeKey, containerName, builder, dependencies);
        }
        if (cache.hasDefined("backup")) {
            SitesConfigurationBuilder sitesBuilder = builder.sites();
            for (Property property : cache.get("backup").asPropertyList()) {
                String siteName = property.getName();
                ModelNode site = property.getValue();
                BackupConfigurationBuilder backupConfigurationBuilder = sitesBuilder.addBackup();
                backupConfigurationBuilder.site(siteName).backupFailurePolicy(BackupFailurePolicy.valueOf((String)BackupSiteResource.FAILURE_POLICY.resolveModelAttribute(context, site).asString())).strategy(BackupConfiguration.BackupStrategy.valueOf((String)BackupSiteResource.STRATEGY.resolveModelAttribute(context, site).asString())).replicationTimeout(BackupSiteResource.REPLICATION_TIMEOUT.resolveModelAttribute(context, site).asLong());
                if (BackupSiteResource.ENABLED.resolveModelAttribute(context, site).asBoolean()) {
                    sitesBuilder.addInUseBackupSite(siteName);
                }
                if (site.hasDefined("take-offline")) {
                    ModelNode takeOfflineModel = site.get("take-offline");
                    backupConfigurationBuilder.takeOffline().afterFailures(BackupSiteResource.TAKE_OFFLINE_AFTER_FAILURES.resolveModelAttribute(context, takeOfflineModel).asInt()).minTimeToWait(BackupSiteResource.TAKE_OFFLINE_MIN_WAIT.resolveModelAttribute(context, takeOfflineModel).asLong());
                }
                if (!site.hasDefined("state-transfer")) continue;
                ModelNode stateTransferModel = site.get("state-transfer");
                backupConfigurationBuilder.stateTransfer().chunkSize(BackupSiteStateTransferResource.STATE_TRANSFER_CHUNK_SIZE.resolveModelAttribute(context, stateTransferModel).asInt()).timeout(BackupSiteStateTransferResource.STATE_TRANSFER_TIMEOUT.resolveModelAttribute(context, stateTransferModel).asLong()).maxRetries(BackupSiteStateTransferResource.STATE_TRANSFER_MAX_RETRIES.resolveModelAttribute(context, stateTransferModel).asInt()).waitTime(BackupSiteStateTransferResource.STATE_TRANSFER_WAIT_TIME.resolveModelAttribute(context, stateTransferModel).asLong());
            }
        }
    }

    private void handleLoaderProperties(OperationContext context, ModelNode cache, String loaderKey, String containerName, ConfigurationBuilder builder, List<Dependency<?>> dependencies) throws OperationFailedException {
        if (cache.hasDefined(loaderKey)) {
            for (Property loaderEntry : cache.get(loaderKey).asPropertyList()) {
                ModelNode loader = loaderEntry.getValue();
                PersistenceConfigurationBuilder persistence = builder.persistence();
                StoreConfigurationBuilder<?, ?> scb = this.buildCacheLoader(persistence, loader, loaderKey);
                this.parseCommonAttributes(context, persistence, loader, scb);
                Properties properties = this.getProperties(loader);
                scb.withProperties(properties);
            }
        }
    }

    private Properties getProperties(ModelNode loader) {
        TypedProperties properties = new TypedProperties();
        if (loader.hasDefined("property")) {
            for (Property property : loader.get("property").asPropertyList()) {
                String propertyName = property.getName();
                Property complexValue = property.getValue().asProperty();
                String propertyValue = complexValue.getValue().asString();
                properties.setProperty(propertyName, propertyValue);
            }
        }
        return properties;
    }

    private void handleStoreProperties(OperationContext context, ModelNode cache, String storeKey, String containerName, ConfigurationBuilder builder, List<Dependency<?>> dependencies) throws OperationFailedException {
        if (cache.hasDefined(storeKey)) {
            for (Property storeEntry : cache.get(storeKey).asPropertyList()) {
                ModelNode store = storeEntry.getValue();
                boolean passivation = BaseStoreResource.PASSIVATION.resolveModelAttribute(context, store).asBoolean();
                PersistenceConfigurationBuilder loadersBuilder = builder.persistence().passivation(passivation);
                StoreConfigurationBuilder<?, ?> scb = this.buildCacheStore(context, loadersBuilder, containerName, store, storeKey, dependencies);
                this.parseCommonAttributes(context, loadersBuilder, store, scb);
            }
        }
    }

    private StoreConfigurationBuilder<?, ?> buildCacheLoader(PersistenceConfigurationBuilder persistenceBuilder, ModelNode loader, String loaderKey) throws OperationFailedException {
        if (loaderKey.equals("cluster-loader")) {
            ClusterLoaderConfigurationBuilder builder = persistenceBuilder.addClusterLoader();
            if (loader.hasDefined("remote-timeout")) {
                builder.remoteCallTimeout(loader.require("remote-timeout").asLong());
            }
            return builder;
        }
        if (loaderKey.equals("loader")) {
            String className = loader.require("class").asString();
            try {
                Object instance = this.newInstance(className);
                return this.handleStoreOrLoaderClass(className, persistenceBuilder);
            }
            catch (Exception e) {
                throw InfinispanMessages.MESSAGES.invalidCacheStore(e, className);
            }
        }
        throw new IllegalStateException();
    }

    private StoreConfigurationBuilder handleStoreOrLoaderClass(String className, PersistenceConfigurationBuilder persistenceBuilder) throws ClassNotFoundException {
        Class configuredBy;
        Class<?> storeImplClass = CacheLoader.class.getClassLoader().loadClass(className);
        ConfiguredBy annotation = storeImplClass.getAnnotation(ConfiguredBy.class);
        Class<StoreConfigurationBuilder> builderClass = null;
        if (annotation != null && (configuredBy = annotation.value()) != null) {
            BuiltBy builtBy = configuredBy.getAnnotation(BuiltBy.class);
            builderClass = builtBy.value().asSubclass(StoreConfigurationBuilder.class);
        }
        Object scb = builderClass == null ? ((CustomStoreConfigurationBuilder)persistenceBuilder.addStore(CustomStoreConfigurationBuilder.class)).customStoreClass(storeImplClass) : persistenceBuilder.addStore(builderClass);
        return scb;
    }

    private StoreConfigurationBuilder<?, ?> buildCacheStore(OperationContext context, PersistenceConfigurationBuilder persistenceBuilder, String containerName, ModelNode store, String storeKey, List<Dependency<?>> dependencies) throws OperationFailedException {
        ModelNode resolvedValue = null;
        if (storeKey.equals("file-store")) {
            final SingleFileStoreConfigurationBuilder builder = (SingleFileStoreConfigurationBuilder)persistenceBuilder.addStore(SingleFileStoreConfigurationBuilder.class);
            if (store.hasDefined("max-entries")) {
                builder.maxEntries(store.get("max-entries").asInt());
            }
            final String path = (resolvedValue = FileStoreResource.PATH.resolveModelAttribute(context, store)).isDefined() ? resolvedValue.asString() : "infinispan" + File.separatorChar + containerName;
            resolvedValue = FileStoreResource.RELATIVE_TO.resolveModelAttribute(context, store);
            final String relativeTo = resolvedValue.isDefined() ? resolvedValue.asString() : "jboss.server.data.dir";
            SimpleInjector<PathManager> injector = new SimpleInjector<PathManager>(){
                volatile PathManager.Callback.Handle callbackHandle;

                public void inject(PathManager value) {
                    this.callbackHandle = value.registerCallback(relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                    builder.location(value.resolveRelativePathEntry(path, relativeTo));
                }

                @Override
                public void uninject() {
                    super.uninject();
                    if (this.callbackHandle != null) {
                        this.callbackHandle.remove();
                    }
                }
            };
            dependencies.add(new Dependency<PathManager>(PathManagerService.SERVICE_NAME, PathManager.class, injector));
            return builder;
        }
        if (storeKey.equals("string-keyed-jdbc-store") || storeKey.equals("binary-keyed-jdbc-store") || storeKey.equals("mixed-keyed-jdbc-store")) {
            ModelNode dialectNode = BaseJDBCStoreResource.DIALECT.resolveModelAttribute(context, store);
            DatabaseType databaseType = dialectNode.isDefined() ? DatabaseType.valueOf((String)dialectNode.asString()) : null;
            AbstractJdbcStoreConfigurationBuilder<?, ?> builder = this.buildJdbcStore(persistenceBuilder, context, store, databaseType);
            String datasource = BaseJDBCStoreResource.DATA_SOURCE.resolveModelAttribute(context, store).asString();
            dependencies.add(new Dependency(ServiceName.JBOSS.append(new String[]{"data-source", datasource})));
            builder.dataSource().jndiUrl(datasource);
            return builder;
        }
        if (storeKey.equals("remote-store")) {
            final RemoteStoreConfigurationBuilder builder = (RemoteStoreConfigurationBuilder)persistenceBuilder.addStore(RemoteStoreConfigurationBuilder.class);
            for (ModelNode server : store.require("remote-servers").asList()) {
                String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                SimpleInjector<OutboundSocketBinding> injector = new SimpleInjector<OutboundSocketBinding>(){

                    public void inject(OutboundSocketBinding value) {
                        try {
                            builder.addServer().host(value.getDestinationAddress().getHostAddress()).port(value.getDestinationPort());
                        }
                        catch (UnknownHostException e) {
                            throw InfinispanMessages.MESSAGES.failedToInjectSocketBinding(e, value);
                        }
                    }
                };
                dependencies.add(new Dependency<OutboundSocketBinding>(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, injector));
            }
            if (store.hasDefined("cache")) {
                builder.remoteCacheName(store.get("cache").asString());
            }
            if (store.hasDefined("hotrod-wrapping")) {
                builder.hotRodWrapping(store.require("hotrod-wrapping").asBoolean());
            }
            if (store.hasDefined("raw-values")) {
                builder.rawValues(store.require("raw-values").asBoolean());
            }
            if (store.hasDefined("socket-timeout")) {
                builder.socketTimeout(store.require("socket-timeout").asLong());
            }
            if (store.hasDefined("tcp-no-delay")) {
                builder.tcpNoDelay(store.require("tcp-no-delay").asBoolean());
            }
            return builder;
        }
        if (storeKey.equals("leveldb-store")) {
            ModelNode node;
            String expirationPath;
            boolean expirationDefined;
            final LevelDBStoreConfigurationBuilder builder = (LevelDBStoreConfigurationBuilder)persistenceBuilder.addStore(LevelDBStoreConfigurationBuilder.class);
            resolvedValue = LevelDBStoreResource.PATH.resolveModelAttribute(context, store);
            final String path = resolvedValue.isDefined() ? resolvedValue.asString() : "infinispan" + File.separatorChar + containerName + File.separatorChar + "data";
            resolvedValue = LevelDBStoreResource.RELATIVE_TO.resolveModelAttribute(context, store);
            final String relativeTo = resolvedValue.isDefined() ? resolvedValue.asString() : "jboss.server.data.dir";
            SimpleInjector<PathManager> injector = new SimpleInjector<PathManager>(){
                volatile PathManager.Callback.Handle callbackHandle;

                public void inject(PathManager value) {
                    this.callbackHandle = value.registerCallback(relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                    builder.location(value.resolveRelativePathEntry(path, relativeTo));
                }

                @Override
                public void uninject() {
                    super.uninject();
                    if (this.callbackHandle != null) {
                        this.callbackHandle.remove();
                    }
                }
            };
            dependencies.add(new Dependency<PathManager>(PathManagerService.SERVICE_NAME, PathManager.class, injector));
            boolean bl = expirationDefined = store.hasDefined("expiration") && store.get(new String[]{"expiration", "EXPIRATION"}).isDefined();
            if (expirationDefined) {
                ModelNode expiration = store.get(new String[]{"expiration", "EXPIRATION"});
                expirationPath = LevelDBExpirationResource.PATH.resolveModelAttribute(context, expiration).asString();
                builder.expiryQueueSize(LevelDBExpirationResource.QUEUE_SIZE.resolveModelAttribute(context, expiration).asInt());
            } else {
                expirationPath = "infinispan" + File.separatorChar + containerName + File.separatorChar + "expiration";
            }
            injector = new SimpleInjector<PathManager>(){
                volatile PathManager.Callback.Handle callbackHandle;

                public void inject(PathManager value) {
                    this.callbackHandle = value.registerCallback(relativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
                    builder.expiredLocation(value.resolveRelativePathEntry(expirationPath, relativeTo));
                }

                @Override
                public void uninject() {
                    super.uninject();
                    if (this.callbackHandle != null) {
                        this.callbackHandle.remove();
                    }
                }
            };
            dependencies.add(new Dependency<PathManager>(PathManagerService.SERVICE_NAME, PathManager.class, injector));
            if (store.hasDefined("block-size")) {
                builder.blockSize(store.get("block-size").asInt());
            }
            if (store.hasDefined("cache-size")) {
                builder.cacheSize(store.get("cache-size").asLong());
            }
            if (store.hasDefined("clear-threshold")) {
                builder.clearThreshold(store.get("clear-threshold").asInt());
            }
            if (store.hasDefined("compression")) {
                node = store.get(new String[]{"compression", "COMPRESSION"});
                CompressionType compressionType = CompressionType.valueOf((String)LevelDBCompressionResource.TYPE.resolveModelAttribute(context, node).asString());
                builder.compressionType(compressionType);
            }
            if (store.hasDefined("implementation")) {
                node = store.get(new String[]{"implementation", "IMPLEMENTATION"});
                LevelDBStoreConfiguration.ImplementationType implementationType = LevelDBStoreConfiguration.ImplementationType.valueOf((String)LevelDBImplementationResource.TYPE.resolveModelAttribute(context, node).asString());
                builder.implementationType(implementationType);
            }
            return builder;
        }
        if (storeKey.equals("rest-store")) {
            final RestStoreConfigurationBuilder builder = (RestStoreConfigurationBuilder)persistenceBuilder.addStore(RestStoreConfigurationBuilder.class);
            builder.host("localhost");
            for (ModelNode server : store.require("remote-servers").asList()) {
                String outboundSocketBinding = server.get("outbound-socket-binding").asString();
                SimpleInjector<OutboundSocketBinding> injector = new SimpleInjector<OutboundSocketBinding>(){

                    public void inject(OutboundSocketBinding value) {
                        try {
                            builder.host(value.getDestinationAddress().getHostAddress()).port(value.getDestinationPort());
                        }
                        catch (UnknownHostException e) {
                            throw InfinispanMessages.MESSAGES.failedToInjectSocketBinding(e, value);
                        }
                    }
                };
                dependencies.add(new Dependency<OutboundSocketBinding>(OutboundSocketBinding.OUTBOUND_SOCKET_BINDING_BASE_SERVICE_NAME.append(new String[]{outboundSocketBinding}), OutboundSocketBinding.class, injector));
            }
            if (store.hasDefined("append-cache-name-to-path")) {
                builder.appendCacheNameToPath(store.require("append-cache-name-to-path").asBoolean());
            }
            if (store.hasDefined("path")) {
                builder.path(store.get("path").asString());
            }
            builder.rawValues(true);
            builder.metadataHelper(MimeMetadataHelper.class);
            if (store.hasDefined("connection-pool")) {
                ModelNode pool = store.get("connection-pool");
                if (pool.hasDefined("connection-timeout")) {
                    builder.connectionPool().connectionTimeout(pool.require("connection-timeout").asInt());
                }
                if (pool.hasDefined("max-connections-per-host")) {
                    builder.connectionPool().maxConnectionsPerHost(pool.require("max-connections-per-host").asInt());
                }
                if (pool.hasDefined("max-total-connections")) {
                    builder.connectionPool().maxTotalConnections(pool.require("max-total-connections").asInt());
                }
                if (pool.hasDefined("buffer-size")) {
                    builder.connectionPool().bufferSize(pool.require("buffer-size").asInt());
                }
                if (pool.hasDefined("socket-timeout")) {
                    builder.connectionPool().socketTimeout(pool.require("socket-timeout").asInt());
                }
                if (pool.hasDefined("tcp-no-delay")) {
                    builder.connectionPool().tcpNoDelay(pool.require("tcp-no-delay").asBoolean());
                }
            }
            return builder;
        }
        if (storeKey.equals("store")) {
            String className = store.require("class").asString();
            try {
                Object instance = this.newInstance(className);
                return this.handleStoreOrLoaderClass(className, persistenceBuilder);
            }
            catch (Exception e) {
                throw InfinispanMessages.MESSAGES.invalidCacheStore(e, className);
            }
        }
        throw new IllegalStateException();
    }

    private Object newInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return CacheLoader.class.getClassLoader().loadClass(className).newInstance();
    }

    private void parseCommonAttributes(OperationContext context, PersistenceConfigurationBuilder persistenceBuilder, ModelNode store, StoreConfigurationBuilder storeConfigurationBuilder) throws OperationFailedException {
        boolean async;
        ModelNode readOnly;
        ModelNode singleton;
        ModelNode purge;
        ModelNode passivation;
        ModelNode fetchState;
        ModelNode preload;
        ModelNode shared = store.get("shared");
        if (shared != null && shared.isDefined()) {
            storeConfigurationBuilder.shared(shared.asBoolean());
        }
        if ((preload = store.get("preload")) != null && preload.isDefined()) {
            storeConfigurationBuilder.preload(preload.asBoolean());
        }
        if ((fetchState = store.get("fetch-state")) != null && fetchState.isDefined()) {
            storeConfigurationBuilder.fetchPersistentState(fetchState.asBoolean());
        }
        if ((passivation = store.get("passivation")) != null && passivation.isDefined()) {
            persistenceBuilder.passivation(passivation.asBoolean());
        }
        if ((purge = store.get("purge")) != null && purge.isDefined()) {
            storeConfigurationBuilder.purgeOnStartup(purge.asBoolean());
        }
        if ((singleton = store.get("singleton")) != null && singleton.isDefined() && singleton.asBoolean()) {
            storeConfigurationBuilder.singleton().enable();
        }
        if ((readOnly = store.get("read-only")) != null && readOnly.isDefined()) {
            storeConfigurationBuilder.ignoreModifications(readOnly.asBoolean());
        }
        boolean bl = async = store.hasDefined("write-behind") && store.get(new String[]{"write-behind", "WRITE_BEHIND"}).isDefined();
        if (async) {
            ModelNode writeBehind = store.get(new String[]{"write-behind", "WRITE_BEHIND"});
            storeConfigurationBuilder.async().enable().flushLockTimeout(StoreWriteBehindResource.FLUSH_LOCK_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).modificationQueueSize(StoreWriteBehindResource.MODIFICATION_QUEUE_SIZE.resolveModelAttribute(context, writeBehind).asInt()).shutdownTimeout(StoreWriteBehindResource.SHUTDOWN_TIMEOUT.resolveModelAttribute(context, writeBehind).asLong()).threadPoolSize(StoreWriteBehindResource.THREAD_POOL_SIZE.resolveModelAttribute(context, writeBehind).asInt());
        }
        TypedProperties properties = new TypedProperties();
        if (store.hasDefined("property")) {
            for (Property property : store.get("property").asPropertyList()) {
                String propertyName = property.getName();
                ModelNode propertyValue = null;
                propertyValue = StorePropertyResource.VALUE.resolveModelAttribute(context, property.getValue());
                properties.setProperty(propertyName, propertyValue.asString());
            }
        }
        storeConfigurationBuilder.withProperties((Properties)properties);
        ModelNode writeBehind = store.get("write-behind");
        if (writeBehind != null && writeBehind.isDefined() && writeBehind.asBoolean()) {
            storeConfigurationBuilder.async();
        }
    }

    private AbstractJdbcStoreConfigurationBuilder<?, ?> buildJdbcStore(PersistenceConfigurationBuilder loadersBuilder, OperationContext context, ModelNode store, DatabaseType databaseType) throws OperationFailedException {
        boolean useStringKeyedTable = store.hasDefined("string-keyed-table");
        boolean useBinaryKeyedTable = store.hasDefined("binary-keyed-table");
        if (useStringKeyedTable && !useBinaryKeyedTable) {
            JdbcStringBasedStoreConfigurationBuilder builder = (JdbcStringBasedStoreConfigurationBuilder)loadersBuilder.addStore(JdbcStringBasedStoreConfigurationBuilder.class);
            builder.dialect(databaseType);
            this.buildStringKeyedTable((TableManipulationConfigurationBuilder<?, ?>)builder.table(), context, store.get("string-keyed-table"));
            return builder;
        }
        if (useBinaryKeyedTable && !useStringKeyedTable) {
            JdbcBinaryStoreConfigurationBuilder builder = (JdbcBinaryStoreConfigurationBuilder)loadersBuilder.addStore(JdbcBinaryStoreConfigurationBuilder.class);
            builder.dialect(databaseType);
            this.buildBinaryKeyedTable((TableManipulationConfigurationBuilder<?, ?>)builder.table(), context, store.get("binary-keyed-table"));
            return builder;
        }
        JdbcMixedStoreConfigurationBuilder builder = (JdbcMixedStoreConfigurationBuilder)loadersBuilder.addStore(JdbcMixedStoreConfigurationBuilder.class);
        builder.dialect(databaseType);
        this.buildStringKeyedTable((TableManipulationConfigurationBuilder<?, ?>)builder.stringTable(), context, store.get("string-keyed-table"));
        this.buildBinaryKeyedTable((TableManipulationConfigurationBuilder<?, ?>)builder.binaryTable(), context, store.get("binary-keyed-table"));
        return builder;
    }

    private void buildBinaryKeyedTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table) throws OperationFailedException {
        this.buildTable(builder, context, table, "ispn_bucket");
    }

    private void buildStringKeyedTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table) throws OperationFailedException {
        this.buildTable(builder, context, table, "ispn_entry");
    }

    private void buildTable(TableManipulationConfigurationBuilder<?, ?> builder, OperationContext context, ModelNode table, String defaultTableNamePrefix) throws OperationFailedException {
        ModelNode tableNamePrefix = BaseJDBCStoreResource.PREFIX.resolveModelAttribute(context, table);
        builder.batchSize(BaseJDBCStoreResource.BATCH_SIZE.resolveModelAttribute(context, table).asInt()).fetchSize(BaseJDBCStoreResource.FETCH_SIZE.resolveModelAttribute(context, table).asInt()).tableNamePrefix(tableNamePrefix.isDefined() ? tableNamePrefix.asString() : defaultTableNamePrefix).idColumnName(this.getColumnProperty(context, table, "id-column", (AttributeDefinition)BaseJDBCStoreResource.COLUMN_NAME, "id")).idColumnType(this.getColumnProperty(context, table, "id-column", (AttributeDefinition)BaseJDBCStoreResource.COLUMN_TYPE, "VARCHAR")).dataColumnName(this.getColumnProperty(context, table, "data-column", (AttributeDefinition)BaseJDBCStoreResource.COLUMN_NAME, "datum")).dataColumnType(this.getColumnProperty(context, table, "data-column", (AttributeDefinition)BaseJDBCStoreResource.COLUMN_TYPE, "BINARY")).timestampColumnName(this.getColumnProperty(context, table, "timestamp-column", (AttributeDefinition)BaseJDBCStoreResource.COLUMN_NAME, "version")).timestampColumnType(this.getColumnProperty(context, table, "timestamp-column", (AttributeDefinition)BaseJDBCStoreResource.COLUMN_TYPE, "BIGINT"));
    }

    private String getColumnProperty(OperationContext context, ModelNode table, String columnKey, AttributeDefinition columnAttribute, String defaultValue) throws OperationFailedException {
        if (!table.isDefined() || !table.hasDefined(columnKey)) {
            return defaultValue;
        }
        ModelNode column = table.get(columnKey);
        ModelNode resolvedValue = null;
        resolvedValue = columnAttribute.resolveModelAttribute(context, column);
        return resolvedValue.isDefined() ? resolvedValue.asString() : defaultValue;
    }

    private static class CacheConfigurationDependencies
    implements CacheConfigurationService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<TransactionManager> tm = new InjectedValue();
        private final InjectedValue<TransactionSynchronizationRegistry> tsr = new InjectedValue();
        private final InjectedValue<ModuleLoader> moduleLoader = new InjectedValue();

        CacheConfigurationDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<TransactionManager> getTransactionManagerInjector() {
            return this.tm;
        }

        Injector<TransactionSynchronizationRegistry> getTransactionSynchronizationRegistryInjector() {
            return this.tsr;
        }

        Injector<ModuleLoader> getModuleLoaderInjector() {
            return this.moduleLoader;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public TransactionManager getTransactionManager() {
            return (TransactionManager)this.tm.getOptionalValue();
        }

        @Override
        public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
            return (TransactionSynchronizationRegistry)this.tsr.getOptionalValue();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return (ModuleLoader)this.moduleLoader.getValue();
        }
    }

    private static class CacheDependencies
    implements CacheService.Dependencies {
        private final Value<EmbeddedCacheManager> container;
        private final InjectedValue<XAResourceRecoveryRegistry> recoveryRegistry = new InjectedValue();

        CacheDependencies(Value<EmbeddedCacheManager> container) {
            this.container = container;
        }

        Injector<XAResourceRecoveryRegistry> getRecoveryRegistryInjector() {
            return this.recoveryRegistry;
        }

        @Override
        public EmbeddedCacheManager getCacheContainer() {
            return (EmbeddedCacheManager)this.container.getValue();
        }

        @Override
        public XAResourceRecoveryRegistry getRecoveryRegistry() {
            return (XAResourceRecoveryRegistry)this.recoveryRegistry.getOptionalValue();
        }
    }

    private abstract class SimpleInjector<I>
    implements Injector<I> {
        private SimpleInjector() {
        }

        public void uninject() {
        }
    }

    protected class Dependency<I> {
        private final ServiceName name;
        private final Class<I> type;
        private final Injector<I> target;

        Dependency(ServiceName name) {
            this(name, null, null);
        }

        Dependency(ServiceName name, Class<I> type, Injector<I> target) {
            this.name = name;
            this.type = type;
            this.target = target;
        }

        ServiceName getName() {
            return this.name;
        }

        public Class<I> getType() {
            return this.type;
        }

        public Injector<I> getInjector() {
            return this.target;
        }
    }
}

