/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.partionhandling.AvailabilityMode;
import org.infinispan.server.infinispan.SecurityActions;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.LocalTopologyManagerImpl;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class CacheAvailabilityAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final CacheAvailabilityAttributeHandler INSTANCE = new CacheAvailabilityAttributeHandler();

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        ComponentRegistry registry;
        LocalTopologyManagerImpl localTopologyManager;
        Cache cache;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheService.getServiceName(cacheContainerName, cacheName));
        if (controller != null && (cache = (Cache)controller.getValue()) != null && (localTopologyManager = (LocalTopologyManagerImpl)(registry = SecurityActions.getComponentRegistry(cache.getAdvancedCache())).getGlobalComponentRegistry().getComponent(LocalTopologyManager.class)) != null) {
            try {
                if (operation.hasDefined("value")) {
                    ModelNode newValue = operation.get("value");
                    localTopologyManager.setCacheAvailability(cacheName, AvailabilityMode.valueOf((String)newValue.asString()));
                } else {
                    context.getResult().set(new ModelNode().set(localTopologyManager.getCacheAvailability(cacheName).toString()));
                }
            }
            catch (Exception e) {
                throw new OperationFailedException(new ModelNode().set(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage())));
            }
        }
        context.stepCompleted();
    }
}

