/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.security.impl.ClusterRoleMapper;
import org.infinispan.security.impl.CommonNameRoleMapper;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.AuthorizationRoleResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteResource;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteStateTransferResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseJDBCStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseLoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.BaseStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheAuthorizationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerAuthorizationResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusterLoaderResource;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheResource;
import org.jboss.as.clustering.infinispan.subsystem.CompatibilityResource;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheResource;
import org.jboss.as.clustering.infinispan.subsystem.Element;
import org.jboss.as.clustering.infinispan.subsystem.EvictionResource;
import org.jboss.as.clustering.infinispan.subsystem.ExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.FileStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBCompressionResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBExpirationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBImplementationResource;
import org.jboss.as.clustering.infinispan.subsystem.LevelDBStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.LockingResource;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingResource;
import org.jboss.as.clustering.infinispan.subsystem.RemoteStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.RestStoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferResource;
import org.jboss.as.clustering.infinispan.subsystem.StorePropertyResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreResource;
import org.jboss.as.clustering.infinispan.subsystem.StoreWriteBehindResource;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResource;
import org.jboss.as.clustering.infinispan.subsystem.TransportResource;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public final class InfinispanSubsystemXMLReader_7_1
implements XMLElementReader<List<ModelNode>> {
    private static final Logger log = Logger.getLogger(InfinispanSubsystemXMLReader_7_1.class);

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{InfinispanExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)subsystemAddress);
        operations.add(subsystem);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CACHE_CONTAINER: {
                    this.parseContainer(reader, subsystemAddress, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseContainer(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode container = Util.getEmptyOperation((String)"add", null);
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block20: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block20;
                }
                case ALIASES: {
                    for (String alias : reader.getListAttributeValue(i)) {
                        container.get("aliases").add(alias);
                    }
                    continue block20;
                }
                case DEFAULT_CACHE: {
                    CacheContainerResource.DEFAULT_CACHE.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block20;
                }
                case JNDI_NAME: {
                    CacheContainerResource.JNDI_NAME.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block20;
                }
                case START: {
                    CacheContainerResource.START.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block20;
                }
                case LISTENER_EXECUTOR: {
                    CacheContainerResource.LISTENER_EXECUTOR.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block20;
                }
                case EVICTION_EXECUTOR: {
                    CacheContainerResource.EVICTION_EXECUTOR.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block20;
                }
                case REPLICATION_QUEUE_EXECUTOR: {
                    CacheContainerResource.REPLICATION_QUEUE_EXECUTOR.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block20;
                }
                case MODULE: {
                    CacheContainerResource.CACHE_CONTAINER_MODULE.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block20;
                }
                case STATISTICS: {
                    CacheContainerResource.STATISTICS.parseAndSetParameter(value, container, (XMLStreamReader)reader);
                    continue block20;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        PathAddress containerAddress = subsystemAddress.append("cache-container", name);
        container.get("address").set(containerAddress.toModelNode());
        operations.add(container);
        block22: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, containerAddress, operations);
                    continue block22;
                }
                case SECURITY: {
                    this.parseGlobalSecurity(reader, containerAddress, operations);
                    continue block22;
                }
                case LOCAL_CACHE: {
                    this.parseLocalCache(reader, containerAddress, operations);
                    continue block22;
                }
                case INVALIDATION_CACHE: {
                    this.parseInvalidationCache(reader, containerAddress, operations);
                    continue block22;
                }
                case REPLICATED_CACHE: {
                    this.parseReplicatedCache(reader, containerAddress, operations);
                    continue block22;
                }
                case DISTRIBUTED_CACHE: {
                    this.parseDistributedCache(reader, containerAddress, operations);
                    continue block22;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        PathAddress transportAddress = containerAddress.append("transport", "TRANSPORT");
        ModelNode transport = Util.createAddOperation((PathAddress)transportAddress);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STACK: {
                    TransportResource.STACK.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block9;
                }
                case CLUSTER: {
                    TransportResource.CLUSTER.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block9;
                }
                case EXECUTOR: {
                    TransportResource.EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block9;
                }
                case LOCK_TIMEOUT: {
                    TransportResource.LOCK_TIMEOUT.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block9;
                }
                case REMOTE_COMMAND_EXECUTOR: {
                    TransportResource.REMOTE_COMMAND_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block9;
                }
                case STRICT_PEER_TO_PEER: {
                    TransportResource.STRICT_PEER_TO_PEER.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block9;
                }
                case TOTAL_ORDER_EXECUTOR: {
                    TransportResource.TOTAL_ORDER_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(transport);
    }

    private void parseGlobalSecurity(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        PathAddress securityAddress = containerAddress.append("security", "SECURITY");
        ModelNode security = Util.createAddOperation((PathAddress)securityAddress);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseGlobalAuthorization(reader, securityAddress, additionalConfigurationOperations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(security);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseGlobalAuthorization(XMLExtendedStreamReader reader, PathAddress securityAddress, List<ModelNode> operations) throws XMLStreamException {
        PathAddress authorizationAddress = securityAddress.append("authorization", "AUTHORIZATION");
        ModelNode authorization = Util.createAddOperation((PathAddress)authorizationAddress);
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUDIT_LOGGER: {
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        String roleMapper = null;
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case IDENTITY_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    roleMapper = IdentityRoleMapper.class.getName();
                    continue block11;
                }
                case COMMON_NAME_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    roleMapper = CommonNameRoleMapper.class.getName();
                    continue block11;
                }
                case CLUSTER_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    roleMapper = ClusterRoleMapper.class.getName();
                    continue block11;
                }
                case CUSTOM_ROLE_MAPPER: {
                    if (roleMapper != null) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    roleMapper = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.CLASS.getLocalName());
                    continue block11;
                }
                case ROLE: {
                    this.parseGlobalRole(reader, authorizationAddress, additionalConfigurationOperations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        CacheContainerAuthorizationResource.MAPPER.parseAndSetParameter(roleMapper, authorization, (XMLStreamReader)reader);
        operations.add(authorization);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseGlobalRole(XMLExtendedStreamReader reader, PathAddress authorizationAddress, List<ModelNode> operations) throws XMLStreamException {
        String[] attributes = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.NAME.getLocalName(), Attribute.PERMISSIONS.getLocalName()});
        String name = attributes[0];
        PathAddress roleAddress = authorizationAddress.append("role", name);
        ModelNode role = Util.createAddOperation((PathAddress)roleAddress);
        AuthorizationRoleResource.NAME.parseAndSetParameter(name, role, (XMLStreamReader)reader);
        for (String perm : attributes[1].split("\\s+")) {
            AuthorizationRoleResource.PERMISSIONS.parseAndAddParameterElement(perm, role, (XMLStreamReader)reader);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(role);
    }

    private void parseCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                CacheResource.NAME.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case START: {
                CacheResource.START.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                if (value.equalsIgnoreCase("EAGER")) break;
                Location location = reader.getLocation();
                log.warnf("Ignoring start mode [%s] at [row,col] [%s, %s], as EAGER is the only supported mode", (Object)value, (Object)location.getLineNumber(), (Object)location.getColumnNumber());
                cache.get(CacheResource.START.getName()).set("EAGER");
                break;
            }
            case JNDI_NAME: {
                CacheResource.JNDI_NAME.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case BATCHING: {
                CacheResource.BATCHING.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case MODULE: {
                CacheResource.CACHE_MODULE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case STATISTICS: {
                CacheResource.STATISTICS.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseClusteredCacheAttribute(XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode cache) throws XMLStreamException {
        switch (attribute) {
            case ASYNC_MARSHALLING: {
                ClusteredCacheResource.ASYNC_MARSHALLING.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case MODE: {
                ClusteredCacheResource.MODE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case QUEUE_SIZE: {
                ClusteredCacheResource.QUEUE_SIZE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case QUEUE_FLUSH_INTERVAL: {
                ClusteredCacheResource.QUEUE_FLUSH_INTERVAL.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            case REMOTE_TIMEOUT: {
                ClusteredCacheResource.REMOTE_TIMEOUT.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                break;
            }
            default: {
                this.parseCacheAttribute(reader, index, attribute, value, cache);
            }
        }
    }

    private void parseLocalCache(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        this.addNameToAddress(cache, containerAddress, "local-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseDistributedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OWNERS: {
                    DistributedCacheResource.OWNERS.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block10;
                }
                case SEGMENTS: {
                    DistributedCacheResource.SEGMENTS.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block10;
                }
                case CAPACITY_FACTOR: {
                    DistributedCacheResource.CAPACITY_FACTOR.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block10;
                }
                case L1_LIFESPAN: {
                    DistributedCacheResource.L1_LIFESPAN.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
                }
            }
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addNameToAddress(cache, containerAddress, "distributed-cache");
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PARTITION_HANDLING: {
                    this.parsePartitionHandling(reader, cache, additionalConfigurationOperations);
                    continue block11;
                }
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cache, additionalConfigurationOperations);
                    continue block11;
                }
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseReplicatedCache(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addNameToAddress(cache, containerAddress, "replicated-cache");
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PARTITION_HANDLING: {
                    this.parsePartitionHandling(reader, cache, additionalConfigurationOperations);
                    continue block5;
                }
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, cache, additionalConfigurationOperations);
                    continue block5;
                }
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseInvalidationCache(XMLExtendedStreamReader reader, PathAddress containerAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode cache = Util.getEmptyOperation((String)"add", null);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            this.parseClusteredCacheAttribute(reader, i, attribute, value, cache);
        }
        if (!cache.hasDefined("name")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        if (!cache.hasDefined("mode")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.MODE));
        }
        this.addNameToAddress(cache, containerAddress, "invalidation-cache");
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                default: 
            }
            this.parseCacheElement(reader, element, cache, additionalConfigurationOperations);
        }
        operations.add(cache);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void addNameToAddress(ModelNode current, PathAddress pathToOwner, String type) {
        String name = current.get("name").asString();
        PathAddress cacheAddress = pathToOwner.append(type, name);
        current.get("address").set(cacheAddress.toModelNode());
        current.remove("name");
    }

    private void parseCacheElement(XMLExtendedStreamReader reader, Element element, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        switch (element) {
            case BACKUPS: {
                this.parseBackups(reader, cache, operations);
                break;
            }
            case BACKUP_FOR: {
                this.parseBackupFor(reader, cache);
                break;
            }
            case CLUSTER_LOADER: {
                this.parseClusterLoader(reader, cache, operations);
                break;
            }
            case COMPATIBILITY: {
                this.parseCompatibility(reader, cache, operations);
                break;
            }
            case LOCKING: {
                this.parseLocking(reader, cache, operations);
                break;
            }
            case TRANSACTION: {
                this.parseTransaction(reader, cache, operations);
                break;
            }
            case EVICTION: {
                this.parseEviction(reader, cache, operations);
                break;
            }
            case EXPIRATION: {
                this.parseExpiration(reader, cache, operations);
                break;
            }
            case LOADER: {
                this.parseCustomLoader(reader, cache, operations);
                break;
            }
            case STORE: {
                this.parseCustomStore(reader, cache, operations);
                break;
            }
            case FILE_STORE: {
                this.parseFileStore(reader, cache, operations);
                break;
            }
            case STRING_KEYED_JDBC_STORE: {
                this.parseStringKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case BINARY_KEYED_JDBC_STORE: {
                this.parseBinaryKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case MIXED_KEYED_JDBC_STORE: {
                this.parseMixedKeyedJDBCStore(reader, cache, operations);
                break;
            }
            case REMOTE_STORE: {
                this.parseRemoteStore(reader, cache, operations);
                break;
            }
            case LEVELDB_STORE: {
                this.parseLevelDBStore(reader, cache, operations);
                break;
            }
            case REST_STORE: {
                this.parseRestStore(reader, cache, operations);
                break;
            }
            case INDEXING: {
                this.parseIndexing(reader, cache);
                break;
            }
            case SECURITY: {
                this.parseCacheSecurity(reader, cache, operations);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress stateTransferAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("state-transfer", "STATE_TRANSFER");
        ModelNode stateTransfer = Util.createAddOperation((PathAddress)stateTransferAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AWAIT_INITIAL_TRANSFER: {
                    StateTransferResource.AWAIT_INITIAL_TRANSFER.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block6;
                }
                case ENABLED: {
                    StateTransferResource.ENABLED.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block6;
                }
                case TIMEOUT: {
                    StateTransferResource.TIMEOUT.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block6;
                }
                case CHUNK_SIZE: {
                    StateTransferResource.CHUNK_SIZE.parseAndSetParameter(value, stateTransfer, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(stateTransfer);
    }

    private void parseLocking(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress lockingAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("locking", "LOCKING");
        ModelNode locking = Util.createAddOperation((PathAddress)lockingAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ISOLATION: {
                    LockingResource.ISOLATION.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case STRIPING: {
                    LockingResource.STRIPING.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case ACQUIRE_TIMEOUT: {
                    LockingResource.ACQUIRE_TIMEOUT.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                case CONCURRENCY_LEVEL: {
                    LockingResource.CONCURRENCY_LEVEL.parseAndSetParameter(value, locking, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(locking);
    }

    private void parseTransaction(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress transactionAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("transaction", "TRANSACTION");
        ModelNode transaction = Util.createAddOperation((PathAddress)transactionAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STOP_TIMEOUT: {
                    TransactionResource.STOP_TIMEOUT.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block5;
                }
                case MODE: {
                    TransactionResource.MODE.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block5;
                }
                case LOCKING: {
                    TransactionResource.LOCKING.parseAndSetParameter(value, transaction, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(transaction);
    }

    private void parseEviction(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress evictionAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("eviction", "EVICTION");
        ModelNode eviction = Util.createAddOperation((PathAddress)evictionAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case STRATEGY: {
                    EvictionResource.EVICTION_STRATEGY.parseAndSetParameter(value, eviction, (XMLStreamReader)reader);
                    continue block4;
                }
                case MAX_ENTRIES: {
                    EvictionResource.MAX_ENTRIES.parseAndSetParameter(value, eviction, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(eviction);
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress expirationAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("expiration", "EXPIRATION");
        ModelNode expiration = Util.createAddOperation((PathAddress)expirationAddress);
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_IDLE: {
                    ExpirationResource.MAX_IDLE.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                case LIFESPAN: {
                    ExpirationResource.LIFESPAN.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                case INTERVAL: {
                    ExpirationResource.INTERVAL.parseAndSetParameter(value, expiration, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(expiration);
    }

    private void parseCustomLoader(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode loader = Util.getEmptyOperation((String)"add", null);
        String name = "LOADER";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    StoreResource.CLASS.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    name = this.parseLoaderAttribute(name, reader, i, attribute, value, loader);
                }
            }
        }
        if (!loader.hasDefined("class")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CLASS));
        }
        loader.get("name").set(name);
        this.addNameToAddress(loader, PathAddress.pathAddress((ModelNode)cache.get("address")), "loader");
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        this.parseLoaderElements(reader, loader, additionalConfigurationOperations);
        operations.add(loader);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseClusterLoader(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode loader = Util.getEmptyOperation((String)"add", null);
        String name = "CLUSTER_LOADER";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_TIMEOUT: {
                    ClusterLoaderResource.REMOTE_TIMEOUT.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    name = this.parseLoaderAttribute(name, reader, i, attribute, value, loader);
                }
            }
        }
        loader.get("name").set(name);
        this.addNameToAddress(loader, PathAddress.pathAddress((ModelNode)cache.get("address")), "cluster-loader");
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        this.parseLoaderElements(reader, loader, additionalConfigurationOperations);
        operations.add(loader);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseCustomStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "STORE";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    StoreResource.CLASS.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("class")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CLASS));
        }
        store.get("name").set(name);
        this.addNameToAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), "store");
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        this.parseStoreElements(reader, store, additionalConfigurationOperations);
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseFileStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "FILE_STORE";
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_ENTRIES: {
                    FileStoreResource.MAX_ENTRIES.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block5;
                }
                case RELATIVE_TO: {
                    FileStoreResource.RELATIVE_TO.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block5;
                }
                case PATH: {
                    FileStoreResource.PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        store.get("name").set(name);
        this.addNameToAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), "file-store");
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        this.parseStoreElements(reader, store, additionalConfigurationOperations);
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseRemoteStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "REMOTE_STORE";
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CACHE: {
                    RemoteStoreResource.CACHE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case HOTROD_WRAPPING: {
                    RemoteStoreResource.HOTROD_WRAPPING.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case RAW_VALUES: {
                    RemoteStoreResource.RAW_VALUES.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case SOCKET_TIMEOUT: {
                    RemoteStoreResource.SOCKET_TIMEOUT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case TCP_NO_DELAY: {
                    RemoteStoreResource.TCP_NO_DELAY.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        store.get("name").set(name);
        this.addNameToAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), "remote-store");
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SERVER: {
                    this.parseRemoteServer(reader, store.get("remote-servers").add());
                    continue block12;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block12;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        if (!store.hasDefined("remote-servers")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.REMOTE_SERVER));
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseLevelDBStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "LEVELDB_STORE";
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    LevelDBStoreResource.PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case BLOCK_SIZE: {
                    LevelDBStoreResource.BLOCK_SIZE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case CACHE_SIZE: {
                    LevelDBStoreResource.CACHE_SIZE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                case CLEAR_THRESHOLD: {
                    LevelDBStoreResource.CLEAR_THRESHOLD.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        store.get("name").set(name);
        this.addNameToAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), "leveldb-store");
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case EXPIRATION: {
                    this.parseStoreExpiry(reader, store, additionalConfigurationOperations);
                    continue block12;
                }
                case COMPRESSION: {
                    this.parseStoreCompression(reader, store, additionalConfigurationOperations);
                    continue block12;
                }
                case IMPLEMENTATION: {
                    this.parseStoreImplementation(reader, store, additionalConfigurationOperations);
                    continue block12;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseStoreExpiry(XMLExtendedStreamReader reader, ModelNode store, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeExpiryAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("expiration", "EXPIRATION");
        ModelNode storeExpiry = Util.createAddOperation((PathAddress)storeExpiryAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PATH: {
                    LevelDBExpirationResource.PATH.parseAndSetParameter(value, storeExpiry, (XMLStreamReader)reader);
                    continue block4;
                }
                case QUEUE_SIZE: {
                    LevelDBExpirationResource.QUEUE_SIZE.parseAndSetParameter(value, storeExpiry, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(storeExpiry);
    }

    private void parseStoreCompression(XMLExtendedStreamReader reader, ModelNode store, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeCompressionAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("compression", "COMPRESSION");
        ModelNode storeCompression = Util.createAddOperation((PathAddress)storeCompressionAddress);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    LevelDBCompressionResource.TYPE.parseAndSetParameter(value, storeCompression, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(storeCompression);
    }

    private void parseStoreImplementation(XMLExtendedStreamReader reader, ModelNode store, List<ModelNode> operations) throws XMLStreamException {
        PathAddress storeImplementationAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("implementation", "IMPLEMENTATION");
        ModelNode storeImplementation = Util.createAddOperation((PathAddress)storeImplementationAddress);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    LevelDBImplementationResource.TYPE.parseAndSetParameter(value, storeImplementation, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(storeImplementation);
    }

    private void parseRemoteServer(XMLExtendedStreamReader reader, ModelNode server) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case OUTBOUND_SOCKET_BINDING: {
                    RemoteStoreResource.OUTBOUND_SOCKET_BINDING.parseAndSetParameter(value, server, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRestStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "REST_STORE";
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case APPEND_CACHE_NAME_TO_PATH: {
                    RestStoreResource.APPEND_CACHE_NAME_TO_PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block9;
                }
                case PATH: {
                    RestStoreResource.PATH.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        store.get("name").set(name);
        this.addNameToAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), "rest-store");
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_POOL: {
                    this.parseRestConnectionPool(reader, store.get("connection-pool").setEmptyObject());
                    continue block10;
                }
                case REMOTE_SERVER: {
                    this.parseRemoteServer(reader, store.get("remote-servers").add());
                    continue block10;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block10;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        if (!store.hasDefined("remote-servers")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.REMOTE_SERVER));
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseRestConnectionPool(XMLExtendedStreamReader reader, ModelNode table) throws XMLStreamException {
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BUFFER_SIZE: {
                    RestStoreResource.BUFFER_SIZE.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case CONNECTION_TIMEOUT: {
                    RestStoreResource.CONNECTION_TIMEOUT.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case MAX_CONNECTIONS_PER_HOST: {
                    RestStoreResource.MAX_CONNECTIONS_PER_HOST.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case MAX_TOTAL_CONNECTIONS: {
                    RestStoreResource.MAX_TOTAL_CONNECTIONS.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case SOCKET_TIMEOUT: {
                    RestStoreResource.SOCKET_TIMEOUT.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                case TCP_NO_DELAY: {
                    RestStoreResource.TCP_NO_DELAY.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseStringKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "STRING_KEYED_JDBC_STORE";
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    BaseJDBCStoreResource.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                case DIALECT: {
                    BaseJDBCStoreResource.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        store.get("name").set(name);
        this.addNameToAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), "string-keyed-jdbc-store");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("string-keyed-table").setEmptyObject());
                    continue block9;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block9;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseBinaryKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "BINARY_KEYED_JDBC_STORE";
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    BaseJDBCStoreResource.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                case DIALECT: {
                    BaseJDBCStoreResource.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        store.get("name").set(name);
        this.addNameToAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), "binary-keyed-jdbc-store");
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("binary-keyed-table").setEmptyObject());
                    continue block9;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block9;
                }
            }
            this.parseStoreProperty(reader, store, additionalConfigurationOperations);
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseMixedKeyedJDBCStore(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode store = Util.getEmptyOperation((String)"add", null);
        String name = "MIXED_KEYED_JDBC_STORE";
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DATASOURCE: {
                    BaseJDBCStoreResource.DATA_SOURCE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block10;
                }
                case DIALECT: {
                    BaseJDBCStoreResource.DIALECT.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    name = this.parseStoreAttribute(name, reader, i, attribute, value, store);
                }
            }
        }
        if (!store.hasDefined("datasource")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DATASOURCE));
        }
        store.get("name").set(name);
        this.addNameToAddress(store, PathAddress.pathAddress((ModelNode)cache.get("address")), "mixed-keyed-jdbc-store");
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STRING_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("string-keyed-table").setEmptyObject());
                    continue block11;
                }
                case BINARY_KEYED_TABLE: {
                    this.parseJDBCStoreTable(reader, store.get("binary-keyed-table").setEmptyObject());
                    continue block11;
                }
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, additionalConfigurationOperations);
                    continue block11;
                }
                case PROPERTY: {
                    this.parseStoreProperty(reader, store, additionalConfigurationOperations);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(store);
        operations.addAll(additionalConfigurationOperations);
    }

    private void parseJDBCStoreTable(XMLExtendedStreamReader reader, ModelNode table) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PREFIX: {
                    BaseJDBCStoreResource.PREFIX.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block10;
                }
                case FETCH_SIZE: {
                    BaseJDBCStoreResource.FETCH_SIZE.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block10;
                }
                case BATCH_SIZE: {
                    BaseJDBCStoreResource.BATCH_SIZE.parseAndSetParameter(value, table, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ID_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("id-column").setEmptyObject());
                    continue block11;
                }
                case DATA_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("data-column").setEmptyObject());
                    continue block11;
                }
                case TIMESTAMP_COLUMN: {
                    this.parseJDBCStoreColumn(reader, table.get("timestamp-column").setEmptyObject());
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseJDBCStoreColumn(XMLExtendedStreamReader reader, ModelNode column) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    BaseJDBCStoreResource.COLUMN_NAME.parseAndSetParameter(value, column, (XMLStreamReader)reader);
                    continue block4;
                }
                case TYPE: {
                    BaseJDBCStoreResource.COLUMN_TYPE.parseAndSetParameter(value, column, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseLoaderElements(XMLExtendedStreamReader reader, ModelNode loader, List<ModelNode> operations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseStoreProperty(reader, loader, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private String parseLoaderAttribute(String name, XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode loader) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                name = value;
                BaseLoaderResource.NAME.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                break;
            }
            case SHARED: {
                BaseLoaderResource.SHARED.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                break;
            }
            case PRELOAD: {
                BaseLoaderResource.PRELOAD.parseAndSetParameter(value, loader, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
        return name;
    }

    private String parseStoreAttribute(String name, XMLExtendedStreamReader reader, int index, Attribute attribute, String value, ModelNode store) throws XMLStreamException {
        switch (attribute) {
            case NAME: {
                name = value;
                BaseStoreResource.NAME.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case SHARED: {
                BaseStoreResource.SHARED.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PRELOAD: {
                BaseStoreResource.PRELOAD.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PASSIVATION: {
                BaseStoreResource.PASSIVATION.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case FETCH_STATE: {
                BaseStoreResource.FETCH_STATE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case PURGE: {
                BaseStoreResource.PURGE.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case SINGLETON: {
                BaseStoreResource.SINGLETON.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            case READ_ONLY: {
                BaseStoreResource.READ_ONLY.parseAndSetParameter(value, store, (XMLStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
        return name;
    }

    private void parseStoreElements(XMLExtendedStreamReader reader, ModelNode store, List<ModelNode> operations) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case WRITE_BEHIND: {
                    this.parseStoreWriteBehind(reader, store, operations);
                    continue block4;
                }
                case PROPERTY: {
                    this.parseStoreProperty(reader, store, operations);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStoreWriteBehind(XMLExtendedStreamReader reader, ModelNode store, List<ModelNode> operations) throws XMLStreamException {
        PathAddress writeBehindAddress = PathAddress.pathAddress((ModelNode)store.get("address")).append("write-behind", "WRITE_BEHIND");
        ModelNode writeBehind = Util.createAddOperation((PathAddress)writeBehindAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FLUSH_LOCK_TIMEOUT: {
                    StoreWriteBehindResource.FLUSH_LOCK_TIMEOUT.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    StoreWriteBehindResource.MODIFICATION_QUEUE_SIZE.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case SHUTDOWN_TIMEOUT: {
                    StoreWriteBehindResource.SHUTDOWN_TIMEOUT.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                case THREAD_POOL_SIZE: {
                    StoreWriteBehindResource.THREAD_POOL_SIZE.parseAndSetParameter(value, writeBehind, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(writeBehind);
    }

    private void parseStoreProperty(XMLExtendedStreamReader reader, ModelNode node, List<ModelNode> operations) throws XMLStreamException {
        int attributes = reader.getAttributeCount();
        String propertyName = null;
        block3: for (int i = 0; i < attributes; ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (propertyName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        String propertyValue = reader.getElementText();
        PathAddress propertyAddress = PathAddress.pathAddress((ModelNode)node.get("address")).append("property", propertyName);
        ModelNode property = Util.createAddOperation((PathAddress)propertyAddress);
        StorePropertyResource.VALUE.parseAndSetParameter(propertyValue, property, (XMLStreamReader)reader);
        operations.add(property);
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException {
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case INDEX: {
                    CacheResource.INDEXING.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block10;
                }
                case AUTO_CONFIG: {
                    CacheResource.INDEXING_AUTO_CONFIG.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int attributes = reader.getAttributeCount();
                    String property = null;
                    block12: for (int i = 0; i < attributes; ++i) {
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                property = value;
                                continue block12;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (property == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
                    }
                    String value = reader.getElementText();
                    CacheResource.INDEXING_PROPERTIES.parseAndAddParameterElement(property, value, node, reader);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackups(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, cache, operations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, ModelNode cache) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_CACHE: {
                    CacheResource.REMOTE_CACHE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block4;
                }
                case REMOTE_SITE: {
                    CacheResource.REMOTE_SITE.parseAndSetParameter(value, cache, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseBackup(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        ModelNode operation = Util.createAddOperation();
        String site = null;
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    site = value;
                    continue block11;
                }
                case STRATEGY: {
                    BackupSiteResource.STRATEGY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case BACKUP_FAILURE_POLICY: {
                    BackupSiteResource.FAILURE_POLICY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case TIMEOUT: {
                    BackupSiteResource.REPLICATION_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case ENABLED: {
                    BackupSiteResource.ENABLED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (site == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SITE));
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)cache.get("address")).append("backup", site);
        operation.get("address").set(address.toModelNode());
        ArrayList<ModelNode> additionalOperations = new ArrayList<ModelNode>(1);
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TAKE_OFFLINE: {
                    this.parseTakeOffline(reader, operation);
                    continue block12;
                }
                case STATE_TRANSFER: {
                    this.parseXSiteStateTransfer(reader, operation, additionalOperations);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(operation);
        operations.addAll(additionalOperations);
    }

    private void parseTakeOffline(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TAKE_BACKUP_OFFLINE_AFTER_FAILURES: {
                    BackupSiteResource.TAKE_OFFLINE_AFTER_FAILURES.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                case TAKE_BACKUP_OFFLINE_MIN_WAIT: {
                    BackupSiteResource.TAKE_OFFLINE_MIN_WAIT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseXSiteStateTransfer(XMLExtendedStreamReader reader, ModelNode backup, List<ModelNode> operations) throws XMLStreamException {
        PathAddress address = PathAddress.pathAddress((ModelNode)backup.get("address")).append("state-transfer", "STATE_TRANSFER");
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CHUNK_SIZE: {
                    BackupSiteStateTransferResource.STATE_TRANSFER_CHUNK_SIZE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case TIMEOUT: {
                    BackupSiteStateTransferResource.STATE_TRANSFER_TIMEOUT.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case MAX_RETRIES: {
                    BackupSiteStateTransferResource.STATE_TRANSFER_MAX_RETRIES.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case WAIT_TIME: {
                    BackupSiteStateTransferResource.STATE_TRANSFER_WAIT_TIME.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(operation);
    }

    private void parseCompatibility(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress compatibilityAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("compatibility", "COMPATIBILITY");
        ModelNode compatibility = Util.createAddOperation((PathAddress)compatibilityAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    CompatibilityResource.ENABLED.parseAndSetParameter(value, compatibility, (XMLStreamReader)reader);
                    continue block4;
                }
                case MARSHALLER: {
                    CompatibilityResource.MARSHALLER.parseAndSetParameter(value, compatibility, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(compatibility);
    }

    private void parseCacheSecurity(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress securityAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("security", "SECURITY");
        ModelNode security = Util.createAddOperation((PathAddress)securityAddress);
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        ArrayList<ModelNode> additionalConfigurationOperations = new ArrayList<ModelNode>();
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case AUTHORIZATION: {
                    this.parseCacheAuthorization(reader, security, additionalConfigurationOperations);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        operations.add(security);
        for (ModelNode additionalOperation : additionalConfigurationOperations) {
            operations.add(additionalOperation);
        }
    }

    private void parseCacheAuthorization(XMLExtendedStreamReader reader, ModelNode security, List<ModelNode> operations) throws XMLStreamException {
        PathAddress authorizationAddress = PathAddress.pathAddress((ModelNode)security.get("address")).append("authorization", "AUTHORIZATION");
        ModelNode authorization = Util.createAddOperation((PathAddress)authorizationAddress);
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    CacheAuthorizationResource.ENABLED.parseAndSetParameter(value, authorization, (XMLStreamReader)reader);
                    continue block4;
                }
                case ROLES: {
                    for (String role : reader.getListAttributeValue(i)) {
                        CacheAuthorizationResource.ROLES.parseAndAddParameterElement(role, authorization, (XMLStreamReader)reader);
                    }
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(authorization);
    }

    private void parsePartitionHandling(XMLExtendedStreamReader reader, ModelNode cache, List<ModelNode> operations) throws XMLStreamException {
        PathAddress partitionHandlingAddress = PathAddress.pathAddress((ModelNode)cache.get("address")).append("partition-handling", "PARTITION_HANDLING");
        ModelNode partitionHandling = Util.createAddOperation((PathAddress)partitionHandlingAddress);
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    PartitionHandlingResource.ENABLED.parseAndSetParameter(value, partitionHandling, (XMLStreamReader)reader);
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        operations.add(partitionHandling);
    }
}

