/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.BackupSiteStateTransferResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheChildResource;
import org.jboss.as.clustering.infinispan.subsystem.CacheCommands;
import org.jboss.as.clustering.infinispan.subsystem.CacheResource;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class BackupSiteResource
extends CacheChildResource {
    static final SimpleAttributeDefinition FAILURE_POLICY = new SimpleAttributeDefinitionBuilder("failure-policy", ModelType.STRING, true).setXmlName(Attribute.BACKUP_FAILURE_POLICY.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(BackupFailurePolicy.class, true, true)).setDefaultValue(new ModelNode().set(BackupFailurePolicy.WARN.name())).build();
    static final SimpleAttributeDefinition STRATEGY = new SimpleAttributeDefinitionBuilder("strategy", ModelType.STRING, true).setXmlName(Attribute.STRATEGY.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setValidator((ParameterValidator)new EnumValidator(BackupConfiguration.BackupStrategy.class, true, true)).setDefaultValue(new ModelNode().set(BackupConfiguration.BackupStrategy.ASYNC.name())).build();
    static final SimpleAttributeDefinition REPLICATION_TIMEOUT = new SimpleAttributeDefinitionBuilder("timeout", ModelType.STRING, true).setXmlName(Attribute.TIMEOUT.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(10000L)).build();
    static final SimpleAttributeDefinition ENABLED = new SimpleAttributeDefinitionBuilder("enabled", ModelType.BOOLEAN, true).setXmlName(Attribute.ENABLED.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(true)).build();
    static final SimpleAttributeDefinition TAKE_OFFLINE_AFTER_FAILURES = new SimpleAttributeDefinitionBuilder("after-failures", ModelType.INT, true).setXmlName(Attribute.TAKE_BACKUP_OFFLINE_AFTER_FAILURES.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(0)).build();
    static final SimpleAttributeDefinition TAKE_OFFLINE_MIN_WAIT = new SimpleAttributeDefinitionBuilder("min-wait", ModelType.INT, true).setXmlName(Attribute.TAKE_BACKUP_OFFLINE_MIN_WAIT.getLocalName()).setAllowExpression(true).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES}).setDefaultValue(new ModelNode().set(0)).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{FAILURE_POLICY, STRATEGY, REPLICATION_TIMEOUT, ENABLED, TAKE_OFFLINE_AFTER_FAILURES, TAKE_OFFLINE_MIN_WAIT};
    static final OperationDefinition BACKUP_BRING_SITE_ONLINE = new SimpleOperationDefinitionBuilder("bring-site-online", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_TAKE_SITE_OFFLINE = new SimpleOperationDefinitionBuilder("take-site-offline", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_SITE_STATUS = new SimpleOperationDefinitionBuilder("site-status", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_PUSH_STATE = new SimpleOperationDefinitionBuilder("push-state", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_CANCEL_PUSH_STATE = new SimpleOperationDefinitionBuilder("cancel-push", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_CANCEL_RECEIVE_STATE = new SimpleOperationDefinitionBuilder("cancel-receive", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_PUSH_STATE_STATUS = new SimpleOperationDefinitionBuilder("push-state-status", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_CLEAR_PUSH_STATE_STATUS = new SimpleOperationDefinitionBuilder("clear-push-state-status", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();
    static final OperationDefinition BACKUP_SENDING_SITE = new SimpleOperationDefinitionBuilder("get-sending-site", InfinispanExtension.getResourceDescriptionResolver("backup.ops")).build();

    BackupSiteResource(CacheResource cacheResource) {
        super(PathElement.pathElement((String)"backup"), "backup", cacheResource, ATTRIBUTES);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.cacheResource.isRuntimeRegistration()) {
            resourceRegistration.registerOperationHandler(BACKUP_BRING_SITE_ONLINE, (OperationStepHandler)CacheCommands.BackupBringSiteOnlineCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_TAKE_SITE_OFFLINE, (OperationStepHandler)CacheCommands.BackupTakeSiteOfflineCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_SITE_STATUS, (OperationStepHandler)CacheCommands.BackupSiteStatusCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_PUSH_STATE, (OperationStepHandler)CacheCommands.BackupPushStateCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_CANCEL_PUSH_STATE, (OperationStepHandler)CacheCommands.BackupCancelPushStateCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_CANCEL_RECEIVE_STATE, (OperationStepHandler)CacheCommands.BackupCancelReceiveStateCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_PUSH_STATE_STATUS, (OperationStepHandler)CacheCommands.BackupPushStateStatusCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_CLEAR_PUSH_STATE_STATUS, (OperationStepHandler)CacheCommands.BackupClearPushStatusCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(BACKUP_SENDING_SITE, (OperationStepHandler)CacheCommands.BackupGetSendingSiteCommand.INSTANCE);
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        super.registerChildren(resourceRegistration);
        resourceRegistration.registerSubModel((ResourceDefinition)new BackupSiteStateTransferResource(this.cacheResource.isRuntimeRegistration()));
    }
}

