/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.management.MBeanServer;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.global.GlobalAuthorizationConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfigurationBuilder;
import org.infinispan.configuration.global.GlobalRoleConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.impl.ClusterRoleMapper;
import org.jboss.as.clustering.infinispan.ChannelTransport;
import org.jboss.as.clustering.infinispan.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.ManagedExecutorFactory;
import org.jboss.as.clustering.infinispan.ManagedScheduledExecutorFactory;
import org.jboss.as.clustering.infinispan.ThreadPoolExecutorFactories;
import org.jboss.as.clustering.infinispan.io.SimpleExternalizer;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerService;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.TransportConfiguration;
import org.jboss.as.clustering.jgroups.subsystem.ChannelService;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class EmbeddedCacheManagerConfigurationService
implements Service<EmbeddedCacheManagerConfiguration>,
EmbeddedCacheManagerConfiguration {
    private final String name;
    private final String defaultCache;
    private final boolean statistics;
    private final Dependencies dependencies;
    private final ModuleIdentifier moduleId;
    private volatile GlobalConfiguration config;

    public static ServiceName getServiceName(String name) {
        return EmbeddedCacheManagerService.getServiceName(name).append(new String[]{"config"});
    }

    public EmbeddedCacheManagerConfigurationService(String name, String defaultCache, boolean statistics, ModuleIdentifier moduleIdentifier, Dependencies dependencies) {
        this.name = name;
        this.defaultCache = defaultCache;
        this.statistics = statistics;
        this.moduleId = moduleIdentifier;
        this.dependencies = dependencies;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDefaultCache() {
        return this.defaultCache;
    }

    @Override
    public GlobalConfiguration getGlobalConfiguration() {
        return this.config;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleId;
    }

    public EmbeddedCacheManagerConfiguration getValue() {
        return this;
    }

    public void start(StartContext context) throws StartException {
        Executor stateTransferExecutor;
        ScheduledExecutorService replicationQueueExecutor;
        ScheduledExecutorService expirationExecutor;
        Executor asyncExecutor;
        Executor listenerExecutor;
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        ModuleLoader moduleLoader = this.dependencies.getModuleLoader();
        builder.serialization().classResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)moduleLoader));
        ClassLoader loader = null;
        try {
            loader = this.moduleId != null ? moduleLoader.loadModule(this.moduleId).getClassLoader() : EmbeddedCacheManagerConfiguration.class.getClassLoader();
            builder.classLoader(loader);
            int id = 255;
            for (SimpleExternalizer externalizer : ServiceFinder.load(SimpleExternalizer.class, (ClassLoader[])new ClassLoader[]{loader})) {
                builder.serialization().addAdvancedExternalizer(id++, (AdvancedExternalizer)externalizer);
            }
        }
        catch (ModuleLoadException e) {
            throw new StartException((Throwable)e);
        }
        builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
        TransportConfiguration transport = this.dependencies.getTransportConfiguration();
        TransportConfigurationBuilder transportBuilder = builder.transport();
        if (transport != null) {
            Executor remoteCommandExecutor;
            Executor totalOrderExecutor;
            TransportConfiguration.Topology topology;
            transportBuilder.transport((Transport)new ChannelTransport((ServiceRegistry)context.getController().getServiceContainer(), ChannelService.getServiceName((String)this.name)));
            Long timeout = transport.getLockTimeout();
            if (timeout != null) {
                transportBuilder.distributedSyncTimeout(timeout.longValue());
            }
            if ((topology = transport.getChannelFactory().getProtocolStackConfiguration().getTransport().getTopology()) != null) {
                String machine;
                String rack;
                String site = topology.getSite();
                if (site != null) {
                    transportBuilder.siteId(site);
                }
                if ((rack = topology.getRack()) != null) {
                    transportBuilder.rackId(rack);
                }
                if ((machine = topology.getMachine()) != null) {
                    transportBuilder.machineId(machine);
                }
            }
            transportBuilder.clusterName(this.name);
            Executor executor = transport.getExecutor();
            if (executor != null) {
                builder.transport().transportThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedExecutorFactory(executor));
            }
            if ((totalOrderExecutor = transport.getTotalOrderExecutor()) != null) {
                builder.transport().totalOrderThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedExecutorFactory(totalOrderExecutor));
            }
            if ((remoteCommandExecutor = transport.getRemoteCommandExecutor()) != null) {
                builder.transport().remoteCommandThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedExecutorFactory(remoteCommandExecutor));
            }
        }
        AuthorizationConfiguration authorization = this.dependencies.getAuthorizationConfiguration();
        GlobalAuthorizationConfigurationBuilder authorizationBuilder = builder.security().authorization();
        if (authorization != null) {
            authorizationBuilder.enable();
            if (authorization.getPrincipalMapper() != null) {
                try {
                    authorizationBuilder.principalRoleMapper(Class.forName(authorization.getPrincipalMapper(), true, loader).asSubclass(PrincipalRoleMapper.class).newInstance());
                }
                catch (Exception e) {
                    throw new StartException((Throwable)e);
                }
            } else {
                authorizationBuilder.principalRoleMapper((PrincipalRoleMapper)new ClusterRoleMapper());
            }
            for (Map.Entry<String, List<String>> role : authorization.getRoles().entrySet()) {
                GlobalRoleConfigurationBuilder roleBuilder = authorizationBuilder.role(role.getKey());
                for (String perm : role.getValue()) {
                    roleBuilder.permission(perm);
                }
            }
        }
        if ((listenerExecutor = this.dependencies.getListenerExecutor()) != null) {
            builder.listenerThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedExecutorFactory(listenerExecutor));
        }
        if ((asyncExecutor = this.dependencies.getAsyncExecutor()) != null) {
            builder.asyncThreadPool().threadPoolFactory(ThreadPoolExecutorFactories.mkManagedExecutorFactory(asyncExecutor));
        }
        if ((expirationExecutor = this.dependencies.getExpirationExecutor()) != null) {
            builder.expirationThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedScheduledExecutorFactory(expirationExecutor));
        }
        if ((replicationQueueExecutor = this.dependencies.getReplicationQueueExecutor()) != null) {
            builder.replicationQueueThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedScheduledExecutorFactory(replicationQueueExecutor));
        }
        if ((stateTransferExecutor = this.dependencies.getStateTransferExecutor()) != null) {
            builder.stateTransferThreadPool().threadPoolFactory((ThreadPoolExecutorFactory)new ManagedExecutorFactory(stateTransferExecutor));
        }
        GlobalJmxStatisticsConfigurationBuilder jmxBuilder = builder.globalJmxStatistics().cacheManagerName(this.name);
        jmxBuilder.jmxDomain(EmbeddedCacheManagerService.getServiceName(null).getCanonicalName());
        MBeanServer server = this.dependencies.getMBeanServer();
        if (server != null && this.statistics) {
            jmxBuilder.enable().mBeanServerLookup((MBeanServerLookup)new MBeanServerProvider(server)).allowDuplicateDomains(Boolean.valueOf(true));
        } else {
            jmxBuilder.disable();
        }
        this.config = builder.build();
    }

    public void stop(StopContext context) {
    }

    static interface Dependencies {
        public ModuleLoader getModuleLoader();

        public TransportConfiguration getTransportConfiguration();

        public AuthorizationConfiguration getAuthorizationConfiguration();

        public MBeanServer getMBeanServer();

        public Executor getListenerExecutor();

        public Executor getAsyncExecutor();

        public Executor getStateTransferExecutor();

        public ScheduledExecutorService getExpirationExecutor();

        public ScheduledExecutorService getReplicationQueueExecutor();
    }

    static interface AuthorizationConfiguration {
        public String getPrincipalMapper();

        public Map<String, List<String>> getRoles();
    }

    static interface TransportConfiguration {
        public Long getLockTimeout();

        public ChannelFactory getChannelFactory();

        public Executor getExecutor();

        public Executor getTotalOrderExecutor();

        public Executor getRemoteCommandExecutor();

        public boolean isStrictPeerToPeer();
    }
}

