/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationAdd;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationRemove;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheConfigurationAdd;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.InvalidationCacheConfigurationAdd;
import org.jboss.as.clustering.infinispan.subsystem.LocalCacheConfigurationAdd;
import org.jboss.as.clustering.infinispan.subsystem.ReplicatedCacheConfigurationAdd;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;

enum CacheConfigurationType {
    LOCAL("local-cache-configuration", new LocalCacheConfigurationAdd(), new CacheConfigurationRemove()),
    DISTRIBUTED("distributed-cache-configuration", new DistributedCacheConfigurationAdd(), LOCAL.getRemoveHandler()),
    REPLICATED("replicated-cache-configuration", new ReplicatedCacheConfigurationAdd(), LOCAL.getRemoveHandler()),
    INVALIDATION("invalidation-cache-configuration", new InvalidationCacheConfigurationAdd(), LOCAL.getRemoveHandler());

    private static final Map<String, CacheConfigurationType> TYPES;
    private final String key;
    private final CacheConfigurationAdd addHandler;
    private final CacheConfigurationRemove removeHandler;

    static CacheConfigurationType forName(String key) {
        return TYPES.get(key);
    }

    private CacheConfigurationType(String key, CacheConfigurationAdd addHandler, CacheConfigurationRemove removeHandler) {
        this.key = key;
        this.addHandler = addHandler;
        this.removeHandler = removeHandler;
    }

    public ResourceDescriptionResolver getResourceDescriptionResolver() {
        return new InfinispanResourceDescriptionResolver(this.key);
    }

    public PathElement pathElement() {
        return this.pathElement("*");
    }

    public PathElement pathElement(String name) {
        return PathElement.pathElement((String)this.key, (String)name);
    }

    public CacheConfigurationAdd getAddHandler() {
        return this.addHandler;
    }

    public CacheConfigurationRemove getRemoveHandler() {
        return this.removeHandler;
    }

    public boolean hasSharedState() {
        return EnumSet.of(REPLICATED, DISTRIBUTED).contains((Object)this);
    }

    static {
        TYPES = new HashMap<String, CacheConfigurationType>();
        for (CacheConfigurationType type : CacheConfigurationType.values()) {
            TYPES.put(type.key, type);
        }
    }
}

