/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.infinispan.server.commons.controller.AddStepHandler;
import org.infinispan.server.commons.controller.AddStepHandlerDescriptor;
import org.infinispan.server.commons.controller.RemoveStepHandler;
import org.infinispan.server.commons.controller.RemoveStepHandlerDescriptor;
import org.infinispan.server.commons.controller.ResourceDescriptor;
import org.infinispan.server.commons.controller.ResourceServiceBuilderFactory;
import org.infinispan.server.commons.controller.ResourceServiceHandler;
import org.infinispan.server.commons.controller.SimpleResourceServiceHandler;
import org.infinispan.server.commons.controller.validation.IntRangeValidatorBuilder;
import org.infinispan.server.commons.controller.validation.LongRangeValidatorBuilder;
import org.infinispan.server.commons.controller.validation.ParameterValidatorBuilder;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceName;

public enum ThreadPoolResource implements ResourceDefinition,
ThreadPoolDefinition
{
    ASYNC_OPERATIONS("async-operations", 25, 25, 1000, 60000L),
    LISTENER("listener", 1, 1, 100000, 60000L),
    PERSISTENCE("persistence", 1, 4, 0, 60000L),
    REMOTE_COMMAND("remote-command", 25, 25, 100000, 60000L),
    STATE_TRANSFER("state-transfer", 1, 60, 0, 60000L),
    TRANSPORT("transport", 25, 25, 100000, 60000L);

    static final PathElement WILDCARD_PATH;
    private final String name;
    private final ResourceDescriptionResolver descriptionResolver;
    private final AttributeDefinition minThreads;
    private final AttributeDefinition maxThreads;
    private final AttributeDefinition queueLength;
    private final AttributeDefinition keepAliveTime;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResource(String name, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepaliveTime) {
        this.name = name;
        this.descriptionResolver = new InfinispanResourceDescriptionResolver(this.getPathElement().getKey());
        this.minThreads = ThreadPoolResource.createBuilder("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build();
        this.maxThreads = ThreadPoolResource.createBuilder("max-threads", ModelType.INT, new ModelNode(defaultMaxThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build();
        this.queueLength = ThreadPoolResource.createBuilder("queue-length", ModelType.INT, new ModelNode(defaultQueueLength), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build();
        this.keepAliveTime = ThreadPoolResource.createBuilder("keepalive-time", ModelType.LONG, new ModelNode(defaultKeepaliveTime), (ParameterValidatorBuilder)new LongRangeValidatorBuilder().min(0L)).build();
    }

    private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validatorBuilder) {
        return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null))).setValidator(validatorBuilder.allowExpression(true).allowUndefined(true).build());
    }

    public PathElement getPathElement() {
        return ThreadPoolResource.pathElement(this.name);
    }

    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration registration) {
        return new DefaultResourceDescriptionProvider(registration, this.descriptionResolver);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        ResourceDescriptor descriptor = new ResourceDescriptor(this.descriptionResolver).addAttributes(this.getAttributes());
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new ThreadPoolBuilderFactory(this));
        new AddStepHandler((AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        new RemoveStepHandler((RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        ReloadRequiredWriteAttributeHandler writeHandler = new ReloadRequiredWriteAttributeHandler(this.getAttributes());
        for (AttributeDefinition attribute : this.getAttributes()) {
            registration.registerReadWriteAttribute(attribute, null, (OperationStepHandler)writeHandler);
        }
    }

    public void registerNotifications(ManagementResourceRegistration registration) {
    }

    public void registerChildren(ManagementResourceRegistration registration) {
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.emptyList();
    }

    public boolean isRuntime() {
        return false;
    }

    public void register(ManagementResourceRegistration registration) {
        registration.registerSubModel((ResourceDefinition)this);
    }

    @Override
    public ServiceName getServiceName(String containerName) {
        return CacheContainerServiceName.CONFIGURATION.getServiceName(containerName).append(this.getPathElement().getKeyValuePair());
    }

    @Override
    public AttributeDefinition getMinThreads() {
        return this.minThreads;
    }

    @Override
    public AttributeDefinition getMaxThreads() {
        return this.maxThreads;
    }

    @Override
    public AttributeDefinition getQueueLength() {
        return this.queueLength;
    }

    @Override
    public AttributeDefinition getKeepAliveTime() {
        return this.keepAliveTime;
    }

    Collection<AttributeDefinition> getAttributes() {
        return Arrays.asList(this.minThreads, this.maxThreads, this.queueLength, this.keepAliveTime);
    }

    void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
    }

    static {
        WILDCARD_PATH = ThreadPoolResource.pathElement("*");
    }
}

