/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.TimeUnit;
import org.infinispan.server.commons.service.Builder;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.service.ChannelServiceName;
import org.jboss.as.clustering.infinispan.subsystem.EmbeddedCacheManagerConfigurationService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;

public class TransportConfigurationBuilder
implements Builder<EmbeddedCacheManagerConfigurationService.TransportConfiguration>,
Value<EmbeddedCacheManagerConfigurationService.TransportConfiguration>,
EmbeddedCacheManagerConfigurationService.TransportConfiguration {
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final InjectedValue<ChannelFactory> factory = new InjectedValue();
    private final String name;
    private Long lockTimeout;
    private boolean strictPeerToPeer;

    public TransportConfigurationBuilder(String name) {
        this.name = name;
    }

    TransportConfigurationBuilder setLockTimeout(long lockTimeout, TimeUnit timeUnit) {
        this.lockTimeout = timeUnit.toMillis(lockTimeout);
        return this;
    }

    TransportConfigurationBuilder setStrictPeerToPeer(boolean strictPeerToPeer) {
        this.strictPeerToPeer = strictPeerToPeer;
        return this;
    }

    @Override
    public ChannelFactory getChannelFactory() {
        return (ChannelFactory)this.factory.getValue();
    }

    @Override
    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    @Override
    public boolean isStrictPeerToPeer() {
        return this.strictPeerToPeer;
    }

    @Override
    public Long getLockTimeout() {
        return this.lockTimeout;
    }

    public EmbeddedCacheManagerConfigurationService.TransportConfiguration getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public ServiceName getServiceName() {
        return CacheContainerServiceName.CACHE_CONTAINER.getServiceName(this.name).append(new String[]{"transport"});
    }

    public ServiceBuilder<EmbeddedCacheManagerConfigurationService.TransportConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ChannelServiceName.CHANNEL.getServiceName(this.name), Channel.class, this.channel).addDependency(ChannelServiceName.FACTORY.getServiceName(this.name), ChannelFactory.class, this.factory);
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }
}

