/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.cs.deployment;

import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.AdvancedCacheWriter;
import org.infinispan.persistence.spi.AdvancedLoadWriteStore;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.ExternalStore;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.ServicesAttachment;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class ServerExtensionDependenciesProcessor
implements DeploymentUnitProcessor {
    private static final ModuleIdentifier API = ModuleIdentifier.create((String)"org.infinispan");

    public void deploy(DeploymentPhaseContext ctx) throws DeploymentUnitProcessingException {
        if (this.hasInfinispanExtensions(ctx)) {
            DeploymentUnit deploymentUnit = ctx.getDeploymentUnit();
            ModuleSpecification moduleSpec = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
            ModuleLoader moduleLoader = Module.getBootModuleLoader();
            moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, API, false, false, false, false));
        }
    }

    private boolean hasInfinispanExtensions(DeploymentPhaseContext ctx) {
        DeploymentUnit deploymentUnit = ctx.getDeploymentUnit();
        ServicesAttachment sa = (ServicesAttachment)deploymentUnit.getAttachment(Attachments.SERVICES);
        if (sa != null) {
            return this.hasDeployableCache(sa);
        }
        return false;
    }

    public void undeploy(DeploymentUnit context) {
    }

    private boolean hasDeployableCache(ServicesAttachment sa) {
        return this.hasAdvancedCacheLoaders(sa) || this.hasAdvancedCacheWriters(sa) || this.hasAdvancedLoadWriteStores(sa) || this.hasCacheLoader(sa) || this.hasCacheWriter(sa) || this.hasExternalStores(sa);
    }

    private boolean hasAdvancedCacheLoaders(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, AdvancedCacheLoader.class);
    }

    private boolean hasAdvancedCacheWriters(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, AdvancedCacheWriter.class);
    }

    private boolean hasAdvancedLoadWriteStores(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, AdvancedLoadWriteStore.class);
    }

    private boolean hasCacheLoader(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, CacheLoader.class);
    }

    private boolean hasCacheWriter(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, CacheWriter.class);
    }

    private boolean hasExternalStores(ServicesAttachment servicesAttachment) {
        return this.hasExtension(servicesAttachment, ExternalStore.class);
    }

    private boolean hasExtension(ServicesAttachment servicesAttachment, Class<?> extensionClass) {
        return !servicesAttachment.getServiceImplementations(extensionClass.getName()).isEmpty();
    }
}

