/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.xsite.GlobalXSiteAdminOperations;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public abstract class CacheContainerCommands
implements OperationStepHandler {
    protected final int pathOffset;

    CacheContainerCommands(int pathOffset) {
        this.pathOffset = pathOffset;
    }

    private static ModelNode toOperationResult(String s) {
        ModelNode result = new ModelNode();
        result.add(s);
        return result;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode operationResult;
        try {
            operationResult = this.invokeCommand(this.getEmbeddedCacheManager(context, operation), operation);
        }
        catch (Exception e) {
            throw new OperationFailedException(new ModelNode().set(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage())));
        }
        if (operationResult != null) {
            context.getResult().set(operationResult);
        }
        context.stepCompleted();
    }

    protected abstract ModelNode invokeCommand(EmbeddedCacheManager var1, ModelNode var2) throws Exception;

    private EmbeddedCacheManager getEmbeddedCacheManager(OperationContext context, ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1 - this.pathOffset).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        return (EmbeddedCacheManager)controller.getValue();
    }

    public static class BackupCancelPushStateCommand
    extends CacheContainerCommands {
        public static final BackupCancelPushStateCommand INSTANCE = new BackupCancelPushStateCommand();

        public BackupCancelPushStateCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(EmbeddedCacheManager cacheManager, ModelNode operation) throws Exception {
            String siteNameParameter = CacheContainerResource.SITE_NAME.getName();
            ModelNode siteName = operation.require(siteNameParameter);
            GlobalXSiteAdminOperations xsiteAdminOperations = (GlobalXSiteAdminOperations)cacheManager.getGlobalComponentRegistry().getComponent(GlobalXSiteAdminOperations.class);
            return CacheContainerCommands.toOperationResult(xsiteAdminOperations.cancelPushState(siteName.asString()));
        }
    }

    public static class BackupPushStateCommand
    extends CacheContainerCommands {
        public static final BackupPushStateCommand INSTANCE = new BackupPushStateCommand();

        public BackupPushStateCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(EmbeddedCacheManager cacheManager, ModelNode operation) throws Exception {
            String siteNameParameter = CacheContainerResource.SITE_NAME.getName();
            ModelNode siteName = operation.require(siteNameParameter);
            GlobalXSiteAdminOperations xsiteAdminOperations = (GlobalXSiteAdminOperations)cacheManager.getGlobalComponentRegistry().getComponent(GlobalXSiteAdminOperations.class);
            return CacheContainerCommands.toOperationResult(xsiteAdminOperations.pushState(siteName.asString()));
        }
    }

    public static class BackupBringSiteOnlineCommand
    extends CacheContainerCommands {
        public static final BackupBringSiteOnlineCommand INSTANCE = new BackupBringSiteOnlineCommand();

        public BackupBringSiteOnlineCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(EmbeddedCacheManager cacheManager, ModelNode operation) throws Exception {
            String siteNameParameter = CacheContainerResource.SITE_NAME.getName();
            ModelNode siteName = operation.require(siteNameParameter);
            GlobalXSiteAdminOperations xsiteAdminOperations = (GlobalXSiteAdminOperations)cacheManager.getGlobalComponentRegistry().getComponent(GlobalXSiteAdminOperations.class);
            return CacheContainerCommands.toOperationResult(xsiteAdminOperations.bringSiteOnline(siteName.asString()));
        }
    }

    public static class BackupTakeSiteOfflineCommand
    extends CacheContainerCommands {
        public static final BackupTakeSiteOfflineCommand INSTANCE = new BackupTakeSiteOfflineCommand();

        public BackupTakeSiteOfflineCommand() {
            super(0);
        }

        @Override
        protected ModelNode invokeCommand(EmbeddedCacheManager cacheManager, ModelNode operation) throws Exception {
            String siteNameParameter = CacheContainerResource.SITE_NAME.getName();
            ModelNode siteName = operation.require(siteNameParameter);
            GlobalXSiteAdminOperations xsiteAdminOperations = (GlobalXSiteAdminOperations)cacheManager.getGlobalComponentRegistry().getComponent(GlobalXSiteAdminOperations.class);
            return CacheContainerCommands.toOperationResult(xsiteAdminOperations.takeSiteOffline(siteName.asString()));
        }
    }
}

