/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.server.infinispan.SecurityActions;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.topology.LocalTopologyManagerImpl;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class CacheRebalanceAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final CacheRebalanceAttributeHandler INSTANCE = new CacheRebalanceAttributeHandler();

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        ComponentRegistry registry;
        LocalTopologyManagerImpl localTopologyManager;
        Cache cache;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheServiceName.CACHE.getServiceName(cacheContainerName, cacheName));
        if (controller != null && (cache = (Cache)controller.getValue()) != null && (localTopologyManager = (LocalTopologyManagerImpl)(registry = SecurityActions.getComponentRegistry(cache.getAdvancedCache())).getGlobalComponentRegistry().getComponent(LocalTopologyManager.class)) != null) {
            try {
                if (operation.hasDefined("value")) {
                    ModelNode newValue = operation.get("value");
                    localTopologyManager.setCacheRebalancingEnabled(cacheName, newValue.asBoolean());
                } else {
                    context.getResult().set(new ModelNode().set(localTopologyManager.isRebalancingEnabled()));
                }
            }
            catch (Exception e) {
                throw new OperationFailedException(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage()));
            }
        }
    }
}

