/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.InputStream;
import java.net.URL;
import java.util.List;
import org.infinispan.commons.util.Util;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class UploadProtoFileOperationHandler
implements OperationStepHandler {
    public static final UploadProtoFileOperationHandler INSTANCE = new UploadProtoFileOperationHandler();

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        String namesParameter = CacheContainerResource.PROTO_NAMES.getName();
        String urlsParameter = CacheContainerResource.PROTO_URLS.getName();
        ModelNode names = operation.require(namesParameter);
        ModelNode urls = operation.require(urlsParameter);
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)controller.getValue();
        ProtobufMetadataManager protoManager = (ProtobufMetadataManager)cacheManager.getGlobalComponentRegistry().getComponent(ProtobufMetadataManager.class);
        if (protoManager != null) {
            try {
                List descriptorsNames = names.asList();
                List descriptorsUrls = urls.asList();
                if (descriptorsNames.size() != descriptorsUrls.size()) {
                    throw InfinispanMessages.MESSAGES.invalidParameterSizes(namesParameter, urlsParameter);
                }
                String[] nameArray = new String[descriptorsNames.size()];
                String[] contentArray = new String[descriptorsUrls.size()];
                int i = 0;
                for (ModelNode modelNode : descriptorsNames) {
                    nameArray[i] = modelNode.asString();
                    String urlString = ((ModelNode)descriptorsUrls.get(i)).asString();
                    contentArray[i] = Util.read((InputStream)new URL(urlString).openStream());
                    ++i;
                }
                protoManager.registerProtofiles(nameArray, contentArray);
            }
            catch (Exception e) {
                throw new OperationFailedException(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage()));
            }
        }
    }
}

