/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.infinispan.health.CacheHealth;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class HealthMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final HealthMetricsHandler INSTANCE = new HealthMetricsHandler();
    private static final int CACHE_CONTAINER_INDEX = 1;
    private static final int NUMBER_OF_LINES = 10;
    private PathManager pathManager;

    private static Collection<ModelNode> toModelNodeCollection(Collection<String> collection) {
        if (collection == null || collection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ModelNode> modelNodeCollection = new ArrayList<ModelNode>(collection.size());
        collection.forEach(e -> modelNodeCollection.add(new ModelNode().set(e)));
        return modelNodeCollection;
    }

    /*
     * Unable to fully structure code
     */
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        block27: {
            block28: {
                block26: {
                    address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    cacheContainerName = address.getElement(1).getValue();
                    metricName = operation.require("name").asString();
                    controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
                    cacheManager = (DefaultCacheContainer)controller.getValue();
                    metric = HealthMetrics.getMetric(metricName);
                    result = new ModelNode();
                    if (metric != null) break block26;
                    context.getFailureDescription().set(String.format("Unknown metric %s", new Object[]{metricName}));
                    break block27;
                }
                if (cacheManager != null) break block28;
                context.getFailureDescription().set(String.format("Unavailable cache container %s", new Object[]{metricName}));
                break block27;
            }
            health = cacheManager.getHealth();
            switch (1.$SwitchMap$org$jboss$as$clustering$infinispan$subsystem$HealthMetricsHandler$HealthMetrics[metric.ordinal()]) {
                case 1: {
                    cacheHealths = health.getCacheHealth();
                    perCacheHealth = new LinkedList<String>();
                    for (i = 0; i < cacheHealths.size(); ++i) {
                        perCacheHealth.add(((CacheHealth)cacheHealths.get(i)).getCacheName());
                        perCacheHealth.add(((CacheHealth)cacheHealths.get(i)).getStatus().toString());
                    }
                    result.set(HealthMetricsHandler.toModelNodeCollection(perCacheHealth));
                    break;
                }
                case 2: {
                    result.set(health.getHostInfo().getFreeMemoryInKb());
                    break;
                }
                case 3: {
                    result.set(health.getHostInfo().getTotalMemoryKb());
                    break;
                }
                case 4: {
                    result.set(health.getClusterHealth().getNumberOfNodes());
                    break;
                }
                case 5: {
                    result.set(health.getClusterHealth().getClusterName());
                    break;
                }
                case 6: {
                    result.set(health.getHostInfo().getNumberOfCpus());
                    break;
                }
                case 7: {
                    result.set(health.getClusterHealth().getHealthStatus().toString());
                    break;
                }
                case 8: {
                    path = new File(this.pathManager.resolveRelativePathEntry("server.log", "jboss.server.log.dir"));
                    try {
                        reader = new ReversedLinesFileReader(path, StandardCharsets.UTF_8);
                        var15_18 = null;
                        results = new LinkedList<String>();
                        for (i = 0; i < 10; ++i) {
                            results.add(0, reader.readLine());
                        }
                        result.set(HealthMetricsHandler.toModelNodeCollection(results));
                        if (reader == null) break;
                        if (var15_18 == null) ** GOTO lbl76
                        try {
                            reader.close();
                        }
                        catch (Throwable var16_20) {
                            var15_18.addSuppressed(var16_20);
                        }
                        break;
lbl76:
                        // 1 sources

                        reader.close();
                        ** break;
                        catch (Throwable var16_21) {
                            try {
                                var15_18 = var16_21;
                                throw var16_21;
                            }
                            catch (Throwable var18_23) {
                                if (reader != null) {
                                    if (var15_18 != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable var19_24) {
                                            var15_18.addSuppressed(var19_24);
                                        }
                                    } else {
                                        reader.close();
                                    }
                                }
                                throw var18_23;
lbl93:
                                // 1 sources

                            }
                        }
                    }
                    catch (FileNotFoundException e) {
                        result.set("File [" + path.getAbsolutePath() + "] does not exist");
                    }
                    catch (IOException e) {
                        result.set("Unable to read file [" + path.getAbsolutePath() + "]");
                    }
                    break;
                }
                default: {
                    context.getFailureDescription().set(String.format("Unknown metric %s", new Object[]{metric}));
                }
            }
            context.getResult().set(result);
        }
    }

    public void registerPathManager(PathManager pathManager) {
        this.pathManager = pathManager;
    }

    public void registerMetrics(ManagementResourceRegistration container) {
        for (HealthMetrics metric : HealthMetrics.values()) {
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    public static enum HealthMetrics {
        NUMBER_OF_CPUS("number-of-cpus", ModelType.INT),
        TOTAL_MEMORY_KB("total-memory", ModelType.LONG),
        FREE_MEMORY_KB("free-memory", ModelType.LONG),
        CLUSTER_HEALTH("cluster-health", ModelType.STRING),
        CLUSTER_NAME("cluster-name", ModelType.STRING),
        NUMBER_OF_NODES("number-of-nodes", ModelType.INT),
        CACHE_HEALTH("cache-health", ModelType.LIST),
        LOG_TAIL("log-tail", ModelType.LIST);

        private static final Map<String, HealthMetrics> MAP;
        final AttributeDefinition definition;

        private HealthMetrics(String attributeName, ModelType type) {
            this.definition = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder(attributeName).setAllowNull(false)).setStorageRuntime()).build();
        }

        public static HealthMetrics getMetric(String stringForm) {
            return MAP.get(stringForm);
        }

        public final String toString() {
            return this.definition.getName();
        }

        static {
            MAP = new HashMap<String, HealthMetrics>();
            for (HealthMetrics metric : HealthMetrics.values()) {
                MAP.put(metric.toString(), metric);
            }
        }
    }
}

