/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.server.infinispan.SecurityActions;
import org.infinispan.server.infinispan.spi.service.CacheServiceName;
import org.infinispan.statetransfer.StateTransferManager;
import org.jboss.as.clustering.infinispan.InfinispanMessages;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

public class CacheRebalancingStatusAttributeHandler
extends AbstractRuntimeOnlyHandler {
    public static final CacheRebalancingStatusAttributeHandler INSTANCE = new CacheRebalancingStatusAttributeHandler();

    public void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        ComponentRegistry registry;
        StateTransferManager stateTransferManager;
        Cache cache;
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(address.size() - 2).getValue();
        String cacheName = address.getElement(address.size() - 1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheServiceName.CACHE.getServiceName(cacheContainerName, cacheName));
        if (controller != null && (cache = (Cache)controller.getValue()) != null && (stateTransferManager = (registry = SecurityActions.getComponentRegistry(cache.getAdvancedCache())).getStateTransferManager()) != null) {
            try {
                context.getResult().set(new ModelNode().set(stateTransferManager.getRebalancingStatus()));
            }
            catch (Exception e) {
                throw new OperationFailedException(InfinispanMessages.MESSAGES.failedToInvokeOperation(e.getLocalizedMessage()));
            }
        }
    }
}

