/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Optional;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.Storage;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.api.WeakCounter;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.infinispan.SecurityActions;
import org.jboss.as.clustering.infinispan.subsystem.Attribute;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerCommands;
import org.jboss.as.clustering.infinispan.subsystem.CounterAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.CounterMetricsHandler;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class CounterResource
extends SimpleResourceDefinition {
    static final SimpleAttributeDefinition COUNTER_NAME = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("name", ModelType.STRING, false).setXmlName(Attribute.NAME.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
    static final SimpleAttributeDefinition STORAGE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("storage", ModelType.STRING, false).setXmlName(Attribute.STORAGE.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setAllowedValues(new String[]{Storage.VOLATILE.toString(), Storage.PERSISTENT.toString()})).setDefaultValue(new ModelNode().set(Storage.VOLATILE.toString()))).build();
    static final SimpleAttributeDefinition INITIAL_VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("initial-value", ModelType.LONG, true).setXmlName(Attribute.INITIAL_VALUE.getLocalName())).setAllowExpression(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setDefaultValue(new ModelNode().set(0))).build();
    static final AttributeDefinition[] ATTRIBUTES = new AttributeDefinition[]{COUNTER_NAME, STORAGE, INITIAL_VALUE};
    private static final OperationDefinition COUNTER_RESET = CounterResource.buildOperation("counter-reset").build();
    private static final OperationDefinition COUNTER_INCREASE = CounterResource.buildOperation("counter-increase").build();
    private static final OperationDefinition COUNTER_DECREASE = CounterResource.buildOperation("counter-decrease").build();
    private final boolean runtimeRegistration;

    public CounterResource(PathElement pathElement, ResourceDescriptionResolver descriptionResolver, AbstractAddStepHandler addHandler, OperationStepHandler removeHandler, boolean runtimeRegistration) {
        super(pathElement, descriptionResolver, (OperationStepHandler)addHandler, removeHandler);
        this.runtimeRegistration = runtimeRegistration;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        for (AttributeDefinition attr : ATTRIBUTES) {
            resourceRegistration.registerReadOnlyAttribute(attr, null);
        }
        if (this.runtimeRegistration) {
            CounterMetricsHandler.INSTANCE.registerMetrics(resourceRegistration);
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.runtimeRegistration) {
            resourceRegistration.registerOperationHandler(COUNTER_RESET, (OperationStepHandler)CounterResetCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(COUNTER_INCREASE, (OperationStepHandler)CounterIncreaseCommand.INSTANCE);
            resourceRegistration.registerOperationHandler(COUNTER_DECREASE, (OperationStepHandler)CounterDecreaseCommand.INSTANCE);
        }
    }

    private static SimpleOperationDefinitionBuilder buildOperation(String name) {
        return new SimpleOperationDefinitionBuilder(name, (ResourceDescriptionResolver)new InfinispanResourceDescriptionResolver("counters")).setRuntimeOnly();
    }

    private static PathElement counterElement(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        PathElement counterElement = address.getElement(address.size() - 1);
        return counterElement;
    }

    private static String counterName(ModelNode operation) {
        PathElement counterElement = CounterResource.counterElement(operation);
        return counterElement.getValue();
    }

    private static String counterType(ModelNode operation) {
        PathElement counterElement = CounterResource.counterElement(operation);
        return counterElement.getKey();
    }

    private static OperationFailedException counterManagerNotFound() {
        return new OperationFailedException("CounterManager not found in server.");
    }

    private static abstract class BaseCounterManagerCommand
    extends CacheContainerCommands {
        BaseCounterManagerCommand() {
            super(2);
        }

        abstract ModelNode invoke(CounterManager var1, ModelNode var2) throws Exception;

        @Override
        protected final ModelNode invokeCommand(EmbeddedCacheManager cacheManager, OperationContext context, ModelNode operation) throws Exception {
            Optional<CounterManager> optCounterManager = SecurityActions.findCounterManager(cacheManager);
            CounterManager counterManager = optCounterManager.orElseThrow(() -> CounterResource.counterManagerNotFound());
            return this.invoke(counterManager, operation);
        }
    }

    private static class CounterDecreaseCommand
    extends BaseCounterManagerCommand {
        private static final CounterDecreaseCommand INSTANCE = new CounterDecreaseCommand();

        private CounterDecreaseCommand() {
        }

        @Override
        protected ModelNode invoke(CounterManager counterManager, ModelNode operation) throws Exception {
            String counterName = CounterResource.counterName(operation);
            String counterType = CounterResource.counterType(operation);
            if (counterManager.isDefined(counterName)) {
                boolean isStrongCounter = "strong-counter".equals(counterType);
                if (isStrongCounter) {
                    StrongCounter strongCounter = counterManager.getStrongCounter(counterName);
                    strongCounter.sync().decrementAndGet();
                } else {
                    WeakCounter weakCounter = counterManager.getWeakCounter(counterName);
                    weakCounter.sync().decrement();
                }
            }
            return new ModelNode();
        }
    }

    private static class CounterIncreaseCommand
    extends BaseCounterManagerCommand {
        private static final CounterIncreaseCommand INSTANCE = new CounterIncreaseCommand();

        private CounterIncreaseCommand() {
        }

        @Override
        protected ModelNode invoke(CounterManager counterManager, ModelNode operation) throws Exception {
            String counterName = CounterResource.counterName(operation);
            String counterType = CounterResource.counterType(operation);
            if (counterManager.isDefined(counterName)) {
                boolean isStrongCounter = "strong-counter".equals(counterType);
                if (isStrongCounter) {
                    StrongCounter strongCounter = counterManager.getStrongCounter(counterName);
                    strongCounter.sync().incrementAndGet();
                } else {
                    WeakCounter weakCounter = counterManager.getWeakCounter(counterName);
                    weakCounter.sync().increment();
                }
            }
            return new ModelNode();
        }
    }

    private static class CounterResetCommand
    extends BaseCounterManagerCommand {
        private static final CounterResetCommand INSTANCE = new CounterResetCommand();

        private CounterResetCommand() {
        }

        @Override
        protected ModelNode invoke(CounterManager counterManager, ModelNode operation) throws Exception {
            String counterName = CounterResource.counterName(operation);
            String counterType = CounterResource.counterType(operation);
            if (counterManager.isDefined(counterName)) {
                boolean isStrongCounter = "strong-counter".equals(counterType);
                if (isStrongCounter) {
                    StrongCounter strongCounter = counterManager.getStrongCounter(counterName);
                    strongCounter.sync().reset();
                } else {
                    WeakCounter weakCounter = counterManager.getWeakCounter(counterName);
                    weakCounter.sync().reset();
                }
            }
            return new ModelNode();
        }
    }

    public static class CounterRemoveHandler
    extends AbstractRemoveStepHandler {
        private final CounterAddHandler handler = new CounterAddHandler();

        protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.handler.removeRuntimeServices(context, operation, null, null);
        }

        protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            this.handler.performRuntime(context, operation, model);
        }
    }
}

