/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.counter.configuration.CounterManagerConfiguration;
import org.infinispan.counter.configuration.CounterManagerConfigurationBuilder;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.infinispan.SecurityActions;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class CountersMetricsHandler
extends AbstractRuntimeOnlyHandler {
    public static final CountersMetricsHandler INSTANCE = new CountersMetricsHandler();
    private static final int CACHE_CONTAINER_INDEX = 1;

    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        ModelNode attributeRead = operation.require("name");
        ModelNode result = new ModelNode();
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String cacheContainerName = address.getElement(1).getValue();
        ServiceController controller = context.getServiceRegistry(false).getService(CacheContainerServiceName.CACHE_CONTAINER.getServiceName(cacheContainerName));
        String attribute = attributeRead.asString();
        if (controller != null) {
            DefaultCacheContainer cacheManager = (DefaultCacheContainer)controller.getValue();
            CounterManagerConfiguration counterManagerConfiguration = this.extractCounterManagerConfiguration(cacheManager);
            if (CounterConfigurationMetrics.NUM_OF_OWNERS.toString().equals(attribute)) {
                result.set(counterManagerConfiguration.numOwners());
            } else if (CounterConfigurationMetrics.RELIABILITY.toString().equals(attribute)) {
                result.set(counterManagerConfiguration.reliability().name());
            }
        }
        context.getResult().set(result);
    }

    public void registerMetrics(ManagementResourceRegistration container) {
        for (CounterConfigurationMetrics metric : CounterConfigurationMetrics.values()) {
            container.registerMetric(metric.definition, (OperationStepHandler)this);
        }
    }

    private CounterManagerConfiguration extractCounterManagerConfiguration(EmbeddedCacheManager cacheManager) {
        GlobalComponentRegistry globalComponentRegistry = SecurityActions.getGlobalComponentRegistry(cacheManager);
        CounterManagerConfiguration config = (CounterManagerConfiguration)globalComponentRegistry.getGlobalConfiguration().module(CounterManagerConfiguration.class);
        return config == null ? CounterManagerConfigurationBuilder.defaultConfiguration() : config;
    }

    public static enum CounterConfigurationMetrics {
        NUM_OF_OWNERS("num-owners", ModelType.LONG),
        RELIABILITY("reliability", ModelType.STRING);

        final AttributeDefinition definition;

        private CounterConfigurationMetrics(String attributeName, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(attributeName, type).setAllowNull(false)).setStorageRuntime()).build();
        }

        public final String toString() {
            return this.definition.getName();
        }
    }
}

