/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.as.controller.AttributeDefinition;

public enum Element {
    UNKNOWN((String)null),
    ALIAS("alias"),
    AUTHENTICATION("authentication"),
    AUTHORIZATION("authorization"),
    BACKUP("backup"),
    BACKUPS("backups"),
    BACKUP_FOR("backup-for"),
    BINARY("binary"),
    CACHE_CONTAINER("cache-container"),
    CONNECTION_POOL("connection-pool"),
    CLUSTER_LOADER("cluster-loader"),
    COMPATIBILITY("compatibility"),
    COMPRESSION("compression"),
    COMMON_NAME_ROLE_MAPPER("common-name-role-mapper"),
    CLUSTER_ROLE_MAPPER("cluster-role-mapper"),
    CUSTOM_CONFIGURATION_STORAGE("custom-configuration-storage"),
    CUSTOM_ROLE_MAPPER("custom-role-mapper"),
    DATA_COLUMN("data-column"),
    DIGEST("digest"),
    DISTRIBUTED_CACHE("distributed-cache"),
    DISTRIBUTED_CACHE_CONFIGURATION("distributed-cache-configuration"),
    DATA_TYPE("encoding"),
    ENCRYPTION("encryption"),
    EVICTION("eviction"),
    EXPIRATION("expiration"),
    EXTERNAL("external"),
    FILE_STORE("file-store"),
    GLOBAL_STATE("global-state"),
    MANAGED_CONFIGURATION_STORAGE("managed-configuration-storage"),
    MODULES("modules"),
    MODULE("module"),
    ID_COLUMN("id-column"),
    IDENTITY_ROLE_MAPPER("identity-role-mapper"),
    INVALIDATION_CACHE("invalidation-cache"),
    INVALIDATION_CACHE_CONFIGURATION("invalidation-cache-configuration"),
    LEVELDB_STORE("leveldb-store"),
    JDBC_STORE("jdbc-store"),
    KEY("key"),
    STRING_KEYED_JDBC_STORE("string-keyed-jdbc-store"),
    IMPLEMENTATION("implementation"),
    INDEXING("indexing"),
    INDEXED_ENTITIES("indexed-entities"),
    INDEXED_ENTITY("indexed-entity"),
    LOADER("loader"),
    LOCAL_CACHE("local-cache"),
    LOCAL_CACHE_CONFIGURATION("local-cache-configuration"),
    LOCKING("locking"),
    MEMORY("memory"),
    OBJECT("object"),
    OFF_HEAP("off-heap"),
    OVERLAY_CONFIGURATION_STORAGE("overlay-configuration-storage"),
    PARTITION_HANDLING("partition-handling"),
    PERSISTENCE("persistence"),
    PERSISTENT_LOCATION("persistent-location"),
    PLAIN("plain"),
    PROPERTY("property"),
    REHASHING("rehashing"),
    REMOTE_SERVER("remote-server"),
    REMOTE_STORE("remote-store"),
    REPLICATED_CACHE("replicated-cache"),
    REPLICATED_CACHE_CONFIGURATION("replicated-cache-configuration"),
    REST_STORE("rest-store"),
    ROCKSDB_STORE("rocksdb-store"),
    ROLE("role"),
    SECURITY("security"),
    SHARED_PERSISTENT_LOCATION("shared-persistent-location"),
    STATE_TRANSFER("state-transfer"),
    STORE("store"),
    STRING_KEYED_TABLE("string-keyed-table"),
    TAKE_OFFLINE("take-offline"),
    TEMPORARY_LOCATION("temporary-location"),
    TIMESTAMP_COLUMN("timestamp-column"),
    TRANSACTION("transaction"),
    TRANSPORT("transport"),
    VALUE("value"),
    VOLATILE_CONFIGURATION_STORAGE("volatile-configuration-storage"),
    WRITE_BEHIND("write-behind"),
    ASYNC_OPERATIONS_THREAD_POOL("async-operations-thread-pool"),
    EXPIRATION_THREAD_POOL("expiration-thread-pool"),
    LISTENER_THREAD_POOL("listener-thread-pool"),
    PERSISTENCE_THREAD_POOL("persistence-thread-pool"),
    REMOTE_COMMAND_THREAD_POOL("remote-command-thread-pool"),
    REPLICATION_QUEUE_THREAD_POOL("replication-queue-thread-pool"),
    STATE_TRANSFER_THREAD_POOL("state-transfer-thread-pool"),
    TRANSPORT_THREAD_POOL("transport-thread-pool"),
    COUNTERS("counters"),
    STRONG_COUNTER("strong-counter"),
    WEAK_COUNTER("weak-counter"),
    LOWER_BOUND("lower-bound"),
    UPPER_BOUND("upper-bound");

    private final String name;
    private final AttributeDefinition definition;
    private static final Map<String, Element> elements;

    private Element(String name) {
        this.name = name;
        this.definition = null;
    }

    private Element(AttributeDefinition definition) {
        this.name = definition.getXmlName();
        this.definition = definition;
    }

    public String getLocalName() {
        return this.name;
    }

    public AttributeDefinition getDefinition() {
        return this.definition;
    }

    public static Element forName(String localName) {
        Element element = elements.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        elements = map;
    }
}

