/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PartitionHandlingConfigurationBuilder;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.partitionhandling.PartitionHandling;
import org.jboss.as.clustering.infinispan.conflict.DeployedMergePolicy;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationAdd;
import org.jboss.as.clustering.infinispan.subsystem.ClusteredCacheConfigurationAdd;
import org.jboss.as.clustering.infinispan.subsystem.PartitionHandlingConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.StateTransferConfigurationResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public abstract class SharedStateCacheConfigurationAdd
extends ClusteredCacheConfigurationAdd {
    SharedStateCacheConfigurationAdd(CacheMode mode) {
        super(mode);
    }

    @Override
    void processModelNode(OperationContext context, String containerName, ModelNode cache, ConfigurationBuilder builder, List<CacheConfigurationAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, cache, builder, dependencies);
        if (cache.hasDefined("state-transfer") && cache.get(new String[]{"state-transfer", "STATE_TRANSFER"}).isDefined()) {
            ModelNode stateTransfer = cache.get(new String[]{"state-transfer", "STATE_TRANSFER"});
            boolean enabled = StateTransferConfigurationResource.ENABLED.resolveModelAttribute(context, stateTransfer).asBoolean();
            boolean awaitInitialTransfer = StateTransferConfigurationResource.AWAIT_INITIAL_TRANSFER.resolveModelAttribute(context, stateTransfer).asBoolean();
            long timeout = StateTransferConfigurationResource.TIMEOUT.resolveModelAttribute(context, stateTransfer).asLong();
            int chunkSize = StateTransferConfigurationResource.CHUNK_SIZE.resolveModelAttribute(context, stateTransfer).asInt();
            builder.clustering().stateTransfer().fetchInMemoryState(enabled);
            builder.clustering().stateTransfer().awaitInitialTransfer(awaitInitialTransfer);
            builder.clustering().stateTransfer().timeout(timeout);
            builder.clustering().stateTransfer().chunkSize(chunkSize);
        }
        if (cache.hasDefined("partition-handling") && cache.get(new String[]{"partition-handling", "PARTITION_HANDLING"}).isDefined()) {
            String policyClassName;
            MergePolicy mergePolicy;
            ModelNode partitionHandling = cache.get(new String[]{"partition-handling", "PARTITION_HANDLING"});
            PartitionHandlingConfigurationBuilder phBuilder = builder.clustering().partitionHandling();
            phBuilder.enabled(PartitionHandlingConfigurationResource.ENABLED.resolveModelAttribute(context, partitionHandling).asBoolean());
            String phType = PartitionHandlingConfigurationResource.WHEN_SPLIT.resolveModelAttribute(context, partitionHandling).asString();
            if (phType != null) {
                phBuilder.whenSplit(PartitionHandling.valueOf((String)phType));
            }
            Object policy = (mergePolicy = MergePolicy.fromString((String)(policyClassName = PartitionHandlingConfigurationResource.MERGE_POLICY.resolveModelAttribute(context, partitionHandling).asString()))) != MergePolicy.CUSTOM ? mergePolicy : new DeployedMergePolicy(policyClassName);
            phBuilder.mergePolicy((EntryMergePolicy)policy);
        }
    }
}

