/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.counter.api.CounterConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.CounterAddHandler;
import org.jboss.as.clustering.infinispan.subsystem.StrongCounterResource;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.dmr.ModelNode;

public class StrongCounterAddHandler
extends CounterAddHandler {
    @Override
    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        super.populate(fromModel, toModel);
        for (SimpleAttributeDefinition attr : StrongCounterResource.STRONG_ATTRIBUTES) {
            attr.validateAndSet(fromModel, toModel);
        }
    }

    @Override
    void processModelNode(OperationContext context, ModelNode counter, CounterConfiguration.Builder builder) throws OperationFailedException {
        super.processModelNode(context, counter, builder);
        ModelNode upperBoundModel = counter.get("upper-bound");
        ModelNode lowerBoundModel = counter.get("lower-bound");
        if (lowerBoundModel.isDefined()) {
            Long lowerBound = StrongCounterResource.LOWER_BOUND.resolveModelAttribute(context, counter).asLong();
            builder.lowerBound(lowerBound.longValue());
        }
        if (upperBoundModel.isDefined()) {
            Long upperBound = StrongCounterResource.UPPER_BOUND.resolveModelAttribute(context, counter).asLong();
            builder.upperBound(upperBound.longValue());
        }
    }
}

