/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.infinispan.task;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.Security;
import org.infinispan.security.actions.GetCacheComponentRegistryAction;
import org.infinispan.security.actions.GetCacheGlobalComponentRegistryAction;
import org.infinispan.security.actions.GetGlobalComponentRegistryAction;

public final class SecurityActions {
    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return (T)Security.doPrivileged(action);
    }

    static ComponentRegistry getComponentRegistry(AdvancedCache<?, ?> cache) {
        GetCacheComponentRegistryAction action = new GetCacheComponentRegistryAction(cache);
        return (ComponentRegistry)SecurityActions.doPrivileged(action);
    }

    static GlobalComponentRegistry getGlobalComponentRegistry(EmbeddedCacheManager cacheManager) {
        GetGlobalComponentRegistryAction action = new GetGlobalComponentRegistryAction(cacheManager);
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(action);
    }

    public static GlobalComponentRegistry getGlobalComponentRegistry(Cache<Object, Object> cache) {
        return (GlobalComponentRegistry)SecurityActions.doPrivileged(new GetCacheGlobalComponentRegistryAction(cache.getAdvancedCache()));
    }
}

