/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedList;
import java.util.List;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.conflict.EntryMergePolicyFactory;
import org.infinispan.conflict.EntryMergePolicyFactoryRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStarted;
import org.infinispan.notifications.cachemanagerlistener.annotation.CacheStopped;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStartedEvent;
import org.infinispan.notifications.cachemanagerlistener.event.CacheStoppedEvent;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.commons.service.Builder;
import org.infinispan.server.infinispan.spi.CacheContainer;
import org.infinispan.server.infinispan.spi.service.CacheContainerServiceName;
import org.infinispan.server.infinispan.task.ServerTaskRegistry;
import org.infinispan.server.infinispan.task.ServerTaskRegistryService;
import org.jboss.as.clustering.infinispan.DefaultCacheContainer;
import org.jboss.as.clustering.infinispan.InfinispanLogger;
import org.jboss.as.clustering.infinispan.conflict.DeployedMergePolicyFactory;
import org.jboss.as.clustering.infinispan.conflict.DeployedMergePolicyFactoryService;
import org.jboss.as.clustering.infinispan.subsystem.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

@Listener
public class CacheContainerBuilder
implements Builder<CacheContainer>,
Service<CacheContainer> {
    private static final Logger log = Logger.getLogger((String)CacheContainerBuilder.class.getPackage().getName());
    private final InjectedValue<GlobalConfiguration> configuration = new InjectedValue();
    private final InjectedValue<ServerTaskRegistry> serverTaskRegistry = new InjectedValue();
    private final InjectedValue<DeployedMergePolicyFactory> deployedMergePolicyRegistry = new InjectedValue();
    private final List<String> aliases = new LinkedList<String>();
    private final String name;
    private final String defaultCache;
    private volatile CacheContainer container;

    public CacheContainerBuilder(String name, String defaultCache) {
        this.name = name;
        this.defaultCache = defaultCache;
    }

    public ServiceName getServiceName() {
        return CacheContainerServiceName.CACHE_CONTAINER.getServiceName(this.name);
    }

    public ServiceBuilder<CacheContainer> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)this).addDependency(CacheContainerServiceName.CONFIGURATION.getServiceName(this.name), GlobalConfiguration.class, this.configuration).addDependency(ServerTaskRegistryService.SERVICE_NAME, ServerTaskRegistry.class, this.serverTaskRegistry).addDependency(DeployedMergePolicyFactoryService.SERVICE_NAME, DeployedMergePolicyFactory.class, this.deployedMergePolicyRegistry);
        for (String alias : this.aliases) {
            builder.addAliases(new ServiceName[]{CacheContainerServiceName.CACHE_CONTAINER.getServiceName(alias)});
        }
        return builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public CacheContainerBuilder addAlias(String alias) {
        this.aliases.add(alias);
        return this;
    }

    public CacheContainer getValue() {
        return this.container;
    }

    public void start(StartContext context) {
        GlobalConfiguration config = (GlobalConfiguration)this.configuration.getValue();
        this.container = new DefaultCacheContainer(config, this.defaultCache);
        SecurityActions.getGlobalComponentRegistry(this.container).registerComponent(this.serverTaskRegistry.getValue(), ServerTaskRegistry.class);
        SecurityActions.registerAndStartContainer(this.container, this);
        EntryMergePolicyFactoryRegistry mergePolicyRegistry = (EntryMergePolicyFactoryRegistry)SecurityActions.getGlobalComponentRegistry(this.container).getComponent(EntryMergePolicyFactoryRegistry.class);
        mergePolicyRegistry.addMergePolicyFactory((EntryMergePolicyFactory)this.deployedMergePolicyRegistry.getValue());
        InfinispanLogger.ROOT_LOGGER.cacheContainerStarted(this.name);
    }

    public void stop(StopContext context) {
        if (this.container != null && SecurityActions.stopAndUnregisterContainer(this.container, this)) {
            log.debugf("%s cache container stopped", (Object)this.name);
        }
        InfinispanLogger.ROOT_LOGGER.cacheContainerStopped(this.name);
    }

    @CacheStarted
    public void cacheStarted(CacheStartedEvent event) {
        if (!((InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry(event.getCacheManager()).getComponent(InternalCacheRegistry.class)).isInternalCache(event.getCacheName())) {
            InfinispanLogger.ROOT_LOGGER.cacheStarted(event.getCacheName(), this.name);
        }
    }

    @CacheStopped
    public void cacheStopped(CacheStoppedEvent event) {
        if (!((InternalCacheRegistry)SecurityActions.getGlobalComponentRegistry(event.getCacheManager()).getComponent(InternalCacheRegistry.class)).isInternalCache(event.getCacheName())) {
            InfinispanLogger.ROOT_LOGGER.cacheStopped(event.getCacheName(), this.name);
        }
    }
}

