/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheConfigurationAdd;
import org.jboss.as.clustering.infinispan.subsystem.DistributedCacheConfigurationResource;
import org.jboss.as.clustering.infinispan.subsystem.SharedStateCacheConfigurationAdd;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;

public class DistributedCacheConfigurationAdd
extends SharedStateCacheConfigurationAdd {
    static final DistributedCacheConfigurationAdd INSTANCE = new DistributedCacheConfigurationAdd();

    DistributedCacheConfigurationAdd() {
        super(CacheMode.DIST_SYNC);
    }

    @Override
    void populate(ModelNode fromModel, ModelNode toModel) throws OperationFailedException {
        super.populate(fromModel, toModel);
        for (AttributeDefinition attribute : DistributedCacheConfigurationResource.ATTRIBUTES) {
            attribute.validateAndSet(fromModel, toModel);
        }
    }

    @Override
    void processModelNode(OperationContext context, String containerName, String cacheName, ModelNode cache, ConfigurationBuilder builder, List<CacheConfigurationAdd.Dependency<?>> dependencies) throws OperationFailedException {
        super.processModelNode(context, containerName, cacheName, cache, builder, dependencies);
        int owners = DistributedCacheConfigurationResource.OWNERS.resolveModelAttribute(context, cache).asInt();
        int segments = DistributedCacheConfigurationResource.SEGMENTS.resolveModelAttribute(context, cache).asInt();
        float capacityFactor = (float)DistributedCacheConfigurationResource.CAPACITY_FACTOR.resolveModelAttribute(context, cache).asDouble();
        long lifespan = DistributedCacheConfigurationResource.L1_LIFESPAN.resolveModelAttribute(context, cache).asLong();
        builder.clustering().hash().numOwners(owners).numSegments(segments).capacityFactor(capacityFactor);
        if (lifespan > 0L) {
            builder.clustering().l1().enable().lifespan(lifespan);
        } else {
            builder.clustering().l1().disable();
        }
    }
}

