/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.ModelVersion;

class InfinispanSchema {
    private static final String URN_PATTERN = "urn:%s:%d.%d";
    static final List<InfinispanSchema> SCHEMAS = new ArrayList<InfinispanSchema>();
    static final InfinispanSchema CURRENT;
    private final String domain;
    private final int major;
    private final int minor;

    private InfinispanSchema(String domain, int major, int minor) {
        this.domain = domain;
        this.major = major;
        this.minor = minor;
    }

    public boolean since(int major, int minor) {
        return this.major > major || this.major == major && this.minor >= minor;
    }

    public boolean equals(int major, int minor) {
        return this.major == major && this.minor == minor;
    }

    public boolean since(InfinispanSchema ... schemas) {
        for (InfinispanSchema schema : schemas) {
            if (!this.domain.equals(schema.domain) || this.major <= schema.major && (this.major != schema.major || this.minor < schema.minor)) continue;
            return true;
        }
        return false;
    }

    public String getNamespaceUri() {
        return this.format(URN_PATTERN);
    }

    String format(String pattern) {
        return String.format(pattern, this.domain, this.major, this.minor);
    }

    ModelVersion getVersion() {
        return ModelVersion.create((int)this.major, (int)this.minor);
    }

    static {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(InfinispanSchema.class.getResourceAsStream("/schema/infinispan-infinispan.namespaces"), StandardCharsets.UTF_8));){
            r.lines().forEach(line -> {
                int colon = line.lastIndexOf(58);
                String[] parts = line.substring(colon + 1).split("\\.");
                SCHEMAS.add(new InfinispanSchema(line.substring(0, colon), Integer.parseInt(parts[0]), Integer.parseInt(parts[1])));
            });
            CURRENT = SCHEMAS.get(SCHEMAS.size() - 1);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

