/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.infinispan.server.commons.service.Builder;
import org.infinispan.server.commons.service.Dependency;
import org.infinispan.server.commons.service.InjectedValueDependency;
import org.infinispan.server.commons.service.ServiceNameProvider;
import org.infinispan.server.commons.service.ValueDependency;
import org.infinispan.server.jgroups.JChannelFactory;
import org.infinispan.server.jgroups.ProtocolDefaults;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.ProtocolConfiguration;
import org.infinispan.server.jgroups.spi.ProtocolStackConfiguration;
import org.infinispan.server.jgroups.spi.RelayConfiguration;
import org.infinispan.server.jgroups.spi.SaslConfiguration;
import org.infinispan.server.jgroups.spi.TransportConfiguration;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.infinispan.server.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.ProtocolDefaultsBuilder;
import org.infinispan.server.jgroups.subsystem.RelayConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.SaslConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.TransportConfigurationBuilder;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.as.server.Services;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class JChannelFactoryBuilder
implements Builder<ChannelFactory>,
Value<ChannelFactory>,
ProtocolStackConfiguration {
    private final InjectedValue<ProtocolDefaults> defaults = new InjectedValue();
    private final InjectedValue<ServerEnvironment> environment = new InjectedValue();
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final String name;
    private ValueDependency<TransportConfiguration> transport = null;
    private final List<ValueDependency<ProtocolConfiguration>> protocols = new LinkedList<ValueDependency<ProtocolConfiguration>>();
    private ValueDependency<RelayConfiguration> relay = null;
    private ValueDependency<SaslConfiguration> sasl = null;

    public JChannelFactoryBuilder(String name) {
        this.name = name;
    }

    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.name);
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ProtocolDefaultsBuilder.SERVICE_NAME, ProtocolDefaults.class, this.defaults).addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.environment).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).setInitialMode(ServiceController.Mode.ON_DEMAND);
        if (this.transport != null) {
            this.transport.register(builder);
        }
        for (Dependency dependency : this.protocols) {
            dependency.register(builder);
        }
        if (this.relay != null) {
            this.relay.register(builder);
        }
        if (this.sasl != null) {
            this.sasl.register(builder);
        }
        return builder;
    }

    public ChannelFactory getValue() {
        return new JChannelFactory(this);
    }

    public TransportConfigurationBuilder setTransport(String type) {
        TransportConfigurationBuilder builder = new TransportConfigurationBuilder(this.name, type);
        this.transport = new InjectedValueDependency((ServiceNameProvider)builder, TransportConfiguration.class);
        return builder;
    }

    public ProtocolConfigurationBuilder addProtocol(String type) {
        ProtocolConfigurationBuilder builder = new ProtocolConfigurationBuilder(this.name, type);
        this.protocols.add((ValueDependency<ProtocolConfiguration>)new InjectedValueDependency((ServiceNameProvider)builder, ProtocolConfiguration.class));
        return builder;
    }

    public RelayConfigurationBuilder setRelay(String site) {
        RelayConfigurationBuilder builder = new RelayConfigurationBuilder(this.name).setSiteName(site);
        this.relay = new InjectedValueDependency((ServiceNameProvider)builder, RelayConfiguration.class);
        return builder;
    }

    public SaslConfigurationBuilder setSasl(String mech, String securityRealm) {
        SaslConfigurationBuilder builder = new SaslConfigurationBuilder(this.name).setMech(mech).setSecurityRealm(securityRealm);
        this.sasl = new InjectedValueDependency((ServiceNameProvider)builder, SaslConfiguration.class);
        return builder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Map<String, String> getDefaultProperties(String protocol) {
        return ((ProtocolDefaults)this.defaults.getValue()).getProperties(protocol);
    }

    @Override
    public TransportConfiguration getTransport() {
        return this.transport != null ? (TransportConfiguration)this.transport.getValue() : null;
    }

    @Override
    public List<ProtocolConfiguration> getProtocols() {
        ArrayList<ProtocolConfiguration> protocols = new ArrayList<ProtocolConfiguration>(this.protocols.size());
        for (Value value : this.protocols) {
            protocols.add((ProtocolConfiguration)value.getValue());
        }
        return protocols;
    }

    @Override
    public String getNodeName() {
        return ((ServerEnvironment)this.environment.getValue()).getNodeName();
    }

    @Override
    public RelayConfiguration getRelay() {
        return this.relay != null ? (RelayConfiguration)this.relay.getValue() : null;
    }

    @Override
    public SaslConfiguration getSasl() {
        return this.sasl != null ? (SaslConfiguration)this.sasl.getValue() : null;
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return (ModuleLoader)this.loader.getValue();
    }
}

