/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.as.clustering.msc.ServiceContainerHelper;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.Channel;
import org.jgroups.stack.ProtocolStack;

public class ExportNativeConfiguration
extends AbstractRuntimeOnlyHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress stackAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String stackName = stackAddress.getLastElement().getValue();
        ServiceRegistry registry = context.getServiceRegistry(false);
        ServiceName serviceName = ChannelFactoryService.getServiceName(stackName);
        try {
            ServiceController controller = registry.getRequiredService(serviceName);
            controller.setMode(ServiceController.Mode.ACTIVE);
            try {
                ChannelFactory factory = (ChannelFactory)ServiceContainerHelper.getValue((ServiceController)controller, ChannelFactory.class);
                Channel channel = factory.createChannel(UUID.randomUUID().toString());
                try {
                    List protocols = channel.getProtocolStack().getProtocols();
                    Collections.reverse(protocols);
                    ProtocolStack stack = new ProtocolStack();
                    stack.addProtocols(protocols);
                    context.getResult().set(stack.printProtocolSpecAsXML());
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
                finally {
                    channel.close();
                }
            }
            finally {
                controller.setMode(ServiceController.Mode.ON_DEMAND);
            }
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

