/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.jgroups.subsystem.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.Element;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemRootResource;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResource;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResource;
import org.jboss.as.clustering.jgroups.subsystem.TransportResource;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;

public class JGroupsSubsystemXMLReader_1_1
implements XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)subsystemAddress);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_STACK: {
                    JGroupsSubsystemRootResource.DEFAULT_STACK.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!subsystem.hasDefined("default-stack")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEFAULT_STACK));
        }
        operations.add(subsystem);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Namespace.forUri(reader.getNamespaceURI())) {
                case JGROUPS_1_1: {
                    Element element = Element.forName(reader.getLocalName());
                    switch (element) {
                        case STACK: {
                            this.parseStack(reader, subsystemAddress, operations);
                            continue block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStack(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        PathAddress stackAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"stack", name)});
        ModelNode stack = Util.createAddOperation((PathAddress)stackAddress);
        stack.get("address").set(stackAddress.toModelNode());
        if (!reader.hasNext() || reader.nextTag() == 2 || Element.forName(reader.getLocalName()) != Element.TRANSPORT) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.TRANSPORT));
        }
        operations.add(stack);
        this.parseTransport(reader, stackAddress, operations);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROTOCOL: {
                    this.parseProtocol(reader, stackAddress, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress stackAddress, List<ModelNode> operations) throws XMLStreamException {
        PathAddress transportAddress = stackAddress.append(new PathElement[]{PathElement.pathElement((String)"transport", (String)"TRANSPORT")});
        ModelNode transport = Util.createAddOperation((PathAddress)transportAddress);
        block18: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    try {
                        TP.class.getClassLoader().loadClass("org.jgroups.protocols." + value).asSubclass(TP.class).newInstance();
                        TransportResource.TYPE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                        continue block18;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case SHARED: {
                    TransportResource.SHARED.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case SOCKET_BINDING: {
                    TransportResource.SOCKET_BINDING.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case DIAGNOSTICS_SOCKET_BINDING: {
                    TransportResource.DIAGNOSTICS_SOCKET_BINDING.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case DEFAULT_EXECUTOR: {
                    TransportResource.DEFAULT_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case OOB_EXECUTOR: {
                    TransportResource.OOB_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case TIMER_EXECUTOR: {
                    TransportResource.TIMER_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case THREAD_FACTORY: {
                    TransportResource.THREAD_FACTORY.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case SITE: {
                    TransportResource.SITE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case RACK: {
                    TransportResource.RACK.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case MACHINE: {
                    TransportResource.MACHINE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!transport.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        operations.add(transport);
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseProperty(reader, transportAddress, operations);
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProtocol(XMLExtendedStreamReader reader, PathAddress stackAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode protocol = Util.createOperation((String)"add-protocol", (PathAddress)stackAddress);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    try {
                        Protocol.class.getClassLoader().loadClass("org.jgroups.protocols." + value).asSubclass(Protocol.class).newInstance();
                        ProtocolResource.TYPE.parseAndSetParameter(value, protocol, (XMLStreamReader)reader);
                        continue block9;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case SOCKET_BINDING: {
                    ProtocolResource.SOCKET_BINDING.parseAndSetParameter(value, protocol, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!protocol.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        PathAddress protocolAddress = stackAddress.append(new PathElement[]{PathElement.pathElement((String)"protocol", (String)protocol.get("type").asString())});
        operations.add(protocol);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseProperty(reader, protocolAddress, operations);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, PathAddress transportOrProtocolAddress, List<ModelNode> operations) throws XMLStreamException {
        String propertyName = null;
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (propertyName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        String propertyValue = reader.getElementText();
        PathAddress propertyAddress = transportOrProtocolAddress.append(new PathElement[]{PathElement.pathElement((String)"property", propertyName)});
        ModelNode property = Util.createAddOperation((PathAddress)propertyAddress);
        PropertyResource.VALUE.parseAndSetParameter(propertyValue, property, (XMLStreamReader)reader);
        operations.add(property);
    }
}

