/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.JGroupsMessages;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class TransportLayerAdd
implements OperationStepHandler {
    AttributeDefinition[] attributes;

    public TransportLayerAdd(AttributeDefinition ... attributes) {
        this.attributes = attributes;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathElement transportRelativePath = PathElement.pathElement((String)"transport", (String)"TRANSPORT");
        Resource resource = context.createResource(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        for (AttributeDefinition attribute : this.attributes) {
            if (attribute.getName().equals("properties")) continue;
            attribute.validateAndSet(operation, subModel);
        }
        if (operation.hasDefined("properties")) {
            for (Property property : operation.get("properties").asPropertyList()) {
                Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"property", (String)property.getName())}));
                ModelNode value = property.getValue();
                if (!value.isDefined()) {
                    throw JGroupsMessages.MESSAGES.propertyNotDefined(property.getName(), transportRelativePath.toString());
                }
                param.getModel().get("value").set(value);
            }
        }
        this.reloadRequiredStep(context);
        context.stepCompleted();
    }

    void reloadRequiredStep(OperationContext context) {
        if (context.getProcessType().isServer() && !context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

