/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.clustering.jgroups.subsystem.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.Element;
import org.jboss.as.clustering.jgroups.subsystem.Namespace;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolStackAdd;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SaslResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JGroupsSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            this.writeOptional(writer, Attribute.DEFAULT_STACK, model, "default-stack");
            for (Property property : model.get("stack").asPropertyList()) {
                writer.writeStartElement(Element.STACK.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode stack = property.getValue();
                if (stack.hasDefined("transport")) {
                    ModelNode transport = stack.get(new String[]{"transport", "TRANSPORT"});
                    this.writeProtocol(writer, transport, Element.TRANSPORT);
                }
                if (stack.hasDefined("protocol")) {
                    for (Property protocol : ProtocolStackAdd.getOrderedProtocolPropertyList(stack)) {
                        this.writeProtocol(writer, protocol.getValue(), Element.PROTOCOL);
                    }
                }
                if (stack.hasDefined("relay")) {
                    ModelNode relay = stack.get(new String[]{"relay", "RELAY"});
                    this.writeRelay(writer, relay, Element.RELAY);
                }
                if (stack.hasDefined("sasl")) {
                    ModelNode sasl = stack.get(new String[]{"sasl", "SASL"});
                    this.writeSasl(writer, sasl, Element.SASL);
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeProtocol(XMLExtendedStreamWriter writer, ModelNode protocol, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        this.writeRequired(writer, Attribute.TYPE, protocol, "type");
        this.writeOptional(writer, Attribute.SHARED, protocol, "shared");
        this.writeOptional(writer, Attribute.SOCKET_BINDING, protocol, "socket-binding");
        this.writeOptional(writer, Attribute.DIAGNOSTICS_SOCKET_BINDING, protocol, "diagnostics-socket-binding");
        this.writeOptional(writer, Attribute.DEFAULT_EXECUTOR, protocol, "default-executor");
        this.writeOptional(writer, Attribute.OOB_EXECUTOR, protocol, "oob-executor");
        this.writeOptional(writer, Attribute.TIMER_EXECUTOR, protocol, "timer-executor");
        this.writeOptional(writer, Attribute.THREAD_FACTORY, protocol, "thread-factory");
        this.writeOptional(writer, Attribute.MACHINE, protocol, "machine");
        this.writeOptional(writer, Attribute.RACK, protocol, "rack");
        this.writeOptional(writer, Attribute.SITE, protocol, "site");
        this.writeProtocolProperties(writer, protocol);
        writer.writeEndElement();
    }

    private void writeProtocolProperties(XMLExtendedStreamWriter writer, ModelNode protocol) throws XMLStreamException {
        if (protocol.hasDefined("property")) {
            for (Property property : protocol.get("property").asPropertyList()) {
                writer.writeStartElement(Element.PROPERTY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                Property complexValue = property.getValue().asProperty();
                writer.writeCharacters(complexValue.getValue().asString());
                writer.writeEndElement();
            }
        }
    }

    private void writeRelay(XMLExtendedStreamWriter writer, ModelNode relay, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        RelayResourceDefinition.SITE.marshallAsAttribute(relay, (XMLStreamWriter)writer);
        for (Property property : relay.get("remote-site").asPropertyList()) {
            writer.writeStartElement(Element.REMOTE_SITE.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
            ModelNode remoteSite = property.getValue();
            RemoteSiteResourceDefinition.STACK.marshallAsAttribute(remoteSite, (XMLStreamWriter)writer);
            RemoteSiteResourceDefinition.CLUSTER.marshallAsAttribute(remoteSite, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        this.writeProtocolProperties(writer, relay);
        writer.writeEndElement();
    }

    private void writeSasl(XMLExtendedStreamWriter writer, ModelNode sasl, Element element) throws XMLStreamException {
        writer.writeStartElement(element.getLocalName());
        for (SimpleAttributeDefinition attr : SaslResourceDefinition.ATTRIBUTES) {
            attr.marshallAsAttribute(sasl, (XMLStreamWriter)writer);
        }
        this.writeProtocolProperties(writer, sasl);
        writer.writeEndElement();
    }

    private void writeRequired(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        writer.writeAttribute(attribute.getLocalName(), model.require(key).asString());
    }

    private void writeOptional(XMLExtendedStreamWriter writer, Attribute attribute, ModelNode model, String key) throws XMLStreamException {
        if (model.hasDefined(key)) {
            writer.writeAttribute(attribute.getLocalName(), model.get(key).asString());
        }
    }
}

