/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    PROPERTY("property"),
    PROTOCOL("protocol"),
    RELAY("relay"),
    REMOTE_SITE("remote-site"),
    SASL("sasl"),
    STACK("stack"),
    TRANSPORT("transport");

    private final String name;
    private static final Map<String, Element> elements;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = elements.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        elements = map;
    }
}

