/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.clustering.jgroups.subsystem.Attribute;
import org.jboss.as.clustering.jgroups.subsystem.Element;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemRootResource;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RelayResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.SaslResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;

public class JGroupsSubsystemXMLReader_7_0
implements XMLElementReader<List<ModelNode>> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> operations) throws XMLStreamException {
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsExtension.SUBSYSTEM_PATH});
        ModelNode subsystem = Util.createAddOperation((PathAddress)subsystemAddress);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT_STACK: {
                    JGroupsSubsystemRootResource.DEFAULT_STACK.parseAndSetParameter(value, subsystem, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!subsystem.hasDefined("default-stack")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.DEFAULT_STACK));
        }
        operations.add(subsystem);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STACK: {
                    this.parseStack(reader, subsystemAddress, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStack(XMLExtendedStreamReader reader, PathAddress subsystemAddress, List<ModelNode> operations) throws XMLStreamException {
        String name = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        PathAddress stackAddress = subsystemAddress.append(new PathElement[]{PathElement.pathElement((String)"stack", name)});
        ModelNode stack = Util.createAddOperation((PathAddress)stackAddress);
        if (!reader.hasNext() || reader.nextTag() == 2 || Element.forName(reader.getLocalName()) != Element.TRANSPORT) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.TRANSPORT));
        }
        operations.add(stack);
        this.parseTransport(reader, stackAddress, operations);
        boolean hasRelay = false;
        boolean hasSasl = false;
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROTOCOL: {
                    if (!hasRelay) {
                        this.parseProtocol(reader, stackAddress, operations);
                        continue block9;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case RELAY: {
                    if (!hasRelay) {
                        this.parseRelay(reader, stackAddress, operations);
                        hasRelay = true;
                        continue block9;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case SASL: {
                    if (!hasSasl) {
                        this.parseSasl(reader, stackAddress, operations);
                        hasSasl = true;
                        continue block9;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress stackAddress, List<ModelNode> operations) throws XMLStreamException {
        PathAddress transportAddress = stackAddress.append(new PathElement[]{PathElement.pathElement((String)"transport", (String)"TRANSPORT")});
        ModelNode transport = Util.createAddOperation((PathAddress)transportAddress);
        block18: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    try {
                        TP.class.getClassLoader().loadClass("org.jgroups.protocols." + value).asSubclass(TP.class).newInstance();
                        TransportResourceDefinition.TYPE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                        continue block18;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case SHARED: {
                    TransportResourceDefinition.SHARED.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case SOCKET_BINDING: {
                    TransportResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case DIAGNOSTICS_SOCKET_BINDING: {
                    TransportResourceDefinition.DIAGNOSTICS_SOCKET_BINDING.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case DEFAULT_EXECUTOR: {
                    TransportResourceDefinition.DEFAULT_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case OOB_EXECUTOR: {
                    TransportResourceDefinition.OOB_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case TIMER_EXECUTOR: {
                    TransportResourceDefinition.TIMER_EXECUTOR.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case THREAD_FACTORY: {
                    TransportResourceDefinition.THREAD_FACTORY.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case SITE: {
                    TransportResourceDefinition.SITE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case RACK: {
                    TransportResourceDefinition.RACK.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                case MACHINE: {
                    TransportResourceDefinition.MACHINE.parseAndSetParameter(value, transport, (XMLStreamReader)reader);
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!transport.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        operations.add(transport);
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseProperty(reader, transportAddress, operations);
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProtocol(XMLExtendedStreamReader reader, PathAddress stackAddress, List<ModelNode> operations) throws XMLStreamException {
        ModelNode protocol = Util.createOperation((String)"add-protocol", (PathAddress)stackAddress);
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TYPE: {
                    try {
                        Protocol.class.getClassLoader().loadClass("org.jgroups.protocols." + value).asSubclass(Protocol.class).newInstance();
                        ProtocolResourceDefinition.TYPE.parseAndSetParameter(value, protocol, (XMLStreamReader)reader);
                        continue block9;
                    }
                    catch (Exception e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case SOCKET_BINDING: {
                    ProtocolResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, protocol, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!protocol.hasDefined("type")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.TYPE));
        }
        PathAddress protocolAddress = stackAddress.append(new PathElement[]{PathElement.pathElement((String)"protocol", (String)protocol.get("type").asString())});
        operations.add(protocol);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseProperty(reader, protocolAddress, operations);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, PathAddress address, List<ModelNode> operations) throws XMLStreamException {
        String propertyName = null;
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    propertyName = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (propertyName == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        String propertyValue = reader.getElementText();
        PathAddress propertyAddress = address.append(new PathElement[]{PathElement.pathElement((String)"property", propertyName)});
        ModelNode property = Util.createAddOperation((PathAddress)propertyAddress);
        PropertyResourceDefinition.VALUE.parseAndSetParameter(propertyValue, property, (XMLStreamReader)reader);
        operations.add(property);
    }

    private void parseRelay(XMLExtendedStreamReader reader, PathAddress stackAddress, List<ModelNode> operations) throws XMLStreamException {
        PathAddress relayAddress = stackAddress.append(new PathElement[]{PathElement.pathElement((String)"relay", (String)"RELAY")});
        ModelNode operation = Util.createAddOperation((PathAddress)relayAddress);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    RelayResourceDefinition.SITE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!operation.hasDefined("site")) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.SITE));
        }
        operations.add(operation);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITE: {
                    this.parseRemoteSite(reader, relayAddress, operations);
                    continue block8;
                }
                case PROPERTY: {
                    this.parseProperty(reader, relayAddress, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteSite(XMLExtendedStreamReader reader, PathAddress relayAddress, List<ModelNode> operations) throws XMLStreamException {
        String site = null;
        ModelNode operation = Util.createAddOperation();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    site = value;
                    continue block5;
                }
                case STACK: {
                    RemoteSiteResourceDefinition.STACK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                case CLUSTER: {
                    RemoteSiteResourceDefinition.CLUSTER.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (site == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.NAME));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        PathAddress siteAddress = relayAddress.append(new PathElement[]{PathElement.pathElement((String)"remote-site", site)});
        operation.get("address").set(siteAddress.toModelNode());
        operations.add(operation);
    }

    private void parseSasl(XMLExtendedStreamReader reader, PathAddress stackAddress, List<ModelNode> operations) throws XMLStreamException {
        PathAddress saslAddress = stackAddress.append(new PathElement[]{PathElement.pathElement((String)"sasl", (String)"SASL")});
        ModelNode operation = Util.createAddOperation((PathAddress)saslAddress);
        EnumSet<Attribute> required = EnumSet.of(Attribute.MECH, Attribute.SECURITY_REALM);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLUSTER_ROLE: {
                    SaslResourceDefinition.CLUSTER_ROLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case MECH: {
                    SaslResourceDefinition.MECH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case SECURITY_REALM: {
                    SaslResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        operations.add(operation);
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseProperty(reader, saslAddress, operations);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

