/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.jgroups.JGroupsMessages;
import org.jboss.as.clustering.jgroups.subsystem.PropertyResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class ProtocolLayerAdd
implements OperationStepHandler {
    AttributeDefinition[] attributes;

    public ProtocolLayerAdd(AttributeDefinition ... attributes) {
        this.attributes = attributes;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        Resource resource = context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        ModelNode subModel = resource.getModel();
        ModelNode type = ProtocolResourceDefinition.TYPE.validateOperation(operation);
        PathElement protocolRelativePath = PathElement.pathElement((String)"protocol", (String)type.asString());
        if (resource.hasChild(protocolRelativePath)) {
            throw JGroupsMessages.MESSAGES.protocolAlreadyDefined(protocolRelativePath.toString());
        }
        Resource childResource = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolRelativePath}));
        ModelNode protocol = childResource.getModel();
        for (AttributeDefinition attribute : this.attributes) {
            if (attribute.getName().equals("properties")) continue;
            attribute.validateAndSet(operation, protocol);
        }
        ModelNode protocols = subModel.get("protocols");
        if (!protocols.isDefined()) {
            protocols.setEmptyList();
        }
        protocols.add(type);
        if (operation.hasDefined("properties")) {
            for (Property property : operation.get("properties").asPropertyList()) {
                Resource param = context.createResource(PathAddress.pathAddress((PathElement[])new PathElement[]{protocolRelativePath, PathElement.pathElement((String)"property", (String)property.getName())}));
                ModelNode value = property.getValue();
                if (!value.isDefined()) {
                    throw JGroupsMessages.MESSAGES.propertyNotDefined(property.getName(), protocolRelativePath.toString());
                }
                PropertyResourceDefinition.VALUE.validateAndSet(value, param.getModel());
            }
        }
        this.reloadRequiredStep(context);
        context.stepCompleted();
    }

    void process(ModelNode subModel, ModelNode operation) {
    }

    void reloadRequiredStep(OperationContext context) {
        if (context.getProcessType().isServer() && !context.isBooting()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.reloadRequired();
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

