/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.jboss.as.clustering.jgroups.JGroupsMessages;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;

public class RealmAuthorizationCallbackHandler
implements CallbackHandler {
    private final String mechanismName;
    private final SecurityRealm realm;
    private final String clusterRole;
    static final Collection<Principal> EMPTY_PRINCIPALS = Collections.emptySet();
    static final String SASL_OPT_REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    static final String SASL_OPT_ALT_PROTO_PROPERTY = "org.jboss.sasl.digest.alternative_protocols";
    static final String SASL_OPT_PRE_DIGESTED_PROPERTY = "org.jboss.sasl.digest.pre_digested";
    static final String DIGEST_MD5 = "DIGEST-MD5";
    static final String EXTERNAL = "EXTERNAL";
    static final String GSSAPI = "GSSAPI";
    static final String PLAIN = "PLAIN";

    public RealmAuthorizationCallbackHandler(SecurityRealm realm, String mechanismName, String clusterRole, Map<String, String> mechanismProperties) {
        this.realm = realm;
        this.mechanismName = mechanismName;
        this.clusterRole = clusterRole;
        this.tunePropsForMech(mechanismProperties);
    }

    private void tunePropsForMech(Map<String, String> mechanismProperties) {
        if (DIGEST_MD5.equals(this.mechanismName)) {
            if (!mechanismProperties.containsKey(SASL_OPT_REALM_PROPERTY)) {
                mechanismProperties.put(SASL_OPT_REALM_PROPERTY, this.realm.getName());
            }
            Map mechConfig = this.realm.getMechanismConfig(AuthMechanism.DIGEST);
            boolean plainTextDigest = true;
            if (mechConfig.containsKey("org.jboss.as.domain.management.digest.plain_text")) {
                plainTextDigest = Boolean.parseBoolean((String)mechConfig.get("org.jboss.as.domain.management.digest.plain_text"));
            }
            if (!plainTextDigest) {
                mechanismProperties.put(SASL_OPT_PRE_DIGESTED_PROPERTY, "true");
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        AuthorizingCallbackHandler cbh = this.getMechCallbackHandler();
        cbh.handle(callbacks);
    }

    private AuthorizingCallbackHandler getMechCallbackHandler() {
        if (PLAIN.equals(this.mechanismName)) {
            return new DelegatingRoleAwareAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN));
        }
        if (DIGEST_MD5.equals(this.mechanismName)) {
            return new DelegatingRoleAwareAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.DIGEST));
        }
        if (GSSAPI.equals(this.mechanismName)) {
            return new DelegatingRoleAwareAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN));
        }
        if (EXTERNAL.equals(this.mechanismName)) {
            return new DelegatingRoleAwareAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.CLIENT_CERT));
        }
        throw new IllegalArgumentException("Unsupported mech " + this.mechanismName);
    }

    SubjectUserInfo validateSubjectRole(SubjectUserInfo subjectUserInfo) {
        for (Principal principal : subjectUserInfo.getPrincipals()) {
            if (!this.clusterRole.equals(principal.getName())) continue;
            return subjectUserInfo;
        }
        throw JGroupsMessages.MESSAGES.unauthorizedNodeJoin(subjectUserInfo.getUserName());
    }

    public static <T extends Callback> T findCallbackHandler(Class<T> klass, Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!klass.isInstance(callbacks[i])) continue;
            return (T)callbacks[i];
        }
        return null;
    }

    class DelegatingRoleAwareAuthorizingCallbackHandler
    implements AuthorizingCallbackHandler {
        private final AuthorizingCallbackHandler delegate;

        DelegatingRoleAwareAuthorizingCallbackHandler(AuthorizingCallbackHandler acbh) {
            this.delegate = acbh;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            AuthorizeCallback acb = RealmAuthorizationCallbackHandler.findCallbackHandler(AuthorizeCallback.class, callbacks);
            if (acb != null) {
                String authenticationId = acb.getAuthenticationID();
                String authorizationId = acb.getAuthorizationID();
                acb.setAuthorized(authenticationId.equals(authorizationId));
                int realmSep = authorizationId.indexOf(64);
                RealmUser realmUser = realmSep < 0 ? new RealmUser(authorizationId) : new RealmUser(authorizationId.substring(realmSep + 1), authorizationId.substring(0, realmSep));
                ArrayList<Principal> principals = new ArrayList<Principal>();
                principals.add((Principal)realmUser);
                this.createSubjectUserInfo(principals);
            } else {
                this.delegate.handle(callbacks);
            }
        }

        public SubjectUserInfo createSubjectUserInfo(Collection<Principal> principals) throws IOException {
            SubjectUserInfo subjectUserInfo = this.delegate.createSubjectUserInfo(principals);
            return RealmAuthorizationCallbackHandler.this.validateSubjectRole(subjectUserInfo);
        }
    }
}

