/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.infinispan.server.jgroups.JChannelFactory;
import org.infinispan.server.jgroups.logging.JGroupsLogger;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.ProtocolConfiguration;
import org.infinispan.server.jgroups.spi.ProtocolStackConfiguration;
import org.infinispan.server.jgroups.spi.RelayConfiguration;
import org.infinispan.server.jgroups.spi.SaslConfiguration;
import org.infinispan.server.jgroups.spi.TransportConfiguration;
import org.jboss.modules.ModuleLoader;
import org.jgroups.Channel;
import org.jgroups.fork.ForkChannel;
import org.jgroups.stack.Configurator;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;

public class ForkChannelFactory
implements ChannelFactory {
    private final ChannelFactory parentFactory;
    private final List<ProtocolConfiguration> protocols;
    private final Channel channel;

    public ForkChannelFactory(Channel channel, ChannelFactory parentFactory, List<ProtocolConfiguration> protocols) {
        this.channel = channel;
        this.parentFactory = parentFactory;
        this.protocols = protocols;
    }

    public ForkChannelFactory(Channel channel, ChannelFactory parentFactory, ProtocolConfiguration ... protocols) {
        this(channel, parentFactory, Arrays.asList(protocols));
    }

    @Override
    public Channel createChannel(String id) throws Exception {
        JGroupsLogger.ROOT_LOGGER.debugf("Creating fork channel %s from channel %s", id, this.channel.getClusterName());
        String stackName = this.protocols.isEmpty() ? this.channel.getClusterName() : id;
        ForkProtocolStackConfiguration forkStack = new ForkProtocolStackConfiguration(stackName, this.parentFactory.getProtocolStackConfiguration(), this.protocols);
        List protocols = Configurator.createProtocols(JChannelFactory.createProtocols(forkStack, this.channel.getProtocolStack().getTransport().isMulticastCapable()), (ProtocolStack)new ProtocolStack());
        return new ForkChannel(this.channel, stackName, id, protocols.toArray(new Protocol[protocols.size()]));
    }

    @Override
    public ProtocolStackConfiguration getProtocolStackConfiguration() {
        List<ProtocolConfiguration> parentProtocols = this.parentFactory.getProtocolStackConfiguration().getProtocols();
        ArrayList<ProtocolConfiguration> protocols = new ArrayList<ProtocolConfiguration>(parentProtocols.size() + this.protocols.size());
        protocols.addAll(parentProtocols);
        protocols.addAll(this.protocols);
        return new ForkProtocolStackConfiguration(this.channel.getClusterName(), this.parentFactory.getProtocolStackConfiguration(), protocols);
    }

    @Override
    public boolean isUnknownForkResponse(ByteBuffer response) {
        return this.parentFactory.isUnknownForkResponse(response);
    }

    private static class ForkProtocolStackConfiguration
    implements ProtocolStackConfiguration {
        private final String name;
        private final List<ProtocolConfiguration> protocols;
        private final ProtocolStackConfiguration parentStack;

        ForkProtocolStackConfiguration(String name, ProtocolStackConfiguration parentStack, List<ProtocolConfiguration> protocols) {
            this.name = name;
            this.protocols = protocols;
            this.parentStack = parentStack;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<ProtocolConfiguration> getProtocols() {
            return this.protocols;
        }

        @Override
        public Map<String, String> getDefaultProperties(String protocol) {
            return this.parentStack.getDefaultProperties(protocol);
        }

        @Override
        public TransportConfiguration getTransport() {
            return this.parentStack.getTransport();
        }

        @Override
        public ModuleLoader getModuleLoader() {
            return this.parentStack.getModuleLoader();
        }

        @Override
        public String getNodeName() {
            return this.parentStack.getNodeName();
        }

        @Override
        public RelayConfiguration getRelay() {
            return this.parentStack.getRelay();
        }

        @Override
        public SaslConfiguration getSasl() {
            return this.parentStack.getSasl();
        }
    }
}

