/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.service.Builder;
import org.infinispan.server.jgroups.spi.RemoteSiteConfiguration;
import org.infinispan.server.jgroups.spi.service.ChannelServiceName;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.Channel;

public class RemoteSiteConfigurationBuilder
implements Builder<RemoteSiteConfiguration>,
Value<RemoteSiteConfiguration>,
RemoteSiteConfiguration {
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final String stackName;
    private final String siteName;
    private String channelName;

    public RemoteSiteConfigurationBuilder(String stackName, String siteName) {
        this.stackName = stackName;
        this.siteName = siteName;
    }

    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.stackName).append(new String[]{"relay", this.siteName});
    }

    public ServiceBuilder<RemoteSiteConfiguration> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ChannelServiceName.CHANNEL.getServiceName(this.channelName), Channel.class, this.channel).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public RemoteSiteConfiguration getValue() {
        return this;
    }

    public RemoteSiteConfigurationBuilder setChannel(String channelName) {
        this.channelName = channelName;
        return this;
    }

    @Override
    public String getName() {
        return this.siteName;
    }

    @Override
    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    @Override
    public String getClusterName() {
        return this.channelName;
    }
}

