/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.util.Collections;
import java.util.List;
import org.infinispan.server.commons.controller.ReloadRequiredAddStepHandler;
import org.infinispan.server.jgroups.subsystem.ExportNativeConfiguration;
import org.infinispan.server.jgroups.subsystem.JGroupsModel;
import org.infinispan.server.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.infinispan.server.jgroups.subsystem.PropertyResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.RelayResourceDefinition;
import org.infinispan.server.jgroups.subsystem.SaslResourceDefinition;
import org.infinispan.server.jgroups.subsystem.StackAddHandler;
import org.infinispan.server.jgroups.subsystem.StackRemoveHandler;
import org.infinispan.server.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.ObjectListAttributeDefinition;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class StackResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement WILDCARD_PATH = StackResourceDefinition.pathElement("*");
    private final boolean allowRuntimeOnlyRegistration;
    @Deprecated
    static final ObjectTypeAttributeDefinition TRANSPORT = ((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"transport", (AttributeDefinition[])new AttributeDefinition[]{ProtocolResourceDefinition.TYPE, TransportResourceDefinition.SHARED, ProtocolResourceDefinition.SOCKET_BINDING, TransportResourceDefinition.DIAGNOSTICS_SOCKET_BINDING, TransportResourceDefinition.DEFAULT_EXECUTOR, TransportResourceDefinition.OOB_EXECUTOR, TransportResourceDefinition.TIMER_EXECUTOR, TransportResourceDefinition.THREAD_FACTORY, TransportResourceDefinition.SITE, TransportResourceDefinition.RACK, TransportResourceDefinition.MACHINE, ProtocolResourceDefinition.PROPERTIES}).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setAllowNull(true).setSuffix(null).build();
    @Deprecated
    static final ObjectTypeAttributeDefinition PROTOCOL = ObjectTypeAttributeDefinition.Builder.of((String)"protocol", (AttributeDefinition[])new AttributeDefinition[]{ProtocolResourceDefinition.TYPE, ProtocolResourceDefinition.SOCKET_BINDING, ProtocolResourceDefinition.PROPERTIES}).setAllowNull(true).setSuffix("protocol").build();
    @Deprecated
    static final AttributeDefinition PROTOCOLS = ((ObjectListAttributeDefinition.Builder)ObjectListAttributeDefinition.Builder.of((String)"protocols", (ObjectTypeAttributeDefinition)PROTOCOL).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setAllowNull(true).build();

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"stack", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            ResourceTransformer transformer = new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    for (String name : resource.getChildrenNames(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        resource.getModel().get(PROTOCOLS.getName()).add(name);
                    }
                    context.addTransformedResource(PathAddress.EMPTY_ADDRESS, resource).processChildren(resource);
                }
            };
            builder.setCustomResourceTransformer(transformer);
        }
        if (JGroupsModel.VERSION_2_0_0.requiresTransformation(version)) {
            builder.rejectChildResource(RelayResourceDefinition.PATH);
        } else {
            RelayResourceDefinition.buildTransformation(version, builder);
        }
        SaslResourceDefinition.buildTransformation(version, builder);
        TransportResourceDefinition.buildTransformation(version, builder);
        ProtocolResourceDefinition.buildTransformation(version, builder);
    }

    public StackResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver("stack"), null, (OperationStepHandler)new StackRemoveHandler());
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        super.registerOperations(registration);
        SimpleOperationDefinition addOperation = new SimpleOperationDefinitionBuilder("add", this.getResourceDescriptionResolver()).addParameter((AttributeDefinition)TRANSPORT).addParameter(PROTOCOLS).setAttributeResolver((ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver("stack", "add")).build();
        StackAddHandler addHandler = new StackAddHandler(){

            protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                PathAddress address = context.getCurrentAddress();
                ModelNode transport = null;
                if (operation.hasDefined(TRANSPORT.getName())) {
                    transport = operation.remove(TRANSPORT.getName());
                }
                List protocols = Collections.emptyList();
                if (operation.hasDefined(PROTOCOLS.getName())) {
                    protocols = operation.remove(PROTOCOLS.getName()).asList();
                }
                if (transport != null) {
                    String type = ProtocolResourceDefinition.TYPE.resolveModelAttribute(context, transport).asString();
                    PathAddress transportAddress = address.append(new PathElement[]{TransportResourceDefinition.pathElement(type)});
                    ModelNode transportOperation = Util.createAddOperation((PathAddress)transportAddress);
                    for (AttributeDefinition attribute : TransportResourceDefinition.ATTRIBUTES) {
                        String name = attribute.getName();
                        if (!transport.hasDefined(name)) continue;
                        transportOperation.get(name).set(transport.get(name));
                    }
                    context.addStep(transportOperation, (OperationStepHandler)new ReloadRequiredAddStepHandler(TransportResourceDefinition.ATTRIBUTES), OperationContext.Stage.MODEL);
                    if (transport.hasDefined(ProtocolResourceDefinition.PROPERTIES.getName())) {
                        for (Property property : operation.get(ProtocolResourceDefinition.PROPERTIES.getName()).asPropertyList()) {
                            ModelNode propertyOperation = Util.createAddOperation((PathAddress)transportAddress.append(property.getName()));
                            propertyOperation.set(PropertyResourceDefinition.VALUE.getName()).set(property.getValue());
                            context.addStep(propertyOperation, (OperationStepHandler)new ReloadRequiredAddStepHandler(new AttributeDefinition[]{PropertyResourceDefinition.VALUE}), OperationContext.Stage.MODEL);
                        }
                    }
                }
                if (!protocols.isEmpty()) {
                    for (ModelNode protocol : protocols) {
                        String type = ProtocolResourceDefinition.TYPE.resolveModelAttribute(context, protocol).asString();
                        PathAddress protocolAddress = address.append(new PathElement[]{ProtocolResourceDefinition.pathElement(type)});
                        ModelNode protocolOperation = Util.createAddOperation((PathAddress)protocolAddress);
                        for (AttributeDefinition attribute : ProtocolResourceDefinition.ATTRIBUTES) {
                            String name = attribute.getName();
                            if (!protocol.hasDefined(name)) continue;
                            protocolOperation.get(name).set(protocol.get(name));
                        }
                        context.addStep(protocolOperation, (OperationStepHandler)new ReloadRequiredAddStepHandler(ProtocolResourceDefinition.ATTRIBUTES), OperationContext.Stage.MODEL);
                        if (!protocol.hasDefined(ProtocolResourceDefinition.PROPERTIES.getName())) continue;
                        for (Property property : operation.get(ProtocolResourceDefinition.PROPERTIES.getName()).asPropertyList()) {
                            ModelNode propertyOperation = Util.createAddOperation((PathAddress)protocolAddress.append(property.getName()));
                            propertyOperation.set(PropertyResourceDefinition.VALUE.getName()).set(property.getValue());
                            context.addStep(propertyOperation, (OperationStepHandler)new ReloadRequiredAddStepHandler(new AttributeDefinition[]{PropertyResourceDefinition.VALUE}), OperationContext.Stage.MODEL);
                        }
                    }
                }
            }
        };
        registration.registerOperationHandler((OperationDefinition)addOperation, (OperationStepHandler)addHandler);
        SimpleOperationDefinition legacyAddProtocolOperation = new SimpleOperationDefinitionBuilder("add-protocol", this.getResourceDescriptionResolver()).setParameters(new AttributeDefinition[]{ProtocolResourceDefinition.SOCKET_BINDING}).addParameter((AttributeDefinition)ProtocolResourceDefinition.TYPE).addParameter((AttributeDefinition)ProtocolResourceDefinition.PROPERTIES).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion()).build();
        OperationStepHandler legacyAddProtocolHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                PathAddress address = context.getCurrentAddress();
                String protocol = operation.require(ProtocolResourceDefinition.TYPE.getName()).asString();
                PathAddress protocolAddress = address.append(new PathElement[]{ProtocolResourceDefinition.pathElement(protocol)});
                ModelNode protocolOperation = Util.createAddOperation((PathAddress)protocolAddress);
                for (AttributeDefinition attribute : ProtocolResourceDefinition.ATTRIBUTES) {
                    String name = attribute.getName();
                    if (!operation.hasDefined(name)) continue;
                    protocolOperation.get(name).set(operation.get(name));
                }
                context.addStep(protocolOperation, (OperationStepHandler)new ReloadRequiredAddStepHandler(ProtocolResourceDefinition.ATTRIBUTES), OperationContext.Stage.MODEL);
                if (operation.hasDefined(ProtocolResourceDefinition.PROPERTIES.getName())) {
                    for (Property property : operation.get(ProtocolResourceDefinition.PROPERTIES.getName()).asPropertyList()) {
                        ModelNode addPropertyOperation = Util.createAddOperation((PathAddress)protocolAddress.append(new PathElement[]{PropertyResourceDefinition.pathElement(property.getName())}));
                        addPropertyOperation.get(PropertyResourceDefinition.VALUE.getName()).set(property.getValue());
                        context.addStep(addPropertyOperation, (OperationStepHandler)new ReloadRequiredAddStepHandler(new AttributeDefinition[]{PropertyResourceDefinition.VALUE}), OperationContext.Stage.MODEL);
                    }
                }
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyAddProtocolOperation, legacyAddProtocolHandler);
        SimpleOperationDefinition legacyRemoveProtocolOperation = new SimpleOperationDefinitionBuilder("remove-protocol", this.getResourceDescriptionResolver()).setParameters(new AttributeDefinition[]{ProtocolResourceDefinition.TYPE}).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion()).build();
        OperationStepHandler legacyRemoveProtocolHandler = new OperationStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                PathAddress address = context.getCurrentAddress();
                String protocol = operation.require(ProtocolResourceDefinition.TYPE.getName()).asString();
                PathAddress protocolAddress = address.append(new PathElement[]{ProtocolResourceDefinition.pathElement(protocol)});
                ModelNode removeOperation = Util.createRemoveOperation((PathAddress)protocolAddress);
                context.addStep(removeOperation, (OperationStepHandler)ReloadRequiredRemoveStepHandler.INSTANCE, context.getCurrentStage());
            }
        };
        registration.registerOperationHandler((OperationDefinition)legacyRemoveProtocolOperation, legacyRemoveProtocolHandler);
        if (this.allowRuntimeOnlyRegistration) {
            SimpleOperationDefinition exportOperation = new SimpleOperationDefinitionBuilder("export-native-configuration", this.getResourceDescriptionResolver()).setReplyType(ModelType.STRING).build();
            registration.registerOperationHandler((OperationDefinition)exportOperation, (OperationStepHandler)new ExportNativeConfiguration());
        }
    }

    public void registerChildren(ManagementResourceRegistration registration) {
        registration.registerSubModel((ResourceDefinition)new TransportResourceDefinition());
        registration.registerSubModel((ResourceDefinition)new ProtocolResourceDefinition());
        registration.registerSubModel((ResourceDefinition)new RelayResourceDefinition());
        registration.registerSubModel((ResourceDefinition)new SaslResourceDefinition());
    }
}

