/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.jgroups.subsystem.ForkAddHandler;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class ForkRemoveHandler
extends AbstractRemoveStepHandler {
    private final boolean allowRuntimeOnlyRegistration;

    ForkRemoveHandler(boolean allowRuntimeOnlyRegistration) {
        this.allowRuntimeOnlyRegistration = allowRuntimeOnlyRegistration;
    }

    protected void performRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        if (this.allowRuntimeOnlyRegistration && context.getRunningMode() == RunningMode.NORMAL) {
            Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
            for (Resource.ResourceEntry entry : resource.getChildren(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                context.removeResource(PathAddress.pathAddress((PathElement[])new PathElement[]{entry.getPathElement()}));
            }
            context.getResourceRegistrationForUpdate().unregisterOverrideModel(name);
        }
        super.performRemove(context, operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ForkAddHandler.removeRuntimeServices(context, operation, model);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ForkAddHandler.installRuntimeServices(context, operation, model);
    }
}

