/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    CHANNEL("channel"),
    CHANNELS("channels"),
    DEFAULT_THREAD_POOL("default-thread-pool"),
    FORK("fork"),
    INTERNAL_THREAD_POOL("internal-thread-pool"),
    OOB_THREAD_POOL("oob-thread-pool"),
    PROPERTY("property"),
    PROTOCOL("protocol"),
    RELAY("relay"),
    REMOTE_SITE("remote-site"),
    SASL("sasl"),
    STACK("stack"),
    STACKS("stacks"),
    THREAD_FACTORY("thread-factory"),
    TIMER_THREAD_POOL("timer-thread-pool"),
    TRANSPORT("transport");

    private final String name;
    private static final Map<String, Element> elements;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element element = elements.get(localName);
        return element != null ? element : UNKNOWN;
    }

    static {
        elements = new HashMap<String, Element>();
        for (Element element : Element.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            elements.put(name, element);
        }
    }
}

