/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.dmr.ModelNodes;
import org.infinispan.server.commons.naming.BinderServiceBuilder;
import org.infinispan.server.commons.service.AliasServiceBuilder;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.service.ChannelBuilder;
import org.infinispan.server.jgroups.spi.service.ChannelConnectorBuilder;
import org.infinispan.server.jgroups.spi.service.ChannelServiceName;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.infinispan.server.jgroups.subsystem.ForkChannelFactoryBuilder;
import org.infinispan.server.jgroups.subsystem.JGroupsBindingFactory;
import org.infinispan.server.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.StackAddHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Channel;

public class ForkAddHandler
extends AbstractAddStepHandler {
    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        ForkAddHandler.installRuntimeServices(context, operation, resource.getModel());
    }

    static void installRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        String name = address.getElement(address.size() - 1).getValue();
        String channel = address.getElement(address.size() - 2).getValue();
        ServiceTarget target = context.getServiceTarget();
        ForkChannelFactoryBuilder builder = new ForkChannelFactoryBuilder(name);
        if (model.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : model.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                String protocolName = property.getName();
                ModelNode protocol = property.getValue();
                ProtocolConfigurationBuilder protocolBuilder = builder.addProtocol(protocolName).setModule(ModelNodes.asModuleIdentifier((ModelNode)ProtocolResourceDefinition.MODULE.resolveModelAttribute(context, protocol))).setSocketBinding(ModelNodes.asString((ModelNode)ProtocolResourceDefinition.SOCKET_BINDING.resolveModelAttribute(context, protocol)));
                StackAddHandler.addProtocolProperties(context, protocol, protocolBuilder).build(target).install();
            }
        }
        builder.build(target).install();
        new AliasServiceBuilder(ChannelServiceName.FACTORY.getServiceName(name), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(channel), ChannelFactory.class).build(target).install();
        new ChannelBuilder(name).build(target).install();
        new ChannelConnectorBuilder(name).build(target).install();
        new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding(name), ChannelServiceName.CHANNEL.getServiceName(name), Channel.class).build(target).install();
    }

    static void removeRuntimeServices(OperationContext context, ModelNode operation, ModelNode model) {
        String name = context.getCurrentAddressValue();
        context.removeService(JGroupsBindingFactory.createChannelBinding(name).getBinderServiceName());
        for (ChannelServiceName factory : ChannelServiceName.values()) {
            context.removeService(factory.getServiceName(name));
        }
    }
}

