/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.infinispan.server.jgroups.subsystem.Attribute;
import org.infinispan.server.jgroups.subsystem.ChannelResourceDefinition;
import org.infinispan.server.jgroups.subsystem.Element;
import org.infinispan.server.jgroups.subsystem.ForkResourceDefinition;
import org.infinispan.server.jgroups.subsystem.JGroupsSchema;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.RelayResourceDefinition;
import org.infinispan.server.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.infinispan.server.jgroups.subsystem.SaslResourceDefinition;
import org.infinispan.server.jgroups.subsystem.StackResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public class JGroupsSubsystemXMLReader
implements XMLElementReader<List<ModelNode>> {
    private final JGroupsSchema schema;

    JGroupsSubsystemXMLReader(JGroupsSchema schema) {
        this.schema = schema;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> result) throws XMLStreamException {
        LinkedHashMap<PathAddress, ModelNode> operations = new LinkedHashMap<PathAddress, ModelNode>();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        if (!this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) {
            String defaultStack = JGroupsSubsystemXMLReader.require(reader, Attribute.DEFAULT_STACK);
            JGroupsSubsystemResourceDefinition.DEFAULT_STACK.parseAndSetParameter(defaultStack, operation, (XMLStreamReader)reader);
        }
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CHANNELS: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) {
                        this.parseChannels(reader, address, operations);
                        continue block5;
                    }
                }
                case STACKS: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) {
                        this.parseStacks(reader, address, operations);
                        continue block5;
                    }
                }
                case STACK: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) break;
                    this.parseStack(reader, address, operations);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        result.addAll(operations.values());
    }

    private void parseChannels(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT: {
                    JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CHANNEL: {
                    this.parseChannel(reader, address, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseChannel(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = JGroupsSubsystemXMLReader.require(reader, Attribute.NAME);
        PathAddress address = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block8;
                }
                case STACK: {
                    ChannelResourceDefinition.STACK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case MODULE: {
                    ChannelResourceDefinition.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FORK: {
                    this.parseFork(reader, address, operations);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseFork(XMLExtendedStreamReader reader, PathAddress channelAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = JGroupsSubsystemXMLReader.require(reader, Attribute.NAME);
        PathAddress address = channelAddress.append(new PathElement[]{ForkResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROTOCOL: {
                    this.parseProtocol(reader, address, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStacks(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case DEFAULT: {
                    JGroupsSubsystemResourceDefinition.DEFAULT_STACK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case STACK: {
                    this.parseStack(reader, address, operations);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseStack(XMLExtendedStreamReader reader, PathAddress subsystemAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String name = JGroupsSubsystemXMLReader.require(reader, Attribute.NAME);
        PathAddress address = subsystemAddress.append(new PathElement[]{StackResourceDefinition.pathElement(name)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        boolean hasSasl = false;
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case TRANSPORT: {
                    this.parseTransport(reader, address, operations);
                    continue block6;
                }
                case PROTOCOL: {
                    this.parseProtocol(reader, address, operations);
                    continue block6;
                }
                case RELAY: {
                    if (this.schema.since(JGroupsSchema.VERSION_2_0) || this.schema.since(JGroupsSchema.INFINISPAN_SERVER_JGROUPS_7_0)) {
                        this.parseRelay(reader, address, operations);
                        continue block6;
                    }
                }
                case SASL: {
                    if (!this.schema.since(JGroupsSchema.INFINISPAN_SERVER_JGROUPS_7_0)) continue block6;
                    if (!hasSasl) {
                        this.parseSasl(reader, address, operations);
                        hasSasl = true;
                        continue block6;
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String type = JGroupsSubsystemXMLReader.require(reader, Attribute.TYPE);
        PathAddress address = stackAddress.append(new PathElement[]{TransportResourceDefinition.pathElement(type)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SHARED: {
                    TransportResourceDefinition.SHARED.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case DIAGNOSTICS_SOCKET_BINDING: {
                    TransportResourceDefinition.DIAGNOSTICS_SOCKET_BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case DEFAULT_EXECUTOR: {
                    TransportResourceDefinition.DEFAULT_EXECUTOR.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case OOB_EXECUTOR: {
                    if (this.schema.since(JGroupsSchema.INFINISPAN_SERVER_JGROUPS_9_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ControllerLogger.DEPRECATED_LOGGER.warnf("OOB thread pool settings are ignored.", new Object[0]);
                    continue block11;
                }
                case TIMER_EXECUTOR: {
                    if (this.schema.since(JGroupsSchema.INFINISPAN_SERVER_JGROUPS_9_0)) {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                    ControllerLogger.DEPRECATED_LOGGER.warnf("Timer thread pool settings are ignored.", new Object[0]);
                    continue block11;
                }
                case THREAD_FACTORY: {
                    TransportResourceDefinition.THREAD_FACTORY.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block11;
                }
                case SITE: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_7_0)) {
                        TransportResourceDefinition.SITE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block11;
                    }
                }
                case RACK: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_7_0)) {
                        TransportResourceDefinition.RACK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block11;
                    }
                }
                case MACHINE: {
                    if (this.schema.since(JGroupsSchema.VERSION_1_1, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_7_0)) {
                        TransportResourceDefinition.MACHINE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block11;
                    }
                }
                default: {
                    this.parseProtocolAttribute(reader, i, operation);
                }
            }
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseProtocolElement(reader, address, operations);
        }
    }

    private void parseProtocol(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String type = JGroupsSubsystemXMLReader.require(reader, Attribute.TYPE);
        PathAddress address = stackAddress.append(new PathElement[]{ProtocolResourceDefinition.pathElement(type)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            this.parseProtocolAttribute(reader, i, operation);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            this.parseProtocolElement(reader, address, operations);
        }
    }

    private void parseProtocolAttribute(XMLExtendedStreamReader reader, int index, ModelNode operation) throws XMLStreamException {
        String value = reader.getAttributeValue(index);
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(index));
        switch (attribute) {
            case TYPE: {
                break;
            }
            case SOCKET_BINDING: {
                ProtocolResourceDefinition.SOCKET_BINDING.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                break;
            }
            case MODULE: {
                if (this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) {
                    ProtocolResourceDefinition.MODULE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    break;
                }
            }
            default: {
                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)index);
            }
        }
    }

    private void parseProtocolElement(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case PROPERTY: {
                this.parseProperty(reader, address, operations);
                break;
            }
            case DEFAULT_THREAD_POOL: {
                this.parseThreadPool(ThreadPoolResourceDefinition.DEFAULT, reader, address, operations);
                break;
            }
            case INTERNAL_THREAD_POOL: {
                if (this.schema.since(JGroupsSchema.INFINISPAN_SERVER_JGROUPS_9_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                ControllerLogger.DEPRECATED_LOGGER.warnf("Internal thread pool settings are ignored.", new Object[0]);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                break;
            }
            case OOB_THREAD_POOL: {
                if (this.schema.since(JGroupsSchema.INFINISPAN_SERVER_JGROUPS_9_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                ControllerLogger.DEPRECATED_LOGGER.warnf("OOB thread pool settings are ignored.", new Object[0]);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                break;
            }
            case TIMER_THREAD_POOL: {
                if (this.schema.since(JGroupsSchema.INFINISPAN_SERVER_JGROUPS_9_0)) {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                ControllerLogger.DEPRECATED_LOGGER.warnf("Timer thread pool settings are ignored.", new Object[0]);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void parseProperty(XMLExtendedStreamReader reader, PathAddress address, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        ModelNode operation = operations.get(address);
        String name = JGroupsSubsystemXMLReader.require(reader, Attribute.NAME);
        ProtocolResourceDefinition.PROPERTIES.parseAndAddParameterElement(name, reader.getElementText(), operation, reader);
    }

    private void parseThreadPool(ThreadPoolResourceDefinition pool, XMLExtendedStreamReader reader, PathAddress parentAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = parentAddress.append(new PathElement[]{pool.getPathElement()});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MIN_THREADS: {
                    pool.getMinThreads().parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case MAX_THREADS: {
                    pool.getMaxThreads().parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case QUEUE_LENGTH: {
                    pool.getQueueLength().parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                case KEEPALIVE_TIME: {
                    pool.getKeepaliveTime().parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseRelay(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = stackAddress.append(new PathElement[]{RelayResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case SITE: {
                    RelayResourceDefinition.SITE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!operation.hasDefined(RelayResourceDefinition.SITE.getName())) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.SITE));
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case REMOTE_SITE: {
                    this.parseRemoteSite(reader, address, operations);
                    continue block8;
                }
                case PROPERTY: {
                    this.parseProperty(reader, address, operations);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void parseRemoteSite(XMLExtendedStreamReader reader, PathAddress relayAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        String site = JGroupsSubsystemXMLReader.require(reader, Attribute.NAME);
        PathAddress address = relayAddress.append(new PathElement[]{RemoteSiteResourceDefinition.pathElement(site)});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        String cluster = null;
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    continue block6;
                }
                case STACK: {
                    if (!this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) {
                        RemoteSiteResourceDefinition.STACK.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        continue block6;
                    }
                }
                case CLUSTER: {
                    if (!this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) {
                        cluster = value;
                        continue block6;
                    }
                }
                case CHANNEL: {
                    if (this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) {
                        RemoteSiteResourceDefinition.CHANNEL.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
                        PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement(value)});
                        ModelNode channelOperation = operations.get(channelAddress);
                        if (channelOperation == null) continue block6;
                        String stack = channelOperation.hasDefined(ChannelResourceDefinition.STACK.getName()) ? channelOperation.get(ChannelResourceDefinition.STACK.getName()).asString() : operations.get(subsystemAddress).get(JGroupsSubsystemResourceDefinition.DEFAULT_STACK.getName()).asString();
                        RemoteSiteResourceDefinition.STACK.parseAndSetParameter(stack, operation, (XMLStreamReader)reader);
                        continue block6;
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (this.schema.since(JGroupsSchema.VERSION_3_0, JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0)) {
            if (!operation.hasDefined(RemoteSiteResourceDefinition.CHANNEL.getName())) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.CHANNEL));
            }
        } else {
            if (!operation.hasDefined(RemoteSiteResourceDefinition.STACK.getName())) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.STACK));
            }
            String channel = cluster != null ? cluster : site;
            RemoteSiteResourceDefinition.CHANNEL.parseAndSetParameter(channel, operation, (XMLStreamReader)reader);
            PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
            PathAddress channelAddress = subsystemAddress.append(new PathElement[]{ChannelResourceDefinition.pathElement(channel)});
            ModelNode channelOperation = Util.createAddOperation((PathAddress)channelAddress);
            String stack = operation.get(RemoteSiteResourceDefinition.STACK.getName()).asString();
            ChannelResourceDefinition.STACK.parseAndSetParameter(stack, channelOperation, (XMLStreamReader)reader);
            operations.put(channelAddress, channelOperation);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private static String require(XMLExtendedStreamReader reader, Attribute attribute) throws XMLStreamException {
        String value = reader.getAttributeValue(null, attribute.getLocalName());
        if (value == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, (String[])new String[]{attribute.getLocalName()});
        }
        return value;
    }

    private void parseSasl(XMLExtendedStreamReader reader, PathAddress stackAddress, Map<PathAddress, ModelNode> operations) throws XMLStreamException {
        PathAddress address = stackAddress.append(new PathElement[]{SaslResourceDefinition.PATH});
        ModelNode operation = Util.createAddOperation((PathAddress)address);
        operations.put(address, operation);
        EnumSet<Attribute> required = EnumSet.of(Attribute.MECH, Attribute.SECURITY_REALM);
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case CLUSTER_ROLE: {
                    SaslResourceDefinition.CLUSTER_ROLE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case MECH: {
                    SaslResourceDefinition.MECH.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                case SECURITY_REALM: {
                    SaslResourceDefinition.SECURITY_REALM.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    this.parseProperty(reader, address, operations);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

