/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.infinispan.server.jgroups.subsystem.Attribute;
import org.infinispan.server.jgroups.subsystem.ChannelResourceDefinition;
import org.infinispan.server.jgroups.subsystem.Element;
import org.infinispan.server.jgroups.subsystem.ForkResourceDefinition;
import org.infinispan.server.jgroups.subsystem.JGroupsSchema;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.RelayResourceDefinition;
import org.infinispan.server.jgroups.subsystem.RemoteSiteResourceDefinition;
import org.infinispan.server.jgroups.subsystem.SaslResourceDefinition;
import org.infinispan.server.jgroups.subsystem.StackResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class JGroupsSubsystemXMLWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(JGroupsSchema.CURRENT.getNamespaceUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            if (model.hasDefined(ChannelResourceDefinition.WILDCARD_PATH.getKey())) {
                writer.writeStartElement(Element.CHANNELS.getLocalName());
                JGroupsSubsystemResourceDefinition.DEFAULT_CHANNEL.marshallAsAttribute(model, (XMLStreamWriter)writer);
                for (Property property : model.get(ChannelResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    writer.writeStartElement(Element.CHANNEL.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    ModelNode channel = property.getValue();
                    JGroupsSubsystemXMLWriter.writeAttribute(writer, channel, (AttributeDefinition)ChannelResourceDefinition.STACK);
                    JGroupsSubsystemXMLWriter.writeAttribute(writer, channel, (AttributeDefinition)ChannelResourceDefinition.MODULE);
                    if (channel.hasDefined(ForkResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property forkProperty : channel.get(ForkResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            writer.writeStartElement(Element.FORK.getLocalName());
                            writer.writeAttribute(Attribute.NAME.getLocalName(), forkProperty.getName());
                            ModelNode fork = forkProperty.getValue();
                            if (fork.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                                for (Property protocol : fork.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                                    JGroupsSubsystemXMLWriter.writeProtocol(writer, protocol);
                                }
                            }
                            writer.writeEndElement();
                        }
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            if (model.hasDefined(StackResourceDefinition.WILDCARD_PATH.getKey())) {
                writer.writeStartElement(Element.STACKS.getLocalName());
                JGroupsSubsystemXMLWriter.writeAttribute(writer, model, (AttributeDefinition)JGroupsSubsystemResourceDefinition.DEFAULT_STACK);
                for (Property property : model.get(StackResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                    writer.writeStartElement(Element.STACK.getLocalName());
                    writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                    ModelNode stack = property.getValue();
                    if (stack.hasDefined(TransportResourceDefinition.WILDCARD_PATH.getKey())) {
                        JGroupsSubsystemXMLWriter.writeTransport(writer, stack.get(TransportResourceDefinition.WILDCARD_PATH.getKey()).asProperty());
                    }
                    if (stack.hasDefined(ProtocolResourceDefinition.WILDCARD_PATH.getKey())) {
                        for (Property protocol : stack.get(ProtocolResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                            JGroupsSubsystemXMLWriter.writeProtocol(writer, protocol);
                        }
                    }
                    if (stack.get(RelayResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
                        JGroupsSubsystemXMLWriter.writeRelay(writer, stack.get(RelayResourceDefinition.PATH.getKeyValuePair()));
                    }
                    if (stack.get(SaslResourceDefinition.PATH.getKeyValuePair()).isDefined()) {
                        JGroupsSubsystemXMLWriter.writeSasl(writer, stack.get(SaslResourceDefinition.PATH.getKeyValuePair()));
                    }
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeTransport(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(Element.TRANSPORT.getLocalName());
        JGroupsSubsystemXMLWriter.writeProtocolAttributes(writer, property);
        ModelNode transport = property.getValue();
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.SHARED);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.DIAGNOSTICS_SOCKET_BINDING);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.DEFAULT_EXECUTOR);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.OOB_EXECUTOR);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.TIMER_EXECUTOR);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.THREAD_FACTORY);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.MACHINE);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.RACK);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, transport, (AttributeDefinition)TransportResourceDefinition.SITE);
        JGroupsSubsystemXMLWriter.writeElement(writer, transport, (AttributeDefinition)ProtocolResourceDefinition.PROPERTIES);
        if (transport.hasDefined(ThreadPoolResourceDefinition.WILDCARD_PATH.getKey())) {
            JGroupsSubsystemXMLWriter.writeThreadPoolElements(Element.DEFAULT_THREAD_POOL, ThreadPoolResourceDefinition.DEFAULT, writer, transport);
            if (transport.hasDefined(ThreadPoolResourceDefinition.OOB.name())) {
                JGroupsSubsystemXMLWriter.writeThreadPoolElements(Element.OOB_THREAD_POOL, ThreadPoolResourceDefinition.DEFAULT, writer, transport);
            }
            if (transport.hasDefined(ThreadPoolResourceDefinition.INTERNAL.name())) {
                JGroupsSubsystemXMLWriter.writeThreadPoolElements(Element.INTERNAL_THREAD_POOL, ThreadPoolResourceDefinition.DEFAULT, writer, transport);
            }
            if (transport.hasDefined(ThreadPoolResourceDefinition.TIMER.name())) {
                JGroupsSubsystemXMLWriter.writeThreadPoolElements(Element.TIMER_THREAD_POOL, ThreadPoolResourceDefinition.DEFAULT, writer, transport);
            }
        }
        writer.writeEndElement();
    }

    private static void writeProtocol(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeStartElement(Element.PROTOCOL.getLocalName());
        JGroupsSubsystemXMLWriter.writeProtocolAttributes(writer, property);
        JGroupsSubsystemXMLWriter.writeElement(writer, property.getValue(), (AttributeDefinition)ProtocolResourceDefinition.PROPERTIES);
        writer.writeEndElement();
    }

    private static void writeProtocolAttributes(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeAttribute(Attribute.TYPE.getLocalName(), property.getName());
        ModelNode protocol = property.getValue();
        JGroupsSubsystemXMLWriter.writeAttribute(writer, protocol, (AttributeDefinition)ProtocolResourceDefinition.SOCKET_BINDING);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, protocol, (AttributeDefinition)ProtocolResourceDefinition.MODULE);
    }

    private static void writeThreadPoolElements(Element element, ThreadPoolResourceDefinition pool, XMLExtendedStreamWriter writer, ModelNode transport) throws XMLStreamException {
        if (transport.get(pool.getPathElement().getKey()).hasDefined(pool.getPathElement().getValue())) {
            ModelNode threadPool = transport.get(pool.getPathElement().getKeyValuePair());
            writer.writeStartElement(element.getLocalName());
            JGroupsSubsystemXMLWriter.writeAttribute(writer, threadPool, (AttributeDefinition)pool.getMinThreads());
            JGroupsSubsystemXMLWriter.writeAttribute(writer, threadPool, (AttributeDefinition)pool.getMaxThreads());
            JGroupsSubsystemXMLWriter.writeAttribute(writer, threadPool, (AttributeDefinition)pool.getQueueLength());
            JGroupsSubsystemXMLWriter.writeAttribute(writer, threadPool, (AttributeDefinition)pool.getKeepaliveTime());
            writer.writeEndElement();
        }
    }

    private static void writeRelay(XMLExtendedStreamWriter writer, ModelNode relay) throws XMLStreamException {
        writer.writeStartElement(Element.RELAY.getLocalName());
        RelayResourceDefinition.SITE.marshallAsAttribute(relay, (XMLStreamWriter)writer);
        if (relay.hasDefined(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey())) {
            for (Property property : relay.get(RemoteSiteResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                writer.writeStartElement(Element.REMOTE_SITE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode remoteSite = property.getValue();
                JGroupsSubsystemXMLWriter.writeAttribute(writer, remoteSite, (AttributeDefinition)RemoteSiteResourceDefinition.CHANNEL);
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private static void writeSasl(XMLExtendedStreamWriter writer, ModelNode sasl) throws XMLStreamException {
        writer.writeStartElement(Element.SASL.getLocalName());
        JGroupsSubsystemXMLWriter.writeAttribute(writer, sasl, (AttributeDefinition)SaslResourceDefinition.CLUSTER_ROLE);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, sasl, (AttributeDefinition)SaslResourceDefinition.MECH);
        JGroupsSubsystemXMLWriter.writeAttribute(writer, sasl, (AttributeDefinition)SaslResourceDefinition.SECURITY_REALM);
        JGroupsSubsystemXMLWriter.writeElement(writer, sasl, (AttributeDefinition)ProtocolResourceDefinition.PROPERTIES);
        writer.writeEndElement();
    }

    private static void writeAttribute(XMLExtendedStreamWriter writer, ModelNode model, AttributeDefinition attribute) throws XMLStreamException {
        attribute.getAttributeMarshaller().marshallAsAttribute(attribute, model, true, (XMLStreamWriter)writer);
    }

    private static void writeElement(XMLExtendedStreamWriter writer, ModelNode model, AttributeDefinition attribute) throws XMLStreamException {
        attribute.getAttributeMarshaller().marshallAsElement(attribute, model, true, (XMLStreamWriter)writer);
    }
}

