/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import org.infinispan.server.commons.controller.Operations;
import org.infinispan.server.jgroups.subsystem.JGroupsExtension;
import org.infinispan.server.jgroups.subsystem.JGroupsSchema;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.infinispan.server.jgroups.subsystem.PropertyResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.StackResourceDefinition;
import org.infinispan.server.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;

public class OperationTestCaseBase
extends AbstractSubsystemTest {
    static final String SUBSYSTEM_XML_FILE = JGroupsSchema.CURRENT.format("subsystem-%s-%d_%d.xml").replaceAll(":", "_");

    public OperationTestCaseBase() {
        super("datagrid-jgroups", (Extension)new JGroupsExtension());
    }

    protected static ModelNode getSubsystemReadOperation(String name) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress(), (String)name);
    }

    protected static ModelNode getSubsystemWriteOperation(String name, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress(), (String)name, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getProtocolStackAddOperation(String stackName) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolStackAddress(stackName));
    }

    protected static ModelNode getProtocolStackAddOperationWithParameters(String stackName) {
        ModelNode[] operations = new ModelNode[]{OperationTestCaseBase.getProtocolStackAddOperation(stackName), OperationTestCaseBase.getTransportAddOperation(stackName, "UDP"), OperationTestCaseBase.getProtocolAddOperation(stackName, "MPING"), OperationTestCaseBase.getProtocolAddOperation(stackName, "pbcast.FLUSH")};
        return Operations.createCompositeOperation((ModelNode[])operations);
    }

    protected static ModelNode getProtocolStackRemoveOperation(String stackName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolStackAddress(stackName));
    }

    protected static ModelNode getTransportAddOperation(String stackName, String protocol) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, protocol));
    }

    protected static ModelNode getTransportAddOperationWithProperties(String stackName, String type) {
        ModelNode[] operations = new ModelNode[]{OperationTestCaseBase.getTransportAddOperation(stackName, type), OperationTestCaseBase.getProtocolPropertyAddOperation(stackName, type, "A", "a"), OperationTestCaseBase.getProtocolPropertyAddOperation(stackName, type, "B", "b")};
        return Operations.createCompositeOperation((ModelNode[])operations);
    }

    protected static ModelNode getTransportRemoveOperation(String stackName, String type) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type));
    }

    protected static ModelNode getTransportReadOperation(String stackName, String type, String name) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)name);
    }

    protected static ModelNode getTransportWriteOperation(String stackName, String type, String name, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)name, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getTransportPropertyAddOperation(String stackName, String type, String propertyName, String propertyValue) {
        ModelNode operation = Util.createAddOperation((PathAddress)OperationTestCaseBase.getTransportPropertyAddress(stackName, type, propertyName));
        operation.get(PropertyResourceDefinition.VALUE.getName()).set(propertyValue);
        return operation;
    }

    protected static ModelNode getTransportPropertyRemoveOperation(String stackName, String type, String propertyName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getTransportPropertyAddress(stackName, type, propertyName));
    }

    protected static ModelNode getTransportPropertyReadOperation(String stackName, String type, String propertyName) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getTransportPropertyAddress(stackName, type, propertyName), (String)PropertyResourceDefinition.VALUE.getName());
    }

    protected static ModelNode getTransportPropertyWriteOperation(String stackName, String type, String propertyName, String propertyValue) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getTransportPropertyAddress(stackName, type, propertyName), (String)PropertyResourceDefinition.VALUE.getName(), (ModelNode)new ModelNode(propertyValue));
    }

    protected static ModelNode getTransportGetPropertyOperation(String stackName, String type, String propertyName) {
        return Operations.createMapGetOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getTransportPutPropertyOperation(String stackName, String type, String propertyName, String propertyValue) {
        return Operations.createMapPutOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getTransportRemovePropertyOperation(String stackName, String type, String propertyName) {
        return Operations.createMapRemoveOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getProtocolAddOperation(String stackName, String type) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, type));
    }

    protected static ModelNode getProtocolAddOperationWithProperties(String stackName, String type) {
        ModelNode[] operations = new ModelNode[]{OperationTestCaseBase.getProtocolAddOperation(stackName, type), OperationTestCaseBase.getProtocolPropertyAddOperation(stackName, type, "A", "a"), OperationTestCaseBase.getProtocolPropertyAddOperation(stackName, type, "B", "b")};
        return Operations.createCompositeOperation((ModelNode[])operations);
    }

    protected static ModelNode getProtocolReadOperation(String stackName, String protocolName, String name) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)name);
    }

    protected static ModelNode getProtocolWriteOperation(String stackName, String protocolName, String name, String value) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)name, (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getProtocolPropertyAddOperation(String stackName, String protocolName, String propertyName, String propertyValue) {
        ModelNode operation = Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolPropertyAddress(stackName, protocolName, propertyName));
        operation.get(PropertyResourceDefinition.VALUE.getName()).set(propertyValue);
        return operation;
    }

    protected static ModelNode getProtocolPropertyRemoveOperation(String stackName, String protocolName, String propertyName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolPropertyAddress(stackName, protocolName, propertyName));
    }

    protected static ModelNode getProtocolPropertyReadOperation(String stackName, String protocolName, String propertyName) {
        return Operations.createReadAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolPropertyAddress(stackName, protocolName, propertyName), (String)PropertyResourceDefinition.VALUE.getName());
    }

    protected static ModelNode getProtocolPropertyWriteOperation(String stackName, String protocolName, String propertyName, String propertyValue) {
        return Operations.createWriteAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolPropertyAddress(stackName, protocolName, propertyName), (String)PropertyResourceDefinition.VALUE.getName(), (ModelNode)new ModelNode(propertyValue));
    }

    protected static ModelNode getProtocolGetPropertyOperation(String stackName, String protocolName, String propertyName) {
        return Operations.createMapGetOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getProtocolPutPropertyOperation(String stackName, String protocolName, String propertyName, String propertyValue) {
        return Operations.createMapPutOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getProtocolRemovePropertyOperation(String stackName, String protocolName, String propertyName) {
        return Operations.createMapRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getProtocolRemoveOperation(String stackName, String type) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, type));
    }

    protected static PathAddress getSubsystemAddress() {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
    }

    protected static PathAddress getProtocolStackAddress(String stackName) {
        return OperationTestCaseBase.getSubsystemAddress().append(new PathElement[]{StackResourceDefinition.pathElement((String)stackName)});
    }

    protected static PathAddress getTransportAddress(String stackName, String type) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{TransportResourceDefinition.pathElement((String)type)});
    }

    protected static PathAddress getTransportPropertyAddress(String stackName, String type, String propertyName) {
        return OperationTestCaseBase.getTransportAddress(stackName, type).append(new PathElement[]{PropertyResourceDefinition.pathElement((String)propertyName)});
    }

    protected static PathAddress getProtocolAddress(String stackName, String type) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)type)});
    }

    protected static PathAddress getProtocolPropertyAddress(String stackName, String type, String propertyName) {
        return OperationTestCaseBase.getProtocolAddress(stackName, type).append(new PathElement[]{PropertyResourceDefinition.pathElement((String)propertyName)});
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource(SUBSYSTEM_XML_FILE);
    }

    protected KernelServices buildKernelServices() throws XMLStreamException, IOException, Exception {
        return this.createKernelServicesBuilder(AdditionalInitialization.MANAGEMENT).setSubsystemXml(this.getSubsystemXml()).build();
    }
}

