/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import org.infinispan.server.commons.controller.Operations;
import org.infinispan.server.jgroups.subsystem.JGroupsModel;
import org.infinispan.server.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PropertyResourceDefinition
extends SimpleResourceDefinition {
    static final PathElement WILDCARD_PATH = PropertyResourceDefinition.pathElement("*");
    static final SimpleAttributeDefinition VALUE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("value", ModelType.STRING, false).setAllowExpression(true)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_ALL_SERVICES})).build();

    static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"property", (String)name);
    }

    PropertyResourceDefinition() {
        super(WILDCARD_PATH, (ResourceDescriptionResolver)new JGroupsResourceDescriptionResolver("property"));
        this.setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion());
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        OperationStepHandler readHandler = (context, operation) -> {
            PathAddress address = context.getCurrentAddress().getParent();
            String key = context.getCurrentAddressValue();
            ModelNode getOperation = Operations.createMapGetOperation((PathAddress)address, (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)key);
            context.addStep(getOperation, MapOperations.MAP_GET_HANDLER, context.getCurrentStage());
        };
        OperationStepHandler writeHandler = (context, operation) -> {
            PathAddress address = context.getCurrentAddress().getParent();
            String key = context.getCurrentAddressValue();
            String value = Operations.getAttributeValue((ModelNode)operation).asString();
            ModelNode putOperation = Operations.createMapPutOperation((PathAddress)address, (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)key, (String)value);
            context.addStep(putOperation, MapOperations.MAP_PUT_HANDLER, context.getCurrentStage());
        };
        registration.registerReadWriteAttribute((AttributeDefinition)VALUE, readHandler, writeHandler);
    }

    public void registerOperations(ManagementResourceRegistration registration) {
        AbstractAddStepHandler addHandler = new AbstractAddStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                this.createResource(context);
                String name = context.getCurrentAddressValue();
                String value = operation.get(VALUE.getName()).asString();
                PathAddress storeAddress = context.getCurrentAddress().getParent();
                ModelNode putOperation = Operations.createMapPutOperation((PathAddress)storeAddress, (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)name, (String)value);
                context.addStep(putOperation, MapOperations.MAP_PUT_HANDLER, context.getCurrentStage());
            }
        };
        this.registerAddOperation(registration, addHandler, new OperationEntry.Flag[0]);
        AbstractRemoveStepHandler removeHandler = new AbstractRemoveStepHandler(){

            public void execute(OperationContext context, ModelNode operation) {
                context.removeResource(PathAddress.EMPTY_ADDRESS);
                String name = context.getCurrentAddressValue();
                PathAddress storeAddress = context.getCurrentAddress().getParent();
                ModelNode putOperation = Operations.createMapRemoveOperation((PathAddress)storeAddress, (String)ProtocolResourceDefinition.PROPERTIES.getName(), (String)name);
                context.addStep(putOperation, MapOperations.MAP_REMOVE_HANDLER, context.getCurrentStage());
            }
        };
        this.registerRemoveOperation(registration, removeHandler, new OperationEntry.Flag[0]);
    }
}

