/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.infinispan.server.commons.controller.Operations;
import org.infinispan.server.commons.subsystem.ClusteringSubsystemTest;
import org.infinispan.server.jgroups.subsystem.ChannelResourceDefinition;
import org.infinispan.server.jgroups.subsystem.JGroupsExtension;
import org.infinispan.server.jgroups.subsystem.JGroupsSchema;
import org.infinispan.server.jgroups.subsystem.JGroupsSubsystemResourceDefinition;
import org.infinispan.server.jgroups.subsystem.ProtocolResourceDefinition;
import org.infinispan.server.jgroups.subsystem.StackResourceDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.as.subsystem.test.ModelDescriptionValidator;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SubsystemParsingTestCase
extends ClusteringSubsystemTest {
    private final int expectedOperationCount;
    private final String xsdPath;
    private final String[] templates;

    public SubsystemParsingTestCase(JGroupsSchema schema, int expectedOperationCount, String xsdPath, String[] templates) {
        super("datagrid-jgroups", (Extension)new JGroupsExtension(), schema.format("subsystem-%s-%d_%d.xml").replaceAll(":", "_"));
        this.expectedOperationCount = expectedOperationCount;
        this.xsdPath = xsdPath;
        this.templates = templates;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{JGroupsSchema.INFINISPAN_SERVER_JGROUPS_7_0, 25, null, null}, {JGroupsSchema.INFINISPAN_SERVER_JGROUPS_8_0, 27, null, null}, {JGroupsSchema.INFINISPAN_SERVER_JGROUPS_9_0, 27, null, null}, {JGroupsSchema.INFINISPAN_SERVER_JGROUPS_9_2, 27, null, null}, {JGroupsSchema.INFINISPAN_SERVER_JGROUPS_9_3, 27, "schema/jboss-infinispan-jgroups_9_3.xsd", new String[]{"/subsystem-templates/infinispan-jgroups.xml", "/subsystem-templates/cloud-jgroups.xml"}}};
        return Arrays.asList(data);
    }

    protected String getSubsystemXsdPath() throws Exception {
        return this.xsdPath;
    }

    protected String[] getSubsystemTemplatePaths() throws IOException {
        return this.templates;
    }

    public void testSchemaOfSubsystemTemplates() throws Exception {
    }

    private KernelServices buildKernelServices() throws Exception {
        return this.buildKernelServices(this.getSubsystemXml());
    }

    private KernelServices buildKernelServices(String xml) throws Exception {
        return this.createKernelServicesBuilder(xml).build();
    }

    private KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder(AdditionalInitialization.MANAGEMENT);
    }

    private KernelServicesBuilder createKernelServicesBuilder(String xml) throws XMLStreamException {
        return this.createKernelServicesBuilder().setSubsystemXml(xml);
    }

    protected ModelDescriptionValidator.ValidationConfiguration getModelValidationConfiguration() {
        return new ModelDescriptionValidator.ValidationConfiguration();
    }

    protected Set<PathAddress> getIgnoredChildResourcesForRemovalTest() {
        String[] protocols = new String[]{"UDP", "TCP", "MPING", "MERGE2", "FD_SOCK", "FD", "VERIFY_SUSPECT", "BARRIER", "pbcast.NAKACK", "pbcast.NAKACK2", "UNICAST2", "pbcast.STABLE", "pbcast.GMS", "UFC", "MFC", "FRAG3", "pbcast.STATE_TRANSFER", "pbcast.FLUSH", "RSVP", "relay.RELAY2"};
        HashSet<PathAddress> addresses = new HashSet<PathAddress>();
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        for (String protocol : protocols) {
            addresses.add(address.append(new PathElement[]{StackResourceDefinition.pathElement((String)"maximal")}).append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)protocol)}));
            addresses.add(address.append(new PathElement[]{ChannelResourceDefinition.pathElement((String)"bridge")}).append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)protocol)}));
            addresses.add(address.append(new PathElement[]{ChannelResourceDefinition.pathElement((String)"ee")}).append(new PathElement[]{ProtocolResourceDefinition.pathElement((String)protocol)}));
        }
        return addresses;
    }

    @Test
    public void testParseSubsystem() throws Exception {
        List operations = super.parse(this.getSubsystemXml());
        Assert.assertEquals((long)this.expectedOperationCount, (long)operations.size());
    }

    @Test
    public void testParseAndMarshalModel() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode modelA = services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        ModelNode modelB = this.buildKernelServices(marshalled).readWholeModel();
        super.compare(modelA, modelB);
    }

    @Test
    public void testDescribeHandler() throws Exception {
        KernelServices servicesA = this.buildKernelServices();
        ModelNode modelA = servicesA.readWholeModel();
        ModelNode operation = Operations.createDescribeOperation((PathAddress)PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH}));
        List operations = SubsystemParsingTestCase.checkResultAndGetContents((ModelNode)servicesA.executeOperation(operation, new InputStream[0])).asList();
        KernelServices servicesB = this.createKernelServicesBuilder().setBootOperations(operations).build();
        ModelNode modelB = servicesB.readWholeModel();
        super.compare(modelA, modelB);
    }

    @Test
    public void testLegacyOperations() throws Exception {
        LinkedList<ModelNode> ops = new LinkedList<ModelNode>();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinition.PATH});
        PathAddress udpAddress = subsystemAddress.append(new PathElement[]{StackResourceDefinition.pathElement((String)"udp")});
        ModelNode op = Util.createAddOperation((PathAddress)subsystemAddress);
        op.get("default-stack").set("udp");
        ops.add(op);
        op = Util.createAddOperation((PathAddress)udpAddress);
        ModelNode transport = new ModelNode();
        transport.get("type").set("UDP");
        transport.get("socket-binding").set("jgroups-udp");
        ModelNode protocols = new ModelNode();
        String[] protocolList = new String[]{"PING", "MERGE3", "FD_SOCK", "FD", "VERIFY_SUSPECT", "BARRIER", "pbcast.NAKACK2", "UNICAST2", "pbcast.STABLE", "pbcast.GMS", "UFC", "MFC", "FRAG3", "RSVP"};
        for (int i = 0; i < protocolList.length; ++i) {
            ModelNode protocol = new ModelNode();
            protocol.get("type").set(protocolList[i]);
            protocol.get("socket-binding").set("jgroups-udp");
            protocols.add(protocol);
        }
        op.get("transport").set(transport);
        op.get("protocols").set(protocols);
        ops.add(op);
        KernelServices servicesA = this.createKernelServicesBuilder(this.createAdditionalInitialization()).setBootOperations(ops).build();
        Assert.assertTrue((String)"Subsystem boot failed!", (boolean)servicesA.isSuccessfulBoot());
        ModelNode modelA = servicesA.readWholeModel();
        this.validateModel(modelA);
        servicesA.shutdown();
        ModelNode operation = this.createDescribeOperation();
        ModelNode result = servicesA.executeOperation(operation, new InputStream[0]);
        Assert.assertTrue((String)"the subsystem describe operation has to generate a list of operations to recreate the subsystem", (!result.hasDefined("failure-description") ? 1 : 0) != 0);
        List operations = result.get("result").asList();
        servicesA.shutdown();
        KernelServices servicesC = this.createKernelServicesBuilder(this.createAdditionalInitialization()).setBootOperations(operations).build();
        ModelNode modelC = servicesC.readWholeModel();
        this.compare(modelA, modelC);
        this.assertRemoveSubsystemResources(servicesC, this.getIgnoredChildResourcesForRemovalTest());
    }
}

