/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.io.InputStream;
import org.infinispan.server.jgroups.subsystem.OperationTestCaseBase;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;

public class OperationsTestCase
extends OperationTestCaseBase {
    @Test
    public void testSubsystemReadWriteOperations() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getSubsystemReadOperation("default-stack"), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"maximal", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(OperationsTestCase.getSubsystemWriteOperation("default-stack", "new-default"), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getSubsystemReadOperation("default-stack"), new InputStream[0]);
        Assert.assertEquals((String)result.get("failure-description").asString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-default", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", "rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"rack1", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(OperationsTestCase.getTransportWriteOperation("maximal", "TCP", "rack", "new-rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", "rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-rack", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportReadWriteWithParameters() throws Exception {
        KernelServices services = this.buildKernelServices();
        Assert.assertTrue((String)"Could not create services", (boolean)services.isSuccessfulBoot());
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolStackAddOperationWithParameters("maximal2"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportWriteOperation("maximal", "TCP", "rack", "new-rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportReadOperation("maximal", "TCP", "rack"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-rack", (Object)result.get("result").asString());
    }

    @Test
    public void testTransportPropertyReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "log_discard_msgs"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"true", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(OperationsTestCase.getTransportPutPropertyOperation("maximal", "TCP", "log_discard_msgs", "false"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "log_discard_msgs"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"false", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getTransportRemovePropertyOperation("maximal", "TCP", "log_discard_msgs"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getTransportGetPropertyOperation("maximal", "TCP", "log_discard_msgs"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
    }

    @Test
    public void testProtocolReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolStackAddOperationWithParameters("maximal2"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolReadOperation("maximal", "MPING", "socket-binding"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"jgroups-mping", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolWriteOperation("maximal", "MPING", "socket-binding", "new-socket-binding"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolReadOperation("maximal", "MPING", "socket-binding"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-socket-binding", (Object)result.get("result").asString());
    }

    @Test
    public void testProtocolPropertyReadWriteOperation() throws Exception {
        KernelServices services = this.buildKernelServices();
        ModelNode result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"value", (Object)result.get("result").resolve().asString());
        result = services.executeOperation(OperationsTestCase.getProtocolPutPropertyOperation("maximal", "MPING", "name", "new-value"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertEquals((Object)"new-value", (Object)result.get("result").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolRemovePropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        result = services.executeOperation(OperationsTestCase.getProtocolGetPropertyOperation("maximal", "MPING", "name"), new InputStream[0]);
        Assert.assertEquals((String)result.toString(), (Object)"success", (Object)result.get("outcome").asString());
        Assert.assertFalse((boolean)result.get("result").isDefined());
    }
}

