/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.security;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import org.infinispan.server.jgroups.logging.JGroupsLogger;
import org.jboss.as.core.security.RealmUser;
import org.jboss.as.core.security.SubjectUserInfo;
import org.jboss.as.domain.management.AuthMechanism;
import org.jboss.as.domain.management.AuthorizingCallbackHandler;
import org.jboss.as.domain.management.SecurityRealm;
import org.wildfly.security.auth.callback.AvailableRealmsCallback;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;

public class RealmAuthorizationCallbackHandler
implements CallbackHandler {
    private final String mechanismName;
    private final SecurityRealm realm;
    private final String clusterRole;
    private String[] realmList;
    private static final String SASL_OPT_PRE_DIGESTED_PROPERTY = "org.wildfly.security.sasl.digest.pre_digested";

    public RealmAuthorizationCallbackHandler(SecurityRealm realm, String mechanismName, String clusterRole, Map<String, String> mechanismProperties) {
        this.realm = realm;
        this.mechanismName = mechanismName;
        this.clusterRole = clusterRole;
        this.tunePropsForMech(mechanismProperties);
    }

    private void tunePropsForMech(Map<String, String> mechanismProperties) {
        if ("DIGEST-MD5".equals(this.mechanismName)) {
            String[] stringArray;
            String realmStr = mechanismProperties.get("com.sun.security.sasl.digest.realm");
            if (realmStr == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.realm.getName();
            } else {
                stringArray = realmStr.split(" ");
            }
            this.realmList = stringArray;
            Map mechConfig = this.realm.getMechanismConfig(AuthMechanism.DIGEST);
            boolean plainTextDigest = true;
            if (mechConfig.containsKey("org.jboss.as.domain.management.digest.plain_text")) {
                plainTextDigest = Boolean.parseBoolean((String)mechConfig.get("org.jboss.as.domain.management.digest.plain_text"));
            }
            if (!plainTextDigest) {
                mechanismProperties.put(SASL_OPT_PRE_DIGESTED_PROPERTY, "true");
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        ArrayList<Callback> list = new ArrayList<Callback>(Arrays.asList(callbacks));
        Iterator<Callback> it = list.iterator();
        CredentialCallback cb = null;
        while (it.hasNext()) {
            Callback callback = it.next();
            if (callback instanceof AvailableRealmsCallback) {
                ((AvailableRealmsCallback)callback).setRealmNames(this.realmList);
                it.remove();
                continue;
            }
            if (!(callback instanceof CredentialCallback)) continue;
            cb = (CredentialCallback)callback;
        }
        if (!list.isEmpty()) {
            if (cb != null && cb.getAlgorithm().equals("digest-md5")) {
                DigestPasswordAlgorithmSpec spec = (DigestPasswordAlgorithmSpec)cb.getParameterSpec();
                list.add(new NameCallback("User", spec.getUsername()));
                callbacks = list.toArray(new Callback[list.size()]);
            }
            this.getMechCallbackHandler().handle(callbacks);
        }
    }

    private AuthorizingCallbackHandler getMechCallbackHandler() {
        if ("PLAIN".equals(this.mechanismName)) {
            return new DelegatingRoleAwareAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN));
        }
        if ("DIGEST-MD5".equals(this.mechanismName)) {
            return new DelegatingRoleAwareAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.DIGEST));
        }
        if ("GSSAPI".equals(this.mechanismName)) {
            return new DelegatingRoleAwareAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.PLAIN));
        }
        if ("EXTERNAL".equals(this.mechanismName)) {
            return new DelegatingRoleAwareAuthorizingCallbackHandler(this.realm.getAuthorizingCallbackHandler(AuthMechanism.CLIENT_CERT));
        }
        throw new IllegalArgumentException("Unsupported mech " + this.mechanismName);
    }

    SubjectUserInfo validateSubjectRole(SubjectUserInfo subjectUserInfo) {
        for (Principal principal : subjectUserInfo.getPrincipals()) {
            if (!this.clusterRole.equals(principal.getName())) continue;
            return subjectUserInfo;
        }
        throw JGroupsLogger.ROOT_LOGGER.unauthorizedNodeJoin(subjectUserInfo.getUserName());
    }

    private static <T extends Callback> T findCallbackHandler(Class<T> klass, Callback[] callbacks) {
        for (Callback callback : callbacks) {
            if (!klass.isInstance(callback)) continue;
            return (T)callback;
        }
        return null;
    }

    class DelegatingRoleAwareAuthorizingCallbackHandler
    implements AuthorizingCallbackHandler {
        private final AuthorizingCallbackHandler delegate;

        DelegatingRoleAwareAuthorizingCallbackHandler(AuthorizingCallbackHandler acbh) {
            this.delegate = acbh;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            AuthorizeCallback acb = (AuthorizeCallback)RealmAuthorizationCallbackHandler.findCallbackHandler(AuthorizeCallback.class, callbacks);
            if (acb != null) {
                String authenticationId = acb.getAuthenticationID();
                String authorizationId = acb.getAuthorizationID();
                acb.setAuthorized(authenticationId.equals(authorizationId));
                int realmSep = authorizationId.indexOf(64);
                RealmUser realmUser = realmSep < 0 ? new RealmUser(authorizationId) : new RealmUser(authorizationId.substring(realmSep + 1), authorizationId.substring(0, realmSep));
                ArrayList<Principal> principals = new ArrayList<Principal>();
                principals.add((Principal)realmUser);
                this.createSubjectUserInfo(principals);
            } else {
                this.delegate.handle(callbacks);
            }
        }

        public SubjectUserInfo createSubjectUserInfo(Collection<Principal> principals) throws IOException {
            SubjectUserInfo subjectUserInfo = this.delegate.createSubjectUserInfo(principals);
            return RealmAuthorizationCallbackHandler.this.validateSubjectRole(subjectUserInfo);
        }
    }
}

